<?php 
$clinicmaster_options = clinicmaster_dzbase()->option();
$clinicmaster_query_result = get_query_var('clinicmaster_query_result');

foreach ( $clinicmaster_query_result->posts as $post ){ 		
	
	/* implement post layout icons on listing post */
	$post_id = get_the_ID();
	$post_setting = get_post_meta($post_id, '_post_settings', true);
	$post_layout = isset($post_setting['post_layout']) ? $post_setting['post_layout'] : '';
	
	$excerpt = $post->post_excerpt;
	$content = $post->post_content;
	$short_description = clinicmaster_short_description($excerpt, $content, 25);	
	
	$post_layout_class = '';
	if($post_layout == 'link_post')
	{$post_layout_class = 'fa-link';}

	if($post_layout == 'audio_post')
	{$post_layout_class = 'fa-soundcloud';}

	if($post_layout == 'video_post')
	{$post_layout_class = 'fa-play';}

	if($post_layout == 'slider_post_1' || $post_layout == 'slider_post_2')
	{$post_layout_class = 'fa-picture-o';}
		
	$post_title = clinicmaster_trim(get_the_title(), 7);
	
	$featured = get_post_meta(get_the_ID(), 'featured_post');
	$featured_class = (!empty($featured) && $featured[0] == 1) ? ' featured ' : '';
    
    $author_name = get_the_author_meta('display_name', $post->post_author);
    
	$no_image_class = (!has_post_thumbnail())?'no-image':'';
	?>
	<div  id="post-<?php the_ID(); ?>" <?php echo post_class('col-xl-12 col-md-12 m-b30 '.$featured_class.' '.$no_image_class); ?>>
		<div class="dz-card style-4 blog-half">
			<?php if(has_post_thumbnail()) { ?>
			<div class="dz-media">
				<a href="<?php echo esc_url(get_permalink()); ?>">
					<?php the_post_thumbnail('medium'); ?>
				</a>
			</div>
			<?php } ?>
			<div class="dz-info">
				<div class="dz-meta">
					<ul>
						<li class="post-date">
							<?php echo esc_html(get_the_date()); ?>
						</li>
						<li class="post-author">
							<i class="fa-solid fa-user"></i>
							<?php echo esc_html__('By', 'clinicmaster'); ?> 
							<a href="<?php echo esc_url(get_author_posts_url( $post->post_author )); ?>">	
								<?php echo esc_html($author_name);?>
							</a>
						</li>
						<li class="dz-comment m-0">
							<a href="<?php echo esc_url(get_the_permalink(get_the_id()).'#comments');?>">
								<i class="fa-solid fa-message"></i>
								<span>
									<?php comments_number( '0', '1', '%' ); ?>
								</span>
							</a>
						</li>
					</ul>
				</div>
				<?php if(!empty($post_title)){ ?>
				<h5 class="dz-title">
					<a href="<?php echo esc_url(get_permalink()); ?>">
						<?php echo wp_kses($post_title, clinicmaster_allowed_html_tag()); ?>
					</a>
				</h5>
				<?php }
				if(!empty($short_description)){ ?>
				
					<p>
						<?php echo esc_html( $short_description );?>
					</p>
				
				<?php } 
				if(!empty($post_title)){ ?>
					<a href="<?php echo esc_url(get_permalink()); ?>" class="btn-link icon-link-hover-end">
						<?php echo esc_html__('Read More','clinicmaster'); ?>
						<i class="fas fa-arrow-right m-l5"></i>
					</a>
				<?php } ?>
			</div>
		</div>
		<?php
			if(is_sticky())
			{
				echo '<span class="sticky-icon"><i class="fa fa-thumbtack"></i></span>';
			}
		?>
	</div>
	<?php
}
wp_reset_postdata();
?>