<?php 
$myticket = $getdata->get_user_ticket(); 
if (is_wp_error($myticket)) {
    // Log or handle the error gracefully
    error_log($myticket->get_error_message());
    return false;
} 
?>

<div class="col-xl-12 col-xxl-12">
	<div class="card artical-box default" id="artical-list">
		<div class="card-header">
			<h5 class="card-title"><?php echo esc_html__('My Tickets', 'clinicmaster'); ?></h5>
		</div>
		<div class="ticket-bx-wrapper no-action-needed" id="artare">
			<div class="ticket-body">
			<?php if(isset($myticket) && !empty($myticket['data'])){
				rsort($myticket['data']);
				foreach($myticket['data'] as $val){
				$id = $val['id'];
				$user_id = $val['user_id'];
				$title = !empty($val['title']) ? $val['title'] : '';
				$private = !empty($val['private']) ? $val['private'] : '';
				$status = !empty($val['status']) ? $val['status'] : '';
				?>
				<div class="media ticket-list">
					<a href="<?php echo esc_url(admin_url( 'admin.php?page=dz-my-ticket&id='.$id.'&user_id='.$user_id.'&title='.$title.'&private'.$private.'&status='.$status )); ?>" class="list-inner">
						<?php 
						 $user_img = 'https://support.w3itexperts.com/public/images/no-user.png';	
						
						if(!empty($val['user_img'])){
							$user_img = 'https://support.w3itexperts.com/public/storage/user-images/'.$val['user_img'];	
							
						} ?>
						<img class="user-img mr-3 rounded-circle" width="60" src="<?php echo esc_url($user_img); ?>" alt="User Image">
						<div class="media-body">
							<?php if(!empty($val['username'])){ ?>
								<p class="mb-0 ticket-user"> <?php echo esc_html($val['username']); ?>  </p>
							<?php }
							if(!empty($val['title'])){
								$private = !empty($val['private']) ? 'fa fa-lock' : 'fa fa-unlock';
								?>
							<h4 class="ticket-title">
								<i class="<?php echo esc_attr($private); ?> mr-2"></i>
								<?php echo esc_html($val['title']); ?>
							</h4>
							<?php } ?>
							<ul class="deceription">
								<li>
									<?php
									$updated_at_obj = new DateTime($val['updated_at']); // Assuming $val['updated_at'] is a valid datetime string.
									$time = $updated_at_obj->format('h:i A'); // Formats the time in 12-hour format with AM/PM.
									$date = $updated_at_obj->format('F d, Y'); // Formats the date as "Month day, Year".

									?>
									<i class="fa fa-calendar" aria-hidden="true"></i>
									<span class="pr-3"><?php echo esc_html__('Updated ', 'clinicmaster'); ?><?php echo esc_html($date); ?><?php echo esc_html__(' at ', 'clinicmaster'); ?><?php echo esc_html($time); ?></span>
								</li>
								<?php if(!empty($val['total_tickets'])){ ?>
								<li>
									<i class="fa fa-commenting" aria-hidden="true"></i>
									<span class="pr-3"><?php echo esc_html($val['total_tickets']); ?></span>
								</li>
								<?php } ?>
							</ul>
						</div>
					</a>
				</div>	
				<?php }
			}else{ 
				echo 'Data Not Found';
			}
			?>
			
			</div>
		</div>
	</div>
</div>
