<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class DZPregnacytimeline extends Widget_Base 
{
    public function get_name() {
        return 'dz-Pregnacy-timeline';
    }

    public function get_title() {
        return esc_html__('Pregnancy Timeline', 'DZ_TH_DOMAIN');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['clinicmaster'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'general',
            [
                'label' => esc_html__('General', 'DZ_TH_DOMAIN'),
            ]
        );

        // Title Field
        $this->add_control(
            'about_us_2_element_title',
            [
                'label'       => esc_html__('Title', 'DZ_TH_DOMAIN'),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your title', 'DZ_TH_DOMAIN'),
                'default'     => esc_html__('Taking Care of You and Your Baby Pregnancy Timeline', 'DZ_TH_DOMAIN'),
            ]
        );

        // Repeater Field
        $this->add_control(    
            'form_fields',
            [
                'label'    => __('Form Fields', 'DZ_TH_DOMAIN'),
                'type'     => Controls_Manager::REPEATER,
                'fields'   => [

                    [
                        'name'        => 'button_text',
                        'label'       => esc_html__('Button Text', 'DZ_TH_DOMAIN'),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                        'placeholder' => esc_html__('Enter your button text', 'DZ_TH_DOMAIN'),
                        'default'     => esc_html__('Click Here', 'DZ_TH_DOMAIN'),
                    ],

                    [
                        'name'        => 'button_link',
                        'label'       => esc_html__('Button Link', 'DZ_TH_DOMAIN'),
                        'type'        => Controls_Manager::URL,
                        'label_block' => true,
                        'placeholder' => esc_html__('Enter your link', 'DZ_TH_DOMAIN'),
                    ],

                    [
						'name'        => 'listing_background_image',
						'label'       => esc_html__('Listing Background Image', 'DZ_TH_DOMAIN'),
						'type'        => Controls_Manager::MEDIA,
						'default'     => [
							'url' => get_template_directory_uri() . '/wp-content/uploads/2025/04/img2.png',
						],
						'label_block' => true,
					]
                ],
                
                'default'  => [
                    [
                        'button_text' => esc_html__('Learn More', 'DZ_TH_DOMAIN'),
                        'button_link' => ['url' => '#'],
                        'listing_background_image' => ['url' => 'wp-content/uploads/2025/04/img2.png'],
                    ],
                ],

                'title_field' => '{{{ button_text }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        DZTemplate::show_dz_template('dz-inc/elementor/elements/pregnancy_timeline.php', $settings);
       
    }
}
