<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZCounterBox1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-counter-box-1';
	}
	
	public function get_title() {
		return esc_html__('Counter Box 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-counter';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'counter_box_1_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'	 	=> esc_html__( '300+ Appointment Booking Confirm for this Week', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'counter_box_1_element_img',
			[
				'label' 		=> esc_html__( 'Background Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA
			]
		);
		$this->add_control(
			'counter_box_1_background_color',
			[
				'label'        => esc_html__('Enable Background Color', DZ_TH_DOMAIN),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__('On', DZ_TH_DOMAIN),
				'label_off'    => esc_html__('Off', DZ_TH_DOMAIN),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'repeater',
			[
				'label' => esc_html__( 'Repeater', DZ_TH_DOMAIN ),
			]
		);
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'counter_box_1_element_item_title',
			[
				'label' 	=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Specialists', DZ_TH_DOMAIN ),
			]
		);
		$repeater->add_control(
			'counter_box_1_element_item_number',
			[
				'label' 	=> esc_html__( 'Counter Number', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'placeholder'=> esc_html__( 'Enter your counder number', DZ_TH_DOMAIN ),
				'default' => '200',
				
			]
		);
		
		$repeater->add_control(
			'counter_box_1_element_item_symbol',
			[
				'label' 	=> esc_html__( 'Symbol', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXT,
				'default' => '+',
				
			]
		);
		
		
		
		$this->add_control(
			'counter_box_1_element_item',
			[
				'label' 		=> esc_html__( 'Item List', DZ_TH_DOMAIN ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'counter_box_1_element_item_title' 		=> esc_html__( 'Specialists', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> '200',
						'counter_box_1_element_item_symbol' 	=>'+',
					],
					[
						'counter_box_1_element_item_title' 		=> esc_html__( 'Happy Patients', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> '45',
						'counter_box_1_element_item_symbol' 	=>'K',
					],
					[
						'counter_box_1_element_item_title' 		=> esc_html__( 'Winning Awards', DZ_TH_DOMAIN ),
						'counter_box_1_element_item_number' 	=> '150',
						'counter_box_1_element_item_symbol' 	=>'+',
					],
					
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'counter_box_1_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-3',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/counter_box_1_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}