<?php

require_once DZ_ELEMENTOR_ROOT . '/custom_icons/icon_functions.php'; 

class DZIcons {

	/**
	 * Core singleton class
	 *
	 * @var self - pattern realization
	 */
	private static $_instance;

	/**
	 * Constructor.
	 */
	private function __construct() {

		// load icons
		add_action( 'elementor/controls/controls_registered', array( $this, 'icons_filters' ), 100, 1 );
		add_filter( 'elementor/icons_manager/additional_tabs', array( $this, 'icons_filters_new' ), 9999999, 1 );
	}

	/**
	 * Get the instance of Elementor Custom Icons
	 *
	 * @return self
	 */
	public static function getInstance() {

		if ( ! ( self::$_instance instanceof self ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @param mixed $instance
	 */
	public static function setInstance( $instance ) {
		self::$_instance = $instance;
	}


	/**
	 * Add custom icons to Elementor registry
	 *
	 * @param object $controls_registry
	 * @return void
	 */
	public function icons_filters( $controls_registry ) {
		
		// Get existing icons
		$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
		
		$new_icons = dz_get_ele_custom_icon();
			
		$icons = array_merge( $new_icons, $icons );	
		
		
		

		
		$controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );

	}


	/**
	 * Add custom icons to Elementor Icons tabs (new in v2.6+)
	 *
	 * @param array $tabs Additional tabs for new icon interface.
	 * @return array $tabs
	 */
	public function icons_filters_new( $tabs = array() ) {
		
		$newicons = [];
		
		$newicons = dz_get_ele_icon_config();
		
		return array_merge( $tabs, $newicons );
	}

}


DZIcons::getInstance();




	