<?php

if ( ! class_exists( 'Theme_Actiovation_Check' ) ) {

class Theme_Actiovation_Check {

	public $api_url = 'https://support.w3itexperts.com/apis/verify_license';

	public function __construct() {
		
	//Theme purchase code verification and activation
		//add_action( 'wp_ajax_dz_theme_verify',   array( $this,'dz_theme_verification' ) );
		//add_action( 'wp_ajax_nopriv_dz_theme_verify',  array( $this,'dz_theme_verification' ) );	
		
		if(!empty($_COOKIE['purchase_code_check'])){	
			$this->dz_theme_verification();
		}
		
	}
	

	public function dz_theme_verification(){

		global $wp_version;
		$status = array( 'error_message' => false );
		$purchase_code = get_option( 'verified_code' );
		$args = array(
			'body'       => array(
				'purchase_code'	=> $purchase_code,
				'url'	        => esc_url( site_url( '/' ) ),
				'server_data'	=> $_SERVER
			)
		);
		
		$response = wp_remote_post( esc_url_raw( $this->api_url ), $args );		
		$response_code    = wp_remote_retrieve_response_code( $response );
		$response_message = wp_remote_retrieve_response_message( $response );
		if ( empty( $response_code ) && is_wp_error( $response ) ) {
			return $response;
		}

		if ( 200 !== $response_code && ! empty( $response_message ) ) {
			return new WP_Error( $response_code, $response_message );
		}
		if ( 200 !== $response_code ) {
			return new WP_Error( $response_code, esc_html__( 'An unknown API error occurred.', DZ_TH_DOMAIN ) );
		}
		$data = wp_remote_retrieve_body( $response ); 
	    $data = json_decode( $data, true );
		
		if ( false === $data['status'] ) {
			update_option( 'verified_purchase_status', '' );
			update_option( 'verified_code', '' );
		}
		
		
	}
  
}
new Theme_Actiovation_Check();
}