<?php
/**
 * Helper functions for the theme
 *
 * @package ClinicMaster
 */
/**
 * Get theme option based on its id.
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 *
 * It have some redux options function who we cannot write in theme because of themeforest rules
 *
 */


/**
 * Body classes to body_class filter.
 */
function dz_custom_body_class($classes) {
	//get the custom classes from theme options
	$custom_classes = dexignzone_get_opt('body_class');

	if(!empty($custom_classes)) {
		// add 'custom classes' to the $classes array
		$classes[] = $custom_classes;
	}

	// return the $classes array
	return $classes;
}

add_filter('body_class', 'dz_custom_body_class');



/**
 * Minify css
 *
 * @param  string $css
 *
 * @return string
 *
 * function prefix is theme name because this function is using in theme and you cannot put this function in theme folder because of themeforest rules
 *
 */
function clinicmaster_css_minifier( $css ) 
{
	// Normalize whitespace
	$css = preg_replace( '/\s+/', ' ', $css );
	// Remove spaces before and after comment
	$css = preg_replace( '/(\s+)(\/\*(.*?)\*\/)(\s+)/', '$2', $css );
	// Remove comment blocks, everything between /* and */, unless
	// preserved with /*! ... */ or /** ... */
	$css = preg_replace( '~/\*(?![\!|\*])(.*?)\*/~', '', $css );
	// Remove ; before }
	$css = preg_replace( '/;(?=\s*})/', '', $css );
	// Remove space after , : ; { } */ >
	$css = preg_replace( '/(,|:|;|\{|}|\*\/|>) /', '$1', $css );
	// Remove space before , ; { } ( ) >
	$css = preg_replace( '/ (,|;|\{|}|\(|\)|>)/', '$1', $css );
	// Strips leading 0 on decimal values (converts 0.5px into .5px)
	$css = preg_replace( '/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $css );
	// Strips units if value is 0 (converts 0px to 0)
	$css = preg_replace( '/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $css );
	// Converts all zeros value into short-hand
	$css = preg_replace( '/0 0 0 0/', '0', $css );
	// Shortern 6-character hex color codes to 3-character where possible
	$css = preg_replace( '/#([a-f0-9])\\1([a-f0-9])\\2([a-f0-9])\\3/i', '#\1\2\3', $css );

	return trim( $css );
}

/**
 * Check Color Code
 *
 * @param  string $css
 *
 * @return string
 *
 * function prefix is theme name because this function is using in theme and you cannot put this function in theme folder because of themeforest rules
 *
 */

/* Using in Theme CSS Generator File*/
function clinicmaster_is_valid_color( $color ) 
{
	$color = preg_replace( "/\s+/m", '', $color );

	if ( $color === 'transparent' ) {
		return true;
	}

	if ( '' == $color ) {
		return false;
	}

	// Hex format
	if ( preg_match( "/(?:^#[a-fA-F0-9]{6}$)|(?:^#[a-fA-F0-9]{3}$)/", $color ) ) {
		return true;
	}

	// rgb or rgba format
	if ( preg_match( "/(?:^rgba\(\d+\,\d+\,\d+\,(?:\d*(?:\.\d+)?)\)$)|(?:^rgb\(\d+\,\d+\,\d+\)$)/", $color ) ) {
		preg_match_all( "/\d+\.*\d*/", $color, $matches );
		if ( empty( $matches ) || empty( $matches[0] ) ) {
			return false;
		}

		$red   = empty( $matches[0][0] ) ? $matches[0][0] : 0;
		$green = empty( $matches[0][1] ) ? $matches[0][1] : 0;
		$blue  = empty( $matches[0][2] ) ? $matches[0][2] : 0;
		$alpha = empty( $matches[0][3] ) ? $matches[0][3] : 1;

		if ( $red < 0 || $red > 255 || $green < 0 || $green > 255 || $blue < 0 || $blue > 255 || $alpha < 0 || $alpha > 1.0 ) {
			return false;
		}
	} else {
		return false;
	}

	return true;
}

/**
 * Header Tracking Code to wp_head hook.
 */
function dz_header_code() {
	$site_header_code = dexignzone_get_opt( 'site_header_code' );
	if ( $site_header_code != '' ) {
		echo '<script>'.
				wp_kses( $site_header_code, wp_kses_allowed_html() ).
			'</script>';
	} 
}

add_action( 'wp_head', 'dz_header_code' );

/**
 * Footer Tracking Code to wp_footer hook.
 */
function dz_footer_code() {
	$site_footer_code = dexignzone_get_opt( 'site_footer_code' );
	if ( $site_footer_code != '' ) {
		echo '<script>'.
				wp_kses( $site_footer_code, wp_kses_allowed_html() ).
			'</script>';
	}
}

add_action( 'wp_footer', 'dz_footer_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_css_code() {
	$custom_css = dexignzone_get_opt( 'css_editor' );

	if ( trim($custom_css) != '' ) {
		echo '<style>'
			. $custom_css .
		'</style>';
	}
}

add_action( 'wp_footer', 'dz_css_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_js_code() {
	$custom_javascript = dexignzone_get_opt( 'js_editor' );

	if ( trim($custom_javascript) != '' ) {
		echo '<script type="text/javascript">'
			. $custom_javascript .
		'</script>';
	}
}

add_action( 'wp_footer', 'dz_js_code' );

/**
 * Footer JS Code to wp_footer hook.
 */
function dz_html_code() {
	$custom_html = dexignzone_get_opt( 'html_editor' );
	if ( trim($custom_html) != '' ) {
		echo '<div class="min-container">' . $custom_html . '</div>';
	}
}

add_action( 'wp_footer', 'dz_html_code' );