<?php 
$element_content = !empty($pricing_table_2_element_content) ? $pricing_table_2_element_content : 'content-inner';
 ?>
<section class="<?php echo esc_attr($element_content); ?>">
		<div class="container">
			<?php if(!empty($pricing_table_2_element_title) || !empty($pricing_table_2_element_description) ){ ?>
				<div class="section-head style-1 m-b30 text-center">
					<?php if(!empty($pricing_table_2_element_title)){ ?>
						<h2 class="title"><?php echo esc_html($pricing_table_2_element_title); ?></h2>
					<?php }
					if(!empty($pricing_table_2_element_description)){ ?>
						<p><?php echo wp_kses($pricing_table_2_element_description,'string'); ?></p>
					<?php } ?>
				</div>
			<?php } 
			if(!empty($pricing_table_2_element_plan_monthly) || !empty($pricing_table_2_element_plan_yearly)){ ?>
				<div class="toggle-tabs toggle-tabs1 monthly">
				<?php if(!empty($pricing_table_2_element_plan_monthly)){ ?>
					<span class="monthly"><?php echo esc_html($pricing_table_2_element_plan_monthly); ?></span>
				<?php } 
				if(!empty($pricing_table_2_element_plan_yearly)){	?>
					<span class="yearly"><?php echo esc_html($pricing_table_2_element_plan_yearly); ?></span>
				<?php } ?>
				</div>
			<?php } ?>
			<?php if(!empty($pricing_table_2_element_item)){ ?>
			<div class="row">
				<?php foreach($pricing_table_2_element_item as $val){
					
					$yearly_price = $val['pricing_table_2_element_item_yearly_price'];
					$munth_price = $val['pricing_table_2_element_item_munth_price'];
					$feature_text = $val['pricing_table_2_element_item_feature_text'];
					$button_text = $val['pricing_table_2_element_item_button_text'];
					$button_link = $val['pricing_table_2_element_item_button_link'];
					$item_text = $val['pricing_table_2_element_item_text'];
					$content = $val['pricing_table_2_element_item_content'];
					$item_img = $val['pricing_table_2_element_item_img'];
					
					?>
					<div class="col-xl-6 m-b30">
						<div class="pricingtable-wrapper style-2">
							<div class="pricingtable-inner">
								<?php if(!empty($item_img['id'])){ ?>
									<div class="dz-media">
										<img src="<?php echo esc_url($item_img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
									</div>
								<?php } ?>
								<div class="pricingtable-info">
								<?php if(!empty($munth_price)){ ?>
									<div class="pricingtable-price month"> 
										<h2 class="pricingtable-bx"><?php echo esc_html($munth_price); ?><small>/ <?php echo esc_html__(' Monthly','clinicmaster'); ?></small></h2>
									</div>
								<?php } ?>
								<?php if(!empty($yearly_price)){ ?>
									<div class="pricingtable-price year"> 
										<h2 class="pricingtable-bx"><?php echo esc_html($yearly_price); ?><small>/ <?php echo esc_html__(' Yearly','clinicmaster'); ?></small></h2>
									</div>
								<?php } ?>
								<?php if(!empty($feature_text)){ ?>
									<div class="pricingtable-title">
										<h3 class="title"><?php echo esc_html($feature_text); ?></h3>
									</div>
								<?php } ?>
								<?php if(!empty($content)){ ?>
									<div class="pricingtable-list">
										<ul class="pricingtable-features">
										<?php echo wp_kses($content, clinicmaster_allowed_html_tag()); ?>
										</ul>
									</div>
								<?php } ?>
								<?php if(!empty($button_link) && !empty($button_text)){ ?>
									<div class="pricingtable-button">
										<a href="<?php echo esc_url($button_link); ?>" class="btn btn-secondary w-100 btn-hover1"><span><?php echo esc_html($button_text); ?></span></a>
									</div>
								<?php } ?>
								</div>
							</div>
							<?php if(!empty($item_text)){ ?>
								<span class="vertical-text"><?php echo esc_html($item_text); ?></span>	
							<?php } ?>
						</div>
					</div>
				<?php } ?>
			</div>
			<?php } ?>
		</div>
	</section>