<?php

$clinicmaster_option = getDZThemeReduxOption();
$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
$general_phone_text     = !empty($clinicmaster_option['general_phone_text']) ? $clinicmaster_option['general_phone_text']: '';
$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:''; 
$post_type = 'dz_faq';
$query_args = array(
	'post_type'         => $post_type,
	'post_status'       => 'publish',
	'posts_per_page'    => $faq_listing_3_element_no_of_posts,
	'order'             => $faq_listing_3_element_order,
	'orderby'           => $faq_listing_3_element_orderby,
	'ignore_sticky_posts' => true,
);

if(!empty($faq_listing_3_element_posts_in_categories) && !empty($faq_listing_3_element_posts_in_categories[0]))
{			
	
	$faq_listing_3_element_posts_in_categories1 = clinicmaster_get_cat_id_by_slug($faq_listing_3_element_posts_in_categories,'faq_category');
	
	$query_args['tax_query'][] = array(
	'taxonomy' => 'faq_category',
	'field' => 'id',
	'terms' => $faq_listing_3_element_posts_in_categories1,
	'operator' => 'IN'
	); 
	$faq_listing_3_element_posts_in_categories = implode(',',$faq_listing_3_element_posts_in_categories);
}else{
	$faq_listing_3_element_posts_in_categories = '';
}	


$query = new WP_Query($query_args);

$element_content = !empty($faq_listing_3_element_content) ? $faq_listing_3_element_content : 'content-inner-2';



if($query->have_posts()) {
	?>
<section class="bg-light <?php echo esc_attr($element_content); ?>">
			<div class="container">
				<div class="row justify-content-center">
					<div class="col-xl-10">
						<div class="content-bx style-11 bg-white">
							<div class="section-head style-1 text-center">
								<?php if(!empty($faq_listing_3_element_title)){ ?>
									<h2 class="title "><?php echo esc_html($faq_listing_3_element_title); ?></h2>
								<?php } 
								if(!empty($faq_listing_3_element_description)){ ?>
									<p><?php echo wp_kses($faq_listing_3_element_description, 'string'); ?></p>
								<?php } ?>
								
							</div>
							<div class="accordion dz-accordion style-1 accordion-lg" id="accordionExample">
								
								<?php 
							$num = 1;
							while($query->have_posts())
							{ 	
								$query->the_post();
								global $post ;
								$post_id  = $post->ID;
								$post_title =  clinicmaster_trim($post->post_title, 8);
								$excerpt = $post->post_excerpt;
								$content = $post->post_content;
								$short_description = clinicmaster_short_description($excerpt, $content, $faq_listing_3_element_text_limit);
									$active = ($num == 1) ? 'show' :'';
									$collapsed = ($num > 1) ? 'collapsed' :'';
								  ?>
									<div class="accordion-item ">
									<?php if(!empty($post_title)){ ?>
										<h2 class="accordion-header">
											<button class="accordion-button <?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo esc_attr($num); ?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($num); ?>">
												<?php echo esc_html($post_title); ?>
											</button>
										</h2>
									<?php } 
									if(!empty($short_description)){ ?>
										<div id="collapseOne<?php echo esc_attr($num); ?>" class="accordion-collapse collapse <?php echo esc_attr($active); ?>" data-bs-parent="#accordionExample">
											<div class="accordion-body">
												<p><?php echo wp_kses($short_description, 'string'); ?></p>
											</div>
										</div>
									<?php } ?>
									
									</div>
								<?php $num++;
							} ?>	
								
								
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
	


<?php 
} ?>