<?php 

$clinicmaster_option = getDZThemeReduxOption();
$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:'';

$style = !empty($contact_form_2_element_style) ? $contact_form_2_element_style : 'style_1';
$element_content = !empty($contact_form_2_element_content) ? $contact_form_2_element_content : 'content-inner';
$zoom = 15;
$api_key = esc_html( get_option( 'elementor_google_maps_api_key' ) );
if(!empty($address)){
	$params = [
		rawurlencode($address),
		absint( $zoom ),
	];
	if ( $api_key ) {
		$params[] = $api_key;

		$url = 'https://www.google.com/maps/embed/v1/place?key=%3$s&q=%1$s&amp;zoom=%2$d';
	} else {
		$url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
	}
}
$form_image = $contact_form_2_element_form_bg_img;
$img = $contact_form_2_element_img;
$img2 = $contact_form_2_element_img2;
$img3 = $contact_form_2_element_img3;
if($style == 'style_1' ){
	?>
		<div class="dz-bnr-inr style-2 dz-bnr-inr-md dz-bnr-content">
			<div class="container">
				<div class="dz-bnr-inr-entry">
					<div class="dz-bnr-inr-flex">
						<div class="bnr-info">
							<?php if(!empty($contact_form_2_element_title)){ ?>
								<h1 class="fw-semibold"><?php echo wp_kses($contact_form_2_element_title,clinicmaster_allowed_html_tag()); ?></h1>
							<?php } ?>
							<?php if(!empty($contact_form_2_element_description)){ ?>
								<p><?php echo wp_kses($contact_form_2_element_description, 'string'); ?></p>
							<?php } ?>
							
							<?php $num2 = 1;
							if(!empty($contact_form_2_element_item)){ ?>					
					
								<div class="info-widget style-16">
									<div class="row g-xl-5 g-4">
										<?php foreach($contact_form_2_element_item as $val){
											$title = $val['contact_form_2_element_item_title'];
											$description = $val['contact_form_2_element_item_description'];
											$icon = $val['contact_form_2_element_item_icon'];
											$bgclass2 = ($num2 == 2) ? 'bg-secondary' : 'bg-primary';
											?>
										<div class="col-xl-6 col-lg-12 col-md-6">
											<div class="icon-bx-wraper style-1 align-items-center">
											<?php if(!empty($icon['value'])){ ?>
												<div class="icon-bx <?php echo esc_attr($bgclass2); ?>">
													<span class="icon-cell">
														<?php 
														if(!empty($icon['value']['id']) && ($icon['library'] == 'svg') ){ 
															echo wp_get_attachment_image( $icon['value']['id'], 'thumbnail' ); 
														}elseif(!empty($icon['value'])){ ?>
															<i class="<?php echo esc_attr($icon['value']); ?>"></i>
														<?php } ?>
													</span>
												</div>
											<?php } ?>
												<div class="icon-content">
													<?php if(!empty($title)){ ?>
													<h5 class="dz-title fw-semibold"><?php echo esc_html($title); ?></h5>
												<?php }
												if(!empty($description)){	?>
													<p><?php echo wp_kses($description,clinicmaster_allowed_html_tag()); ?></p>
												<?php } ?>
													
												</div>
											</div>
										</div>
										<?php $num2++; 
										} ?>
									</div>
								</div>
							
							<?php } ?>
							<?php if(!empty($general_phone_number)){ ?>
							<a href="tel:+11234567890" class="btn btn-xl btn-icon btn-primary btn-rounded btn-shadow mb-3 mb-sm-0">
							<?php if(!empty($general_phone_icon)){ ?>
								<span class="left-icon">
									<i class="<?php echo esc_attr($general_phone_icon); ?>"></i>
								</span>
							<?php }
							echo esc_html($general_phone_number); 	?>
							</a>
							<?php } ?>
						</div>
						<div class="form-wrapper style-1 m-l40">
							<div class="form-body bg-white">
								<?php if(!empty($contact_form_2_element_form_text) || !empty($contact_form_2_element_form_description)){ ?>
								<div class="section-head style-1 m-b30">
									<?php if(!empty($contact_form_2_element_form_text)){ ?>
										<h2 class="title"><?php echo wp_kses($contact_form_2_element_form_text,clinicmaster_allowed_html_tag()); ?></h2>
									<?php } ?>
									<?php if(!empty($contact_form_2_element_form_description)){ ?>
										<p><?php echo wp_kses($contact_form_2_element_form_description, 'string'); ?></p>
									<?php } ?>
								</div>
							<?php } ?>
								
								<?php if(!empty($contact_form_2_element_contact_form)){ ?>
								
									<?php 
										$post = get_page_by_path($contact_form_2_element_contact_form,OBJECT,'wpcf7_contact_form');
										if(!empty($post->ID)){
											echo do_shortcode('[contact-form-7 id="'.$post->ID.'"]');
										}
									?>
								
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php if(!empty($img2['id'])){ ?>
			<div class="item1"><img class="move-1" src="<?php  echo esc_url($img2['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>"></div>
			<?php } ?>
			<?php if(!empty($img['id'])){ ?>
			<div class="item2"><img class="move-2" src="<?php  echo esc_url($img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>"></div>
			<?php } ?>
			<?php if(!empty($img3['id'])){ ?>
			<div class="item3"><img class="move-3" src="<?php  echo esc_url($img3['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>"></div>
			<?php } ?>
			
			<svg class="banner-shape" viewBox="0 0 1920 180" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M1921 164.375C1734.2 -139.225 527.167 48.8754 -33 180.875H1921V164.375Z" fill="var(--bs-primary)"></path>
				<path d="M1921 164.375C1714.2 -59.2247 527.167 58.8754 -33 180.875H1921V164.375Z" fill="white"></path>
			</svg>
			<div class="banner-shape4"></div>
			<div class="banner-shape5"></div>
		</div>

<?php }elseif($style == 'style_2'){ ?>

<section class="<?php echo esc_attr($element_content); ?>">
	<div class="container">
		<div class="row">
			<div class="col-xl-7 col-lg-6 m-b30">
				<div class="map-wrapper style-1">
				<?php if(!empty($address)){ ?>
					<iframe loading="lazy"
						src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
						title="<?php echo esc_attr( $address ); ?>"
						aria-label="<?php echo esc_attr( $address ); ?>">
					</iframe>
				<?php }
				$num = 1;
				if(!empty($contact_form_2_element_item)){ ?>					
					<div class="item1">
						<div class="info-widget style-16">
							<div class="row g-xl-5 g-4">
								<?php foreach($contact_form_2_element_item as $val){
									$title = $val['contact_form_2_element_item_title'];
									$description = $val['contact_form_2_element_item_description'];
									$icon = $val['contact_form_2_element_item_icon'];
									$bgclass = ($num == 2) ? 'bg-secondary' : 'bg-primary';
								
									?>
								<div class="col-xl-6 col-lg-12 col-md-6">
									<div class="icon-bx-wraper style-1 align-items-center">
									<?php if(!empty($icon['value'])){ ?>
										<div class="icon-bx <?php echo esc_attr($bgclass); ?>">
											<span class="icon-cell">
												<?php 
												if(!empty($icon['value']['id']) && ($icon['library'] == 'svg') ){ 
													echo wp_get_attachment_image( $icon['value']['id'], 'thumbnail' ); 
												}elseif(!empty($icon['value'])){ ?>
													<i class="<?php echo esc_attr($icon['value']); ?>"></i>
												<?php } ?>
											</span>
										</div>
									<?php } ?>
										<div class="icon-content">
											<?php if(!empty($title)){ ?>
											<h5 class="dz-title fw-semibold"><?php echo esc_html($title); ?></h5>
										<?php }
										if(!empty($description)){	?>
											<p><?php echo wp_kses($description,clinicmaster_allowed_html_tag()); ?></p>
										<?php } ?>
											
										</div>
									</div>
								</div>
								<?php $num++;
								} ?>
							</div>
						</div>
					</div>
				<?php } ?>
				</div>
			</div>
			<div class="col-xl-5 col-lg-6 m-b30">
				<div class="form-wrapper style-1 m-l40">
					<div class="form-body bg-secondary background-blend-burn" <?php if(!empty($form_image['id'])){ ?> style="background-image: url(<?php echo esc_url($form_image['url']); ?>); background-size: cover;  background-position: bottom right;" <?php } ?>>
						
							<?php if(!empty($contact_form_2_element_form_text)){ ?>
							<div class="section-head style-1 m-b30">
								<h2 class="title text-white"><?php echo wp_kses($contact_form_2_element_form_text,clinicmaster_allowed_html_tag()); ?></h2>
							</div>
							<?php } ?>
							<?php if(!empty($contact_form_2_element_contact_form)){ ?>
								
									<?php 
										$post = get_page_by_path($contact_form_2_element_contact_form,OBJECT,'wpcf7_contact_form');
										if(!empty($post->ID)){
											echo do_shortcode('[contact-form-7 id="'.$post->ID.'"]');
										}
									?>
								
							<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php } ?>