<?php
$clinicmaster_option = getDZThemeReduxOption();
$general_phone_icon 	= !empty($clinicmaster_option['general_phone_icon']) ? $clinicmaster_option['general_phone_icon']: '';
$general_phone_text     = !empty($clinicmaster_option['general_phone_text']) ? $clinicmaster_option['general_phone_text']: '';
$general_phone_number   = !empty($clinicmaster_option['general_phone_number']) ? $clinicmaster_option['general_phone_number']:''; 
$items = $contact_box_3_element_item;
$video_img = $contact_box_3_element_video_img;
$img = $contact_box_3_element_img;
$icon = $contact_box_3_element_video_icon;
$element_content = !empty($contact_box_3_element_content) ? $contact_box_3_element_content : 'content-inner';
?>
<section class="<?php echo esc_html($element_content); ?>">
	<div class="container">
		<div class="row content-wrapper style-14 align-items-center">
			<div class="col-xl-6 col-lg-5 m-b30">
				<div class="content-info">
				<?php if(!empty($contact_box_3_element_title) || !empty($contact_box_3_element_description)){ ?>
					<div class="section-head style-1 m-b30">
					<?php if(!empty($contact_box_3_element_title)){ ?>
						<h2 class="title"><?php echo esc_html($contact_box_3_element_title); ?></h2>
					<?php } ?>
					<?php if(!empty($contact_box_3_element_description)){ ?>
						<p><?php echo wp_kses($contact_box_3_element_description,'string'); ?></p>
					</div>
					<?php }
					}
					if(!empty($items)){	?>
					<ul class="list-check-circle-small text-secondary grid-2 m-b35">
					<?php foreach($items as $val){ ?>
						<li><?php echo esc_html($val['contact_box_3_element_item_title']); ?></li>
					<?php } ?>
					</ul>
					<?php } ?>
					<div class="d-flex flex-wrap align-items-center">
						<?php if(!empty($contact_box_3_element_button_text) && !empty($contact_box_3_element_button_link)){ ?>
							<a href="<?php echo esc_url($contact_box_3_element_button_link); ?>" class="btn btn-lg btn-icon btn-secondary btn-shadow m-r40 mb-3 mb-xl-0">
								<?php echo esc_html($contact_box_3_element_button_text); ?>
								<span class="right-icon"><i class="feather icon-arrow-right"></i></span>
							</a>
						<?php } 
						if(!empty($contact_box_3_element_contact_us) && ($contact_box_3_element_contact_us == 'yes') ){ ?>
						<div class="info-widget style-5">
						<?php if(!empty($general_phone_icon)){ ?>
							<div class="widget-media text-primary">
								<i class="<?php echo esc_attr($general_phone_icon); ?> dz-ring-effect"></i>
							</div>
						<?php } ?>
							<div class="widget-content">
								<?php if(!empty($general_phone_text)){ ?>
								<h6 class="title"><?php echo esc_html($general_phone_text); ?></h6>
								<?php }
								if(!empty($general_phone_number)){ ?>
									<a href="tel:<?php echo esc_url($general_phone_number); ?>" class="text-secondary"><?php echo esc_html($general_phone_number); ?></a>
								<?php } ?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<div class="col-xl-6 col-lg-7 m-b30">
				<div class="content-media">
					<div class="row justify-content-center">
						<div class="col-sm-6">
							<div class="img1">
								<?php if(!empty($video_img['id'])){ ?>
									<img src="<?php echo esc_url($video_img['url']); ?>" alt="<?php echo esc_attr__('Image', 'clinicmaster'); ?>">
								<?php } ?>
								<?php if(!empty($contact_box_3_element_video_title)){ ?>
									<div class="video-bx1">
										<?php 
										if(!empty($icon['value']['id']) && ($icon['library'] == 'svg') ){ 
											echo wp_get_attachment_image( $icon['value']['id'], 'thumbnail' ); 
										}elseif(!empty($icon['value'])){ ?>
											<i class="<?php echo esc_attr($icon['value']); ?> "></i>
										<?php } ?>
										<span><?php echo wp_kses($contact_box_3_element_video_title,clinicmaster_allowed_html_tag()); ?></span>
									</div>
								<?php } ?>
								
							</div>	
						</div>
						<div class="col-sm-6">
							<div class="widget-rating2">
								<?php if(!empty($contact_box_3_element_google_img['id'])){
										echo wp_get_attachment_image( $contact_box_3_element_google_img['id'], 'thumbnail' ); 
									} ?>
								<div class="clearfix">
									<div class="d-flex">
										<?php if(!empty($contact_box_3_element_rating_number)){ ?>
										<ul class="star-list">
											<?php 
											$star_count = $contact_box_3_element_rating_number;
											for($star=1;$star<=5;$star++){ 
													if($star<=$star_count){
												echo "<li><i class='fa fa-star'></i></li>";
												}
												else{
													echo "<li><i class='fa fa-star-o'></i></li>";
												}
											}		
											?>
											
										</ul>
										<?php }
										if(!empty($contact_box_3_element_rating)){	?>
										<span class="rating ms-1">(<?php echo esc_html($contact_box_3_element_rating); ?>)</span>
										<?php } ?>
									</div>					
									<?php if(!empty($contact_box_3_element_rating_text)){ ?>
										<span class="text"><?php echo esc_html($contact_box_3_element_rating_text); ?></span>
									<?php } ?>
								</div>
							</div>
							<?php if(!empty($img['id'])){ ?>
							<div class="img2">
								<img src="<?php echo esc_url($img['url']); ?>" alt="<?php echo esc_attr__('Image','clinicmaster'); ?>">
							</div>	
							<?php } ?>
						</div>
					</div>	
				</div>
			</div> 
		</div>
	</div>
</section>