<?php 
$element_content = !empty($contact_box_2_element_content) ? $contact_box_2_element_content : 'content-inner';

$zoom = 15;
$api_key = esc_html( get_option( 'elementor_google_maps_api_key' ) );

$items = $contact_box_2_element_item;


?>
	<section class="<?php echo esc_attr($element_content); ?> bg-light bg-opacity-50">
			<div class="container">
				<?php if(!empty($contact_box_2_element_title) || !empty($contact_box_2_element_subtitle)){ ?>
				<div class="section-head style-1">
					<?php if(!empty($contact_box_2_element_subtitle)){ ?>
						<span class="sub-title text-primary sub-title-icon">
							<?php if(!empty($contact_box_2_element_icon_img['id'])){ ?>
								<img src="<?php echo esc_url($contact_box_2_element_icon_img['url']); ?>" alt="<?php echo esc_attr__('Icom Image', 'clinicmaster'); ?>"/>
							<?php } ?>
							<?php echo esc_html($contact_box_2_element_subtitle); ?>
						</span>
					<?php } ?>
					<?php if(!empty($contact_box_2_element_title)){ ?>
						<h2 class="title m-b0"><?php echo esc_html($contact_box_2_element_title); ?></h2>
					<?php } ?>
				</div>
				<?php } ?>
				<div class="row content-wrapper">
					<?php if(!empty($items)){ 
					foreach($items as $val){
						$title = $val['contact_box_2_element_item_title'];
						$text = $val['contact_box_2_element_item_text'];
						$value = $val['contact_box_2_element_item_value'];
						$text2 = $val['contact_box_2_element_item_text2'];
						$value2 = $val['contact_box_2_element_item_value2'];
						$link_text = $val['contact_box_2_element_item_link_text'];
						$link = $val['contact_box_2_element_item_link'];

						?>
					<div class="col-xl-6 m-b30">
						<div class="content-bx style-6 shadow-sm">
						<?php if(!empty($val['address'])){
								$params = [
									rawurlencode( $val['address'] ),
									absint( $zoom ),
								];
								if ( $api_key ) {
									$params[] = $api_key;

									$url = 'https://www.google.com/maps/embed/v1/place?key=%3$s&q=%1$s&amp;zoom=%2$d';
								} else {
									$url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
								}
									?>
							<div class="dz-media">
								<iframe loading="lazy"
									src="<?php echo esc_url( vsprintf( $url, $params ) ); ?>"
									title="<?php echo esc_attr( $val['address'] ); ?>"
									aria-label="<?php echo esc_attr( $val['address'] ); ?>"
							></iframe>	
							</div> 
							<?php } ?>
							<div class="dz-info">
								<div class="clearfix">
								<?php if(!empty($title)){ ?>
									<h3 class="title m-b20"><?php echo esc_html($title); ?></h3>
								<?php } 
									if(!empty($text) || !empty($value)){ ?>
									<div class="m-b15">
										<?php if(!empty($text)){ ?>
										<h4 class="m-b5 font-16"><?php echo esc_html($text); ?></h4>
										<?php }
										if($value){ ?>
										<p><?php echo esc_html($value); ?></p>
										<?php } ?>
									</div>
									<?php } 
									if(!empty($text2) || !empty($value2)){ ?>
									<div class="m-b15">
										<?php if(!empty($text2)){ ?>
										<h4 class="m-b5 font-16"><?php echo esc_html($text2); ?></h4>
										<?php }
										if($value2){ ?>
										<p><?php echo esc_html($value2); ?></p>
										<?php } ?>
									</div>
									<?php } ?>
								</div>
								<?php if(!empty($link_text) && !empty($link)){ ?>
								<div class="dz-footer">
									<a href="<?php echo esc_url($link); ?>" target="_blank" class="icon-link-hover-end"><?php echo esc_html($link_text); ?> <i class="feather icon-arrow-up-right"></i></a>
								</div>
								<?php } ?>
							</div>
						</div>
					</div>
					<?php }
					} ?>
				</div>
			</div>
		</section>
					