<?php
/**
 ReduxFramework Theme Option File
 For full documentation, please visit: https://github.com/ReduxFramework/ReduxFramework/wiki
 *
 */

if (!class_exists('ReduxFramework'))
{
    return;
}

if (!class_exists('ClinicMaster_Redux_Framework_config'))
{
    class ClinicMaster_Redux_Framework_config
    {

        public $args = array();
        public $sections = array();
        public $theme;
        public $ReduxFramework;
        public $page_template_options;
        public $coming_template_options;
        public $maintenance_template_options;
        public $error_template_options;
        public $header_style_options;
        public $footer_style_options;
        public $post_layouts_options;
        public $sidebar_layout_options;
        public $page_banner_options;
        public $page_banner_layout_options;
        public $post_banner_options;
        public $theme_layout_options;
        public $theme_color_background_options;
        public $theme_image_background_options;
        public $theme_pattern_background_options;
        public $theme_color_options;
        public $page_loader_options;
        public $sort_by_options;
        public $link_target_options;
        public $social_link_options;
        public $post_related_layout_options;
        public $social_share_options;
        public $banner_type;
		public $clinicmaster_fontawesome_icon;
		public $page_list;
		public $banner_style;
		public $shop_template_layouts;
		

        function __construct() 
        {
            /** Option Variable assigning values **/
            $this->page_template_options = clinicmaster_get_page_template_options();
            $this->coming_template_options = clinicmaster_get_coming_template_options();
            $this->maintenance_template_options = clinicmaster_get_maintenance_template_options();
            $this->error_template_options = clinicmaster_get_error_template_options();
            $this->header_style_options = clinicmaster_get_header_style_options();
            $this->footer_style_options = clinicmaster_get_footer_style_options();
            $this->post_layouts_options = clinicmaster_get_post_layouts_options();
            $this->sidebar_layout_options = clinicmaster_get_sidebar_layout_options();
            $this->page_banner_options = clinicmaster_get_page_banner_options();
            $this->page_banner_layout_options = clinicmaster_get_page_banner_layout_options();
            $this->post_banner_options = clinicmaster_get_post_banner_options();
            $this->theme_layout_options = clinicmaster_get_theme_layout_options();
            $this->theme_color_background_options = clinicmaster_get_theme_color_background_options();
            $this->theme_image_background_options = clinicmaster_get_theme_image_background_options();
            $this->theme_pattern_background_options = clinicmaster_get_theme_pattern_background_options();
            $this->theme_color_options = clinicmaster_get_theme_color_options();
            $this->page_loader_options = clinicmaster_get_page_loader_options();
            $this->sort_by_options = clinicmaster_get_sort_by_options();
            $this->link_target_options = clinicmaster_get_link_target_options();
            $this->social_link_options = clinicmaster_get_social_link_options();
            $this->post_related_layout_options = clinicmaster_get_post_related_layout_options();
            $this->social_share_options = clinicmaster_get_social_share_options();
            $this->banner_type = clinicmaster_banner_type();
            $this->clinicmaster_fontawesome_icon = clinicmaster_get_fontawesome_icon();
            $this->page_list = clinicmaster_get_pages_list();
			$this->banner_style = clinicmaster_get_page_banner_style_options();
			$this->shop_template_layouts = clinicmaster_get_shop_template_layouts_options();
			
            /** End Option Variable assigning values **/

            /* Just for demo purposes. Not needed per say. */
            $this->theme = wp_get_theme();

            /* Set the default arguments */
            $this->setArguments();

            /*  array of widgets */
            $this->clinicmaster_get_wp_widgets();

            /* Create the sections and fields */
            $this->setSections();

            /* default theme options */
            if (!isset($this->args['opt_name']))
            { /* No errors please */
                return;
            }
            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
			//require_once Redux_Core::$dir . 'inc/extensions/icon_select/font-awesome-5-free.php';
        }

        /**
			* All the possible arguments for Redux.
         * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
         *
         */

        function setArguments()
        {
		

            $theme = wp_get_theme(); /* For use with some settings. Not necessary. */
            $opt_name = clinicmaster_get_opt_name();
			

            $this->args = array(

                /* TYPICAL -> Change these values as you need/desire */
                'opt_name' => $opt_name,
                /* This is where your data is stored in the database and also becomes your global variable name. */
                'display_name' => $theme->get('Name') ,
                /* Name that appears at the top of your panel */
                'display_version' => $theme->get('Version') ,
                /* Version that appears at the top of your panel */
                'menu_type' => class_exists('ClinicMaster_Menu_Handle') ? 'submenu' : 'menu',
                /* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only) */
                'allow_sub_menu' => false,
                /* Show the sections below the admin menu item or not */
                'menu_title' => esc_html__('Theme Options', 'clinicmaster') ,
                'page_title' => esc_html__('Theme Options', 'clinicmaster') ,
                /* You will need to generate a Google API key to use this feature. */
                /* Please visit: https://developers.google.com/fonts/docs/developer_api#Auth */
                'google_api_key' => '',
                /* Set it you want google fonts to update weekly. A google_api_key value is required. */
                'google_update_weekly' => false,
                /* Must be defined to add google fonts to the typography module */
                'async_typography' => false,
                /* Use a asynchronous font on the front end or font string */
                /* 'disable_google_fonts_link' => true,  */                   /* Disable this in case you want to create your own google fonts loader */
                'admin_bar' => false,
                /* Show the panel pages on the admin bar */
                'admin_bar_icon' => 'dashicons-admin-generic',
                /*  Choose an icon for the admin bar menu */
                'admin_bar_priority' => 50,
                /* Choose an priority for the admin bar menu */
                'global_variable' => '',
                /* Set a different name for your global variable other than the opt_name */
                'dev_mode' => true,
                /* Show the time the page took to load, etc */
                'update_notice' => true,
                /* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo */
                'customizer' => false,
                /* Enable basic customizer support */
                /* 'open_expanded'     => true,  */                   /* Allow you to start the panel in an expanded way initially. */
                /* 'disable_save_warn' => true,  */                   /* Disable the save warning when a user changes a field */
                'show_options_object' => false,
                /*  OPTIONAL -> Give you extra features */
                'page_priority' => null,
                /*  Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning. */
                'page_parent' => class_exists('ClinicMaster_Menu_Handle') ? $theme->get('TextDomain') : '',
                /*  For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters */
                'page_permissions' => 'manage_options',
                /*  Permissions needed to access the options panel. */
                'menu_icon' => '',
                /*  Specify a custom URL to an icon */
                'last_tab' => '',
                /*  Force your panel to always open to a specific tab (by id) */
                'page_icon' => 'icon-themes',
                /*  Icon displayed in the admin panel next to your menu_title */
                'page_slug' => 'theme-options',
                /*  Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided */
                'save_defaults' => true,
                /*  On load save the defaults to DB before user clicks save or not */
                'default_show' => false,
                /*  If true, shows the default value next to each field that is not the default value. */
                'default_mark' => '',
                /*  What to print by the field's title if the value shown is default. Suggested: * */
                'show_import_export' => true,
                /*  Shows the Import/Export panel when not used as a field. */
                /*  CAREFUL -> These options are for advanced use only */
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => false,
                /*  Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output */
                'output_tag' => true,
                /*  Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head */
                /* 'footer_credit'     => '', */                   /* Disable the footer credit of Redux. Please leave if you can help it. */
                /* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk. */
                'database' => '',
                /* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning! */
                'use_cdn' => true,
				
                /* If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code. */
                /*  HINTS */
                'hints' => array(
                    'icon' 			=> 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' 	=> '#1085e4',
                    'icon_size' 	=> '10',
                    'tip_style' 	=> array(
                        'color' 	=> '#1085e4',
                        'shadow' 	=> true,
                        'rounded' 	=> false,
                        'style' 	=> '',
                    ) ,
                    'tip_position' => array(
                        'my' 	=> 'top left',
                        'at' 	=> 'bottom right',
                    ) ,
                    'tip_effect' => array(
                        'show' 	 => array(
                            'effect' 	=> 'slide',
                            'duration' 	=> '500',
                            'event' 	=> 'mouseover',
                        ) ,
                        'hide' 	=> array(
                            'effect' 	=> 'slide',
                            'duration' 	=> '500',
                            'event' 	=> 'click mouseleave',
                        ) ,
                    ) ,
                ) ,
                'templates_path' => class_exists('DzThemeSupport') ? DZ_TH_ROOT . '/templates/redux/' : '',
            );
        }

        /**
         * Custom query for widget list array
         *
         * @param  array $all_widgets
         */
        function clinicmaster_get_wp_widgets_in_progress()
        {

            global $wpdb;
            $table = $wpdb->prefix . 'options';
            $attrPrefix = 'widget_';

			$query = "SELECT `option_id`, `option_name` FROM $table WHERE `option_name` LIKE '%$attrPrefix%' AND `option_name` != 'sidebars_widgets' ORDER BY `option_id` ASC";
			$prepare = $wpdb->prepare($query);
            $result = $wpdb->get_row($prepare);
			
			$all_widgets = array();

            foreach ($result as $widget)
            {
                $all_widgets[$widget->option_name] = ucwords(str_replace("_", " ", $widget->option_name));
            }

            return $all_widgets;
        }
		
		
		function clinicmaster_get_wp_widgets()
        {

            global $wpdb;
            $table = $wpdb->prefix . 'options';
            $attrPrefix = 'widget_';

            $result = $wpdb->get_results("SELECT `option_id`, `option_name` FROM $table WHERE `option_name` LIKE '%$attrPrefix%' AND `option_name` != 'sidebars_widgets' ORDER BY `option_id` ASC");

			

            $all_widgets = array();

            foreach ($result as $widget)
            {
                $all_widgets[$widget->option_name] = ucwords(str_replace("_", " ", $widget->option_name));
            }

            return $all_widgets;
        }

        /**
         * All the possible sections for Redux.
         *
         */
        function setSections()
        {
			$maintenance_social_defaults_1 = array();	
			$maintenance_social_links = $maintenance_social_defaults = array();
		
            foreach ($this->social_link_options as $social_link)
            {

                $link_value = clinicmaster_get_opt('social_' . $social_link['id'] . '_url');
				
                if (!empty($link_value))
                {
                    $maintenance_social_links[$social_link['id']] = $social_link['title'];
                    $maintenance_social_defaults[$social_link['id']] = false;
                }
            }	
			
			
			
				foreach ($maintenance_social_links as $key => $value)
				{
					
					if (!empty($value))
					{
						$maintenance_social_defaults_1[$key] = 1;
					}
					else
					{
						$maintenance_social_defaults_1[$key] = 0;
					}
					
				}
			
            /*--------------------------------------------------------------
            # 1. General Settings
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' 	=> esc_html__('General Settings', 'clinicmaster') ,
                'desc' 		=> esc_html__('General Settings is a global setting that will affects all the pages of you website. From here you can make changes globaly. The setting will apply if there is no individual settings.', 'clinicmaster') ,
                'icon' 		=> 'el-icon-home',
                'fields' 	=> array(
                    array(
                        'id' 		=> 'website_status',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Website Status', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the option tabs to change the status of your website.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Select option tabs to change the status.', 'clinicmaster') ,
                        'options' 	=> array(
                            'live_mode' 		=> esc_html__('Live', 'clinicmaster') ,
                            'comingsoon_mode' 	=> esc_html__('Coming Soon', 'clinicmaster') ,
                            'maintenance_mode' 	=> esc_html__('Site Down For Maintenance', 'clinicmaster')
                        ) ,
                        'default' 		=> 'live_mode',
                        'hint' 			=> array(
                            'title' 	=> esc_html__('Status', 'clinicmaster'),
                            'content' 	=> esc_html__('1. Live status indicate that your website is available and operational.', 'clinicmaster') . '<br><br>' . esc_html__('2. Coming Soon status show your website visitors that you are working on your website for making it better.', 'clinicmaster') . '<br><br>' . esc_html__('3. Maintenance mode show your website visitors that you are working on your website for making it better.', 'clinicmaster') . '<br><br> <strong>Note : </strong> ' . esc_html__(' Coming soon template and maintenance template will not show when user login.', 'clinicmaster')
                        )
                    ),
                    array(
                        'id' 		=> 'coming_soon_template',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Coming Soon Template', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the template for Coming Soon page. (Default : 1).', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Click on the icon to change the template.', 'clinicmaster') ,
                        'options' 	=> $this->coming_template_options,
						'height'    => '100',
                        'default' 	=> 'coming_style_1',
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
                        'hint' 		=> array(
                            'title'	  => esc_html__('Hint Title', 'clinicmaster') ,
                            'content' => esc_html__('Choose the coming soon template design as you want to show.', 'clinicmaster')
                        )
                    ) ,
					array(
                        'id'		=> 'comingsoon_launch_date',
                        'type' 		=> 'date',
                        'title' 	=> esc_html__('Coming soon Date', 'clinicmaster') ,
                        'required'	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
						'hint'     => array('content' => esc_html__('Coming Soon Status Will change to live after time using ajax','clinicmaster')),
                    ) ,
                    array(
                        'id' 		=> 'comingsoon_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Coming Soon Page Kenbern Images', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
                        'default' 	=> array(
                            'url' 	=> get_template_directory_uri() . '/assets/images/coming-soon.jpg'
                        ),
                    ) ,
					array(
                        'id' 		=> 'comingsoon_page_title',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Comingsoon Soon Page Title', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Default Comingsoon Soon page title.', 'clinicmaster') ,
                        'default' 	=> esc_html__('We Are ', 'clinicmaster') .  '<br>' . esc_html__('Coming Soon', 'clinicmaster'),
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
                    ) ,
					array(
                        'id' 		=> 'comingsoon_page_description',
                        'type' 		=> 'textarea',
                        'title' 	=> esc_html__('Comingsoon Soon Page Descriotion', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Default Comingsoon Soon page description.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Big things are coming! ClinicMaster will be opening its doors soon. Be the first to experience something special!', 'clinicmaster'),
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
                    ) ,
					array(
						'id' 		=> 'comingsoon_page_subscribe',
						'type' 		=> 'switch',
						'title' 	=> esc_html__('Subscribe', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Show or hide the website subscribe option.', 'clinicmaster') ,
						'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
						'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
					),
					array(
						'id' 		=> 'comingsoon_social_links_on',
						'type' 		=> 'switch',
						'title' 	=> esc_html__('Social Icon', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Show or hide the website social icon option.', 'clinicmaster') ,
						'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
						'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'comingsoon_mode' ) ,
					),
					array(
						'id' => 'comingsoon_social_links',
						'type' => 'checkbox',
						'title' => esc_html__('Choose for this social', 'clinicmaster') ,
						'subtitle' => esc_html__('No validation can be done on this field type', 'clinicmaster') ,
						'desc' => esc_html__('This is the description field, again good for additional info.', 'clinicmaster') ,
						//Must provide key => value pairs for multi checkbox options
						'options' => $maintenance_social_links,
						//See how std has changed? you also don't need to specify opts that are 0.
						'default' => $maintenance_social_defaults_1,
						'required' => array(
								0 => 'comingsoon_social_links_on',
								1 => 'equals',
								2 => 1
						)
					),
                    array(
                        'id' 		=> 'maintenance_template',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Maintenance Template', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the template for Maintenance page.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Click on the icon to change the template.', 'clinicmaster') ,
                        'options' 	=> $this->maintenance_template_options,
						'height'    => '100',
                        'default' 	=> 'maintenance_style_1',
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
                        'hint' 		=> array(
                            'title' => esc_html__('Hint Title', 'clinicmaster') ,
                            'content'=> esc_html__('Choose the maintenance template design as you want to show.', 'clinicmaster')
                        )
                    ),		 
					array(
                        'id' 		=> 'maintenance_title',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Maintenance Page Title', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
                        'default' 	=> esc_html__('Our website is ', 'clinicmaster') .'<span class="text-primary">'.esc_html__('under construction', 'clinicmaster'). '</span>',
                    ),  
                    array(
                        'id'        => 'maintenance_desc',
                        'type'      => 'textarea',
                        'title'     => esc_html__('Maintenance Page Description', 'clinicmaster') ,
                        'desc'      => esc_html__('Default Maintenance page description.', 'clinicmaster') ,
                        'default'   => esc_html__("We’re working hard to bring you a better experience! Our website is under construction, but we’ll be back soon. Stay tuned!", 'clinicmaster'),
                        'required'  => array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
                    ) ,  
                    array(
                        'id'        => 'maintenance_background_image',
                        'type'      => 'media',
                        'url'       => true,
                        'title'     => esc_html__('Maintenance Page Image', 'clinicmaster') ,
                        'required'  => array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
                        'default'   => array(
                            'url'   => get_template_directory_uri() . '/assets/images/under-construction.svg',
                        ) ,
                    ) ,     
					array(
						'id' 		=> 'maintenance_page_subscribe',
						'type' 		=> 'switch',
						'title' 	=> esc_html__('Subscribe', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Show or hide the website subscribe option.', 'clinicmaster') ,
						'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
						'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
					),
					array(
						'id' 		=> 'maintenance_social_links_on',
						'type' 		=> 'switch',
						'title' 	=> esc_html__('Social Icon', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Show or hide the website social icon option.', 'clinicmaster') ,
						'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
						'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'maintenance_mode' ) ,
					),
					array(
						'id' => 'maintenance_social_links',
						'type' => 'checkbox',
						'title' => esc_html__('Choose for this social', 'clinicmaster') ,
						'subtitle' => esc_html__('No validation can be done on this field type', 'clinicmaster') ,
						'desc' => esc_html__('This is the description field, again good for additional info.', 'clinicmaster') ,
						//Must provide key => value pairs for multi checkbox options
						'options' => $maintenance_social_links,
						//See how std has changed? you also don't need to specify opts that are 0.
						'default' => $maintenance_social_defaults_1,
						'required' => array(
								0 => 'maintenance_social_links_on',
								1 => 'equals',
								2 => 1
						)
					),
                    array(
                        'id' 		=> 'logo_type',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Logo Type', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the logo type', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Click o the tab to change the logo type.', 'clinicmaster') ,
                        'options' 	=> array(
                            'image_logo'=> esc_html__('Image Logo', 'clinicmaster') ,
                            'text_logo' => esc_html__('Text Logo', 'clinicmaster')
                        ) ,
                        'default' 	=> 'image_logo',
                        'hint' => array(
                            'title' 	=> esc_html__('Choose Logo Type:', 'clinicmaster') ,
                            'content' 	=> esc_html__('1. Image Logo will be the .pmg / .jpg type. This setting affects all the site pages.', 'clinicmaster') . '<br><br>' . esc_html__('2. Text Logo will the text type. This setting affects all the site pages.', 'clinicmaster')
                        ),
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
                    array(
                        'id' 		=> 'blog_page_title',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Blog Page Title', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Default blog page title.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Blog', 'clinicmaster'),
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
                    array(
                        'id' 		=> 'page_loading_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Page Loading', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the tab to Enable / Disable the page loading setting.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Once you click on disable, This setting affects all the site pages.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,

                    array(
                        'id' 		=> 'show_social_icon',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Social Icon', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the tab to Enable / Disable the social icon setting.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Once you click on disable, This setting affects all the site pages.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
                    array(
                        'id' 		=> 'show_breadcrumb',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Breadcrumb Area', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the tab to Enable / Disable the website breadcrumb.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Once you click on disable, This setting affects all the site pages.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'hint' 		=> array(
                            'title' 	=> esc_html__('Select Breadcrumb Area:', 'clinicmaster') ,
                            'content' 	=> esc_html__('This breadcrumb option only works when page level banner Theme Settings option selected. This option will not work when custom settings selected.', 'clinicmaster'),
                        )
                    ) ,
                   
                    array(
                        'id' 		=> 'show_sidebar',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Sidebar', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the tab to Enable / Disable the sidebar.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Once you click on disable, This setting affects all the site pages.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
						'id' 		=> 'sidebar_bg_color',
						'type' 		=> 'button_set',
						'title'     => esc_html__('Sidebar Background Color', 'clinicmaster') ,
						'options' 	=> array(
							'dz-medical' 		=> esc_html__('Normal', 'clinicmaster') ,
							'dz-dentist' 		=> esc_html__('Bg Light', 'clinicmaster') ,
							'dz-skincare' 		=> esc_html__('Bg White', 'clinicmaster') ,
						   
						) ,
						'default'   => 'dz-medical',
						'required' => array(
							
								0 => 'website_status',
								1 => 'equals',
								2 => 'live_mode',
						),
					),
					array(
                        'id' 		=> 'preload_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Preload Image', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                        
                    ),
					array(
                        'id' 		=> 'mailchimp-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('MailChimp Section', 'clinicmaster') ,
                        'indent' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
                  
                    array(
                        'id' 		=> 'mailchimp',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Mailchimp', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Click on the tab to Enable / Disable mailchimp subscription.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
                        'id' 		=> 'mailchimp_title',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Mailchimp Title', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your title.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Important Updates Waiting for you', 'clinicmaster'),
                        'required' 	=> array( 0 => 'mailchimp', 1 => 'equals', 2 => 1 ) ,
                    ) ,
					array(
                        'id' 		=> 'mailchimp_description',
                        'type' 		=> 'textarea',
                        'title' 	=> esc_html__('Mailchimp Description', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your description.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Get our latest and best contents right into your inbox', 'clinicmaster'),
                        'required' 	=> array( 0 => 'mailchimp', 1 => 'equals', 2 => 1 ) ,
                    ) ,
					array(
                        'id' 		=> 'mailchimp_button_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Button Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your button text.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Subscribe Now', 'clinicmaster'),
                        'required' 	=> array( 0 => 'mailchimp', 1 => 'equals', 2 => 1 ) ,
                    ) ,
                    array(
                        'id' 		=> 'mailchimp_api_key',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('MailChimp Api Key', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Input an API key to enable MailChimp.', 'clinicmaster') ,
                        'default' 	=> '',
                        'required' 	=> array( 0 => 'mailchimp', 1 => 'equals', 2 => 1) ,
                    ) ,
                    array(
                        'id' 		=> 'mailchimp_list_id',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('MailChimp List ID', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Input an List ID to enable MailChimp.', 'clinicmaster') ,
                        'default' 	=> '',
                        'required' 	=> array( 0 => 'mailchimp', 1 => 'equals', 2 => 1) ,
                    ) ,	    
					 array(
                        'id' 		=> 'contact-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Contact Details Section', 'clinicmaster') ,
                        'indent' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
						'id' 		=> 'general_email_icon',
						'type' 		=> 'icon_select',
						'title'     => esc_html__('Email Icon', 'clinicmaster') ,
						'required' => array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'options' => clinicmaster_get_feather_icons(),
						'stylesheet' =>  get_template_directory_uri() . '/assets/css/dz-icon.css',  
					
					),
					array(
                        'id' 		=> 'general_email_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Email Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your email text.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Send us a Mail','clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ),	   
					array(
                        'id' 		=> 'general_email_address',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Email Address', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your email address.', 'clinicmaster') ,
                        'default' 	=> esc_html__('email@domain.com','clinicmaster') ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
						'id' 		=> 'general_phone_icon',
						'type' 		=> 'icon_select',
						'title'     => esc_html__('Phone Icon', 'clinicmaster') ,
						'required' => array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'options' => clinicmaster_get_feather_icons(),
						'stylesheet' =>  get_template_directory_uri() . '/assets/css/dz-icon.css',
						
						
						
					),
					array(
                        'id' 		=> 'general_phone_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Phone Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your phonr text.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Contact Us','clinicmaster') ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,	   
                    array(
                        'id' 		=> 'general_phone_number',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Phone Number', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your phonr number.', 'clinicmaster') ,
                        'default' 	=> '+1 123 456 7890' ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,	      
					array(
						'id' 		=> 'general_time_icon',
						'type' 		=> 'icon_select',
						'title'     => esc_html__('Time Icon', 'clinicmaster') ,
						'required' => array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'options' => clinicmaster_get_feather_icons(),
						'stylesheet' =>  get_template_directory_uri() . '/assets/css/dz-icon.css',
					),
					array(
                        'id' 		=> 'general_time_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Time Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your timing text.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Opening Time','clinicmaster') ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,	   
                    array(
                        'id' 		=> 'general_time_value',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Time', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your timing.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Mon -Sat: 7:00 - 17:00','clinicmaster') ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,	      
					array(
						'id' 		=> 'general_address_icon',
						'type' 		=> 'icon_select',
						'title'     => esc_html__('Address Icon', 'clinicmaster') ,
						'required' => array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'options' => clinicmaster_get_feather_icons(),
						'stylesheet' =>  get_template_directory_uri() . '/assets/css/dz-icon.css',
					),
					array(
                        'id' 		=> 'general_address_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Address Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your address text.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Address','clinicmaster') ,
                       'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,	   
					array(
                        'id' 		=> 'general_address',
                        'type' 		=> 'textarea',
                        'title' 	=> esc_html__('Address', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your address.', 'clinicmaster') ,
                        'default' 	=> esc_html__('785 15h Street, Office 478 Berlin, De 81566', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
                        'id' 		=> 'general_about_us',
                        'type' 		=> 'textarea',
                        'title' 	=> esc_html__('Apout Us', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your about us.', 'clinicmaster') ,
                        'default' 	=> esc_html__('Medizone is a modern and responsive Bootstrap HTML template designed for health and medical websites. Ideal for clinics, hospitals, and healthcare professionals seeking a professional online presence with an elegant and user-friendly design.', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					
					array(
                        'id' 		=> 'open-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Opening Info Section', 'clinicmaster') ,
                        'indent' 	=> true,
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
                        'id' 		=> 'general_opening_hours_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Opening hours Text', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Enter your text', 'clinicmaster') ,
                        'default' 	=> esc_html__('Open Hours', 'clinicmaster') ,
                        'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
                    ) ,
					array(
						'id'          => 'general_opening_hours',
						'type'        => 'slides',
						'title'       => __('Opening hours', 'clinicmaster'),
						'show'        => array(
							'url'         => false,
							'title'       => true,
							'description' => true,
							'image'       => false,
						),
						'required' 	=> array( 0 => 'website_status', 1 => 'equals', 2 => 'live_mode' ) ,
						'default'     => array(
								array(
									'title'       => esc_html__('Monday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Tuesday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Wednesday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Thursday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Friday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Saturday', 'clinicmaster'),
									'description' => esc_html__('09:30 - 07:30', 'clinicmaster'),
								),
						),
					),
                )
            );

            /*--------------------------------------------------------------
            # 2. Logo Settings
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Logo Settings', 'clinicmaster') ,
                'icon' 	=> 'el el-cog-alt',
                'fields'=> array(
                    array(
                        'id' 		=> 'favicon',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Favicon', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select favicon image.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload favicon image.', 'clinicmaster') ,
                        'default' 	=> array(
                            'url' 	=> get_template_directory_uri() . '/assets/images/favicon.png'
                        ) ,
                        'hint' 		=> array(
                            'title' 	=> esc_html__('Favicon', 'clinicmaster') ,
                            'content' 	=> esc_html__('From here you can upload an image. This setting affects all the site pages.', 'clinicmaster')
                        )
                    ) ,
                    array(
                        'id' 		=> 'logo_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Logo Text', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Name your text logo.', 'clinicmaster') ,
                        'default' 	=> get_bloginfo('name') ,
                    ) ,
                    array(
                        'id' 		=> 'tag_line',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Tag Line', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Name a tagline for the text logo.', 'clinicmaster') ,
                        'default' 	=> get_bloginfo('description') ,
                    ) ,
                    array(
                        'id' 		=> 'logo_title',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Logo Title', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Title attribute for the logo. This attribute specifies extra information about the logo. Most browsers will show a tooltip with this text on logo hover.', 'clinicmaster') ,
                        'default' 	=> get_bloginfo('name') ,

                    ) ,
                    array(
                        'id' 		=> 'logo_alt',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Logo Alt', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Alt attribute for the logo. This is the alternative text if the logo cannot be displayed. It`s useful for SEO and generally is the name of the site.', 'clinicmaster') ,
                        'default' 	=> get_bloginfo('name') ,
                    ) ,
                    array(
                        'id' 		=> 'logo-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Site Logo Setting', 'clinicmaster') ,
                        'indent' 	=> true
                    ) ,
				
                    array(
                        'id' 		=> 'site_logo',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Logo', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Upload your logo (272 x 90px) .png or .jpg', 'clinicmaster') ,
                        'default' 	=> array(
                            'url' 	=> get_template_directory_uri() . '/assets/images/logo-dark.png'
                        )
                    ) ,
                    array(
                        'id' 		=> 'site_other_logo',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Other Logo', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Upload your logo (272 x 90px) .png or .jpg', 'clinicmaster') ,
                        'default' 	=> array(
                            'url' 	=> get_template_directory_uri() . '/assets/images/logo-light.png'
                        )
                    ),
                    array(
                        'id' 		=> 'logo-section-end',
                        'type' 		=> 'section',
                        'indent'	=> false,
                    ) ,
                )
            );

            /*--------------------------------------------------------------
            # 3. Header Settings
            --------------------------------------------------------------*/
            $header_social_links = $header_social_defaults = array();
		
            foreach ($this->social_link_options as $social_link)
            {

                $link_value = clinicmaster_get_opt('social_' . $social_link['id'] . '_url');
				
                if (!empty($link_value))
                {
                    $header_social_links[$social_link['id']] = $social_link['title'];
                    $header_social_defaults[$social_link['id']] = false;
                }
            }
			
			
			

            $header_style_options = clinicmaster_header_style_options();
            $header_aditional_array = array();
            $mobile_header_aditional_array = array();
            foreach ($header_style_options as $header)
            {
                $header_id = $header['id'];

                $header_social_defaults_1 = $header_social_defaults;

                $header_search_on = clinicmaster_set($header['param'], 'search', false);
                $social_link = clinicmaster_set($header['param'], 'social_link', false);
                $header_top_bar = clinicmaster_set($header['param'], 'top_bar', false);
                $header_location_on = clinicmaster_set($header['param'], 'location', false);				
                $call_to_action_button = clinicmaster_set($header['param'], 'call_to_action_button', false);
				$informative_fields = clinicmaster_set($header['param'], 'informative_fields_header', false);
				$extra_fields = clinicmaster_set($header['param'], 'extra_fields', false);
				$extra_social_information = clinicmaster_set($header['param'], 'extra_social_information', false);
                $total_links = clinicmaster_set($header['param'], 'social_links', false); 
              

                if ($total_links > 0)
                {
                    $i = 1;
                    foreach ($header_social_links as $key => $value)
                    {
                        if ($i <= $total_links)
                        {
                            $header_social_defaults_1[$key] = 1;
                        }
                        else
                        {
                            $header_social_defaults_1[$key] = 0;
                        }
                        $i++;
                    }
                }
				
				
				if ($informative_fields > 0)
                {
                    for ($i = 1;$i <= $informative_fields;$i++)
                    {
                        $header_aditional_array[] = array(
                            'id' 		=> $header_id . '_info_field_' . $i . '_icon_class',
                            'type' 		=> 'text',
                            'title' 	=> esc_html__('Icon Class ', 'clinicmaster'),
                            'default' 	=> '',
                            'required' 	=> array(0 => 'header_style', 1 => 'equals', 2 => $header_id),
                        );
                     
                        $header_aditional_array[] = array(
                            'id' 		=> $header_id . '_info_field_' . $i . '_address',
                            'type' 		=> 'text',
                            'title' 	=> esc_html__('Value ', 'clinicmaster'),
                            'default' 	=> '',
                            'required' 	=> array(0 => 'header_style', 1 => 'equals', 2 => $header_id),
                        );
                    }
                }              
				
				$header_aditional_array[] = array(
					'id'    => $header_id . '_information',
					'type'  => 'info',
					'style' => 'success',
					'title' => esc_html__('Header Information!', 'clinicmaster'),
					'icon'  => 'el-icon-info-sign',
					'desc'  => $header_id.' '.esc_html__( 'header settings display here.', 'clinicmaster'),
					'required' => array(
                        0 => 'header_style',
                        1 => 'equals',
                        2 => $header_id
                    )
				);	               
				
				

			
				
				if ($call_to_action_button > 0)
				{
					for ($i = 1;$i <= $call_to_action_button;$i++)
					{
						$header_aditional_array[] = array(
							'id' 		=> $header_id . '_button_' . $i . '_on',
							'type' 		=> 'switch',
							'title' 	=> esc_html__('Button ', 'clinicmaster') . $i . esc_html__(' on', 'clinicmaster') ,
							'on'        => esc_html__('Enabled', 'clinicmaster') ,
							'off'       => esc_html__('Disabled', 'clinicmaster') ,
							'default'   => true,
							'required' 	=> array(0 => 'header_style', 1 => 'equals', 2 => $header_id)
						);
						$header_aditional_array[] = array(
							'id' 		=> $header_id . '_button_' . $i . '_text',
							'type' 		=> 'text',
							'title' 	=> esc_html__('Button ', 'clinicmaster') . $i . esc_html__(' Text', 'clinicmaster') ,
							'default' 	=> esc_html__('Appointment', 'clinicmaster'),
							'required' 	=> array(0 => $header_id . '_button_' . $i . '_on', 1 => 'equals', 2 => true)
						);
						$header_aditional_array[] = array(
							'id' 		=> $header_id . '_button_' . $i . '_url',
							'type' 		=> 'text',
							'title' 	=> esc_html__('Button ', 'clinicmaster') . $i . esc_html__(' URL', 'clinicmaster') ,
							'default' 	=> '',
							'required' 	=> array(0 => $header_id . '_button_' . $i . '_on', 1 => 'equals', 2 => true)

						);
						$header_aditional_array[] = array(
							'id' 		=> $header_id . '_button_' . $i . '_target',
							'type' 		=> 'select',
							'title' 	=> esc_html__('Choose Button ', 'clinicmaster') . $i . esc_html__(' Target', 'clinicmaster') ,
							'options' 	=> $this->link_target_options,
							'default' 	=> '_self',
							'required' 	=> array(0 => $header_id . '_button_' . $i . '_on', 1 => 'equals', 2 => true)
						);
					}
				}
				if($header_id == 'header_2' || $header_id == 'header_4'){
					
					if($header_id == 'header_2'){
						$header_aditional_array[] =  array(
							'id' 		=> $header_id.'_header_menu',
							'type' 		=> 'button_set',
							'title'     => esc_html__('Header Menu Color', 'clinicmaster') ,
							'options' 	=> array(
								'header-light' 		=> esc_html__('Light', 'clinicmaster') ,
								'' 		=> esc_html__('Dark', 'clinicmaster') ,
							   
							) ,
							'default'   => 'header-light',
							'required' => array(
								
									0 => 'header_style',
									1 => 'equals',
									2 => $header_id,
							),
						);
					}
					$header_aditional_array[] =  array(
						'id' 		=> $header_id.'_phone_number_on',
						'type' 		=> 'switch',
						'title'     => esc_html__('Phone Number', 'clinicmaster') ,
						'subtitle'  => esc_html__('Show or hide the header phone number option.', 'clinicmaster') ,
						'on'        => esc_html__('Enabled', 'clinicmaster') ,
						'off'       => esc_html__('Disabled', 'clinicmaster') ,
						'default'   => true,
						'required' => array(
							
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
						),
					);
				}
				
				
				
				$header_aditional_array[] =  array(
					'id' 		=> $header_id.'_sidebar_on',
					'type' 		=> 'switch',
					'title'     => esc_html__('Sidebar', 'clinicmaster') ,
					'subtitle'  => esc_html__('Show or hide the header sidebar option.', 'clinicmaster') ,
					'on'        => esc_html__('Enabled', 'clinicmaster') ,
					'off'       => esc_html__('Disabled', 'clinicmaster') ,
					'default'   => true,
					'required' => array(
						array(
							0 => 'header_style',
							1 => 'equals',
							2 => $header_id,
						),
						array(
							0 => 'header_style',
							1 => '!=',
							2 => 'header_3',
						),
					),
				);
				$header_aditional_array[] = array(
						'id'        => $header_id.'_social_links_on',
						'type'      => 'switch',
						'title'     => esc_html__('Social Links', 'clinicmaster') ,
						'subtitle'  => esc_html__('Show or hide the header social links option.', 'clinicmaster') ,
						'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
						'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'default' 	=> true,
						'required' => array(
							//array(0 => $header_id.'_topbar_info_on', 1 => 'equals', 2 => '1'),
							array(0 => 'header_style', 1 => 'equals', 2 => $header_id)
						),
							
					);
					
					$header_aditional_array[] = array(
						'id' => $header_id.'_social_links',
						'type' => 'checkbox',
						'title' => esc_html__('Choose for this Header', 'clinicmaster') ,
						'subtitle' => esc_html__('No validation can be done on this field type', 'clinicmaster') ,
						'desc' => esc_html__('This is the description field, again good for additional info.', 'clinicmaster') ,
						//Must provide key => value pairs for multi checkbox options
						'options' => $header_social_links,
						//See how std has changed? you also don't need to specify opts that are 0.
						'default' => $header_social_defaults_1,
						'required' => array(0 => 'header_style', 1 => 'equals', 2 => $header_id),
					); 
				
				
				if ($header_top_bar > 0){
					$header_aditional_array[] =  array(
						'id' 		=> $header_id.'_topbar_info_on',
						'type' 		=> 'switch',
						'title'     => esc_html__('Topbar', 'clinicmaster') ,
						'subtitle'  => esc_html__('Show or hide the header topbar option.', 'clinicmaster') ,
						'on'        => esc_html__('Enabled', 'clinicmaster') ,
						'off'       => esc_html__('Disabled', 'clinicmaster') ,
						'default'   => true,
						'required' => array(
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
						),
					);
					if($header_id == 'header_1'){
					$header_aditional_array[] = array(
						'id'          => 'top_bar_info',
						'type'        => 'slides',
						'placeholder' => array(
							'title'       => esc_html__('This is a title', 'clinicmaster'),
							'description' => esc_html__('Description Here', 'clinicmaster'),
						),
						'required' => 	array(
									'header_style', // Second condition
									'equals',
									$header_id
									), 
								
							'show'        => array(
								'url'         => false,
								'title'       => true,
								'description' => true,
								'height'      => 300,
								'width'       => 300,
								'button' => false,
							),
							'default'     => array(
								array(
									'title'       => esc_html__('Contact Us', 'clinicmaster'),
									'description' => esc_html__('+1 123 456 7890', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Email Support', 'clinicmaster'),
									'description' => esc_html__('email@domain.com', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Online Appointment', 'clinicmaster'),
									'description' => esc_html__('Book Now', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Support', 'clinicmaster'),
									'description' => esc_html__('24x7 Support', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('Payment', 'clinicmaster'),
									'description' => esc_html__('Pay Online', 'clinicmaster'),
								),
								array(
									'title'       => esc_html__('My Cart', 'clinicmaster'),
									'description' => esc_html__('2 Items', 'clinicmaster'),
								),
							),
							
						);
					}
					
					
				}		
                /******Header Related Fields *****/
            }

            $headerDefaultOption = array(
                'title' 	=> esc_html__('Header Settings', 'clinicmaster') ,
                'icon' 		=> 'fa fa-header',
                'fields' 	=> array(
                    array(
                        'id' 		=> 'header_style',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Header Style', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose header style. White header is set as default header for all theme.', 'clinicmaster') ,
                        'options' 	=> $this->header_style_options,
                        'default' 	=> 'header_4',
                        'hint' 		=> array(
                            array(
                                'title' 	=> 'Hint Title',
                                'content' 	=> esc_html__('This is the content of the tool-tip', 'clinicmaster')
                            )
                        )
                    ),	
					

                    array(
                        'id' 		=> 'header_sticky_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Sticky Header', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Header will be sticked when applicable.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'mobile_section_start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Mobile Device Options', 'clinicmaster') ,
                        'indent' 	=> false
                    ) ,
                   
					
                    array(
                        'id' 		=> 'mobile_header_social_links',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Social Link', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Show or hide the header social links option.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ),
                )
            );


            array_splice($headerDefaultOption['fields'], 1, 0, $header_aditional_array);
            $mobileFieldPosition = count($headerDefaultOption['fields']);
            array_splice($headerDefaultOption['fields'], $mobileFieldPosition, 0, $mobile_header_aditional_array);

            $this->sections[] = $headerDefaultOption;
			
			
			/*--------------------------------------------------------------
            # 4. Footer
            --------------------------------------------------------------*/
            $all_widgets = $this->clinicmaster_get_wp_widgets();

            $footer_setting_fields[] = array(
                'id' 		=> 'footer_on',
                'type' 		=> 'switch',
                'title' 	=> esc_html__('Footer', 'clinicmaster') ,
                'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                'default' 	=> true
            );
			
            $footer_setting_fields[] = array(
                'id' 		=> 'footer_style',
                'type' 		=> 'image_select',
                'title' 	=> esc_html__('Footer Template', 'clinicmaster') ,
                'subtitle' 	=> esc_html__('Choose a template for footer.', 'clinicmaster') ,
                'options' 	=> $this->footer_style_options,
                'default' 	=> 'footer_template_1',
                'required' 	=> array(0 => 'footer_on', 1 => 'equals', 2 => '1')
            );
			
			
            $footer_style_options 	= clinicmaster_footer_style_options();
            $total_footer 			= count($this->footer_style_options);
            $footer_block = array();
            $footer_block['All Widgets'] = $all_widgets;
			$footer_social_links = $footer_social_defaults = array();
			$footer_social_defaults_1 = array();
            foreach ($this->social_link_options as $social_link)
            {

                $link_value = clinicmaster_get_opt('social_' . $social_link['id'] . '_url');
				
                if (!empty($link_value))
                {
                    $footer_social_links[$social_link['id']] = $social_link['title'];
                    $footer_social_defaults[$social_link['id']] = false;
                }
            }
			
            
            foreach ($footer_style_options as $key => $footer)
            {
                $footer_id 				= $footer['id'];
                $informative_fields 	= clinicmaster_set($footer['param'], 'informative_field', 0);
				$call_to_action_button	= clinicmaster_set($footer['param'], 'call_to_action_button', 0);
				$extra_fields = clinicmaster_set($footer['param'], 'extra_fields', 0);
				$total_links = clinicmaster_set($footer['param'], 'social_link', 0);
				$nav_menu = clinicmaster_set($footer['param'], 'nav_menu', 0);
				$widget_fields  = clinicmaster_set($footer['param'], 'widget_fields', 0);
				$media_gallery  = clinicmaster_set($footer['param'], 'media_gallery', 0);
				$theme_sidebar  = clinicmaster_set($footer['param'], 'theme_sidebar', 0);
				$cart_img  = clinicmaster_set($footer['param'], 'cart_img', 0);
				
				
				$footer_setting_fields[] = array(
					'id' =>  $footer_id.'_footer_bg_image',
					'type' => 'media',
					'url' => true,
					'title' => esc_html__('Footer Image', 'clinicmaster') ,
					'subtitle' => esc_html__('Show or hide the image.', 'clinicmaster') ,
					 'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id)
				);
				
				
			
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_contact_us_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Contact Info', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> true,
					'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					
				);
				$footer_setting_fields[] = array(
					'id' =>  $footer_id.'_contact_us_title',
					'type' => 'text',
					'title' => esc_html__('Title', 'clinicmaster') ,
					'default' 	=> esc_html__('Get in Touch with us', 'clinicmaster') ,
					'required' 	=> array(0 => $footer_id.'_footer_contact_us_on',  1 => 'equals', 2 => 1),
				);
					
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id .'_contact_us_text',
					'type' 		=> 'textarea',
					'title' 	=> esc_html__('Content', 'clinicmaster') ,
					'default' 	=> esc_html__('Lorem Ipsum&nbsp;is simply dummy', 'clinicmaster') ,
					'required' 	=> array(
						array(0 => $footer_id.'_footer_contact_us_on',  1 => 'equals', 2 => 1),
						array(0 => 'footer_style',  1 => '!=', 2 => 'footer_template_1')
						)
					
				);	
				
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_top_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Top On', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> false,
					'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					
				);
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_subscribe_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Subscribe On', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> false,
					'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					
				);
				
				
				if ($total_links > 0)
				{
					$i = 1;
					foreach ($footer_social_links as $key => $value)
					{
						if ($i <= $total_links)
						{
							$footer_social_defaults_1[$key] = 1;
						}
						else
						{
							$footer_social_defaults_1[$key] = 0;
						}
						$i++;
					}
				}
				
				
				$footer_setting_fields[] = array(
					'id' 		=>  $footer_id.'_logo_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Logo On', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> false,
					'required' 	=> array(
						array(0 => $footer_id.'_footer_bottom_on', 1 => 'equals', 2 => '1'),
						array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
						array(0 => 'footer_style', 1 => '!=', 2 => 'footer_template_3'),
					)
				);
				if($extra_fields > 0){
					
					$footer_setting_fields[] = array(
						'id' 		=> $footer_id.'_button_text',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Button Text', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Write footer Button text here.', 'clinicmaster') ,
						'default' 	=> esc_html__('Contact Us', 'clinicmaster'),
						'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					);
					$footer_setting_fields[] = array(
						'id' 		=> $footer_id.'_button_link',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Button Link', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Write footer Button Link here.', 'clinicmaster') ,
						'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					);
					$footer_setting_fields[] = array(
						'id' 		=> $footer_id.'_button_text2',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Button Text 2', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Write footer Button Text 2 here.', 'clinicmaster') ,
						'default' 	=> esc_html__('Appointment', 'clinicmaster'),
						'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					);
					$footer_setting_fields[] = array(
						'id' 		=> $footer_id.'_button_link2',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Button Link 2', 'clinicmaster') ,
						'subtitle' 	=> esc_html__('Write footer Button Link here.', 'clinicmaster') ,
						'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
					);
				}
				
				
				if ($call_to_action_button > 0)
                {
                    for ($i = 1;$i <= $call_to_action_button;$i++)
                    {

                        $footer_setting_fields[] = array(
                            'id' 		=> $footer_id . '_button_' . $i . '_text',
                            'type' 		=> 'text',
                            'title' 	=> esc_html__('Button ', 'clinicmaster') . $i . esc_html__(' Text', 'clinicmaster') ,
                            'default' 	=> '',
                            'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id) ,
                        );
                        $footer_setting_fields[] = array(
                            'id' 		=> $footer_id . '_button_' . $i . '_url',
                            'type' 		=> 'text',
                            'title' 	=> esc_html__('Button ', 'clinicmaster') . $i . esc_html__(' URL', 'clinicmaster') ,
                            'default' 	=> '',
                            'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id) ,

                        );
                        $footer_setting_fields[] = array(
                            'id' 		=> $footer_id . '_button_' . $i . '_target',
                            'type' 		=> 'select',
                            'title' 	=> esc_html__('Choose Button ', 'clinicmaster') . $i . esc_html__(' Target', 'clinicmaster') ,
                            'options' 	=> $this->link_target_options,
                            'default' 	=> '_blank',
                            'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id) ,
                        );
                    }
                }

                if ($informative_fields > 0)
                {
                    for ($i = 1;$i <= $informative_fields;$i++)
                    {						
                       $footer_setting_fields[] = array(
                            'id' 		=> $footer_id . '_info_field_' . $i . '_text',
                            'type' 		=> 'text',
                            'title' 	=> esc_html__('Field ', 'clinicmaster') . $i . esc_html__(' Title', 'clinicmaster') ,
                            'default' 	=> '',
                            'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id) ,
                        );
                        $footer_setting_fields[] = array(
                            'id' 		=> $footer_id . '_info_field_' . $i . '_content',
                            'type' 		=> 'textarea',
                            'title' 	=> esc_html__('Field ', 'clinicmaster') . $i . esc_html__(' Content', 'clinicmaster') ,
                            'default' 	=> '',
                            'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id) ,
                        );
                    }
                }
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_bottom_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Bottom On', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> false,
					 'required' => array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
				);
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_copyright_text',
					'type' 		=> 'textarea',
					'title' 	=> esc_html__('Copyright Text', 'clinicmaster') ,
					'subtitle' 	=> esc_html__('Write footer copyright text here.', 'clinicmaster') ,
					'default' 	=> esc_html__('Copyright © 2023', 'clinicmaster'). ' <a href="https://dexignzone.com/" class="text-primary" target="_blank">'.esc_html__('KinixThemes', 'clinicmaster').'</a> '. esc_html__('All rights reserved.', 'clinicmaster'),
					'required' 	=> array(0 => $footer_id.'_footer_bottom_on', 1 => 'equals', 2 => '1'),
				);
				if($footer_id == 'footer_template_1'){
					$footer_setting_fields[] =  array(
						'id' 		=> $footer_id.'_contact_image',
						'type' 		=> 'media',
						'title'     => esc_html__('Contact Image', 'clinicmaster') ,
						'required' 	=> array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id)
								
					);		
				}
			
					$footer_setting_fields[] =  array(
						'id' 		=> $footer_id.'_card_image',
						'type' 		=> 'media',
						'title'     => esc_html__('Card Image', 'clinicmaster') ,
						'required' 	=> array(0 => $footer_id.'_footer_bottom_on', 1 => 'equals', 2 => '1'),
								
					);		
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_star_rating',
					'type' 		=> 'textarea',
					'title' 	=> esc_html__('Star Rating', 'clinicmaster') ,
					'subtitle' 	=> esc_html__('Write footer copyright text here.', 'clinicmaster') ,
					'default' 	=> '<span class="rating">' . esc_html__('(4.8)', 'clinicmaster').'</span>'. ' <span class="text">'.esc_html__(' 12k+ ratings on google', 'clinicmaster').'</span> ',
					'required' 	=> array(
							array(0 => $footer_id.'_footer_bottom_on', 1 => 'equals', 2 => '1'),
							array(0 => 'footer_style', 1 => 'equals', 2 => array('footer_template_1', 'footer_template_3')),
						),
				);
				
				$footer_setting_fields[] = array(
					'id' 		=> $footer_id.'_footer_social_on',
					'type' 		=> 'switch',
					'title' 	=> esc_html__('Footer Social Link On', 'clinicmaster') ,
					'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
					'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
					'default' 	=> false,
					'required' 	=> array(
						array(0 => $footer_id.'_footer_bottom_on', 1 => 'equals', 2 => '1'),
						array(0 => 'footer_style', 1 => 'equals', 2 => $footer_id),
						array(0 => 'footer_style', 1 => '!=', 2 => 'footer_template_2'),
					)
						
				);	
				
			}
            $this->sections[] = array(
                'title' 	=> esc_html__('Footer Settings', 'clinicmaster') ,
                'desc' 		=> esc_html__('Footer blocks are change according to footer templates.', 'clinicmaster') ,
                'icon' 		=> 'fa fa-home',
                'fields' 	=> $footer_setting_fields
            );
			
            /*--------------------------------------------------------------
            # 5. Post Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Post Settings', 'clinicmaster') ,
                'icon'	=> 'fa fa-newspaper-o'
            );

            $this->sections[] = array(
                'title' 	=> esc_html__('General Settings', 'clinicmaster') ,
                'desc' 		=> esc_html__('This option will work on all new post and edit post sections. On new post page we will display only Post Layout Selection , all other settings will be applicable from here.', 'clinicmaster') ,
                'subsection'=> true,
                'icon' 		=> 'fa fa-gear',
                'fields' 	=> array(
                    array(
                        'id' 		=> 'post_general_layout',
                        'type' 		=> 'image_select',
                        'height' 	=> '100',
                        'title' 	=> esc_html__('Single Post Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select a layout for post page.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Click on the template icon to select.', 'clinicmaster') ,
                        'options' 	=> $this->post_layouts_options,
                        'default' 	=> 'standard',
                        'hint' 		=> array(
                            'title' 	=> esc_html__('How it Works?', 'clinicmaster') ,
                            'content' 	=> esc_html__('Once you select the template from here the template will apply for default post page.', 'clinicmaster')
                        )
						
                    ) ,                    
                    array(
                        'id' 		=> 'date_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Date', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'comment_count_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Comment Count', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'comment_view_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Comment View', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'hint' 		=> array(
                            'content' 	=> esc_html__('We will display view count by adding this number in original post views. It will help to build post reputation on blog.', 'clinicmaster')
                        )
                    ) ,					
					array(
			            'id'       => 'post_view_on',
			            'type'     => 'switch',
			            'title'    => esc_html__('Post View', 'clinicmaster'),
			            'on'       => esc_html__('Enabled', 'clinicmaster'),
			            'off'      => esc_html__('Disabled', 'clinicmaster'),
			            'default'  => true
			        ), 
                    array(
                        'id' 		=> 'post_start_view',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Post Start View', 'clinicmaster') ,
                        'default' 	=> '',
                        'desc' 		=> esc_html__('Enter only number.', 'clinicmaster') ,
                        'hint' 		=> array(
                            'title' 	=> esc_html__('Post Views', 'clinicmaster') ,
                            'content' 	=> esc_html__('We will display view count by adding this number in original post views. It will help to build post reputation on blog.', 'clinicmaster')
                        )
                    ) ,
                    array(
                        'id' 		=> 'author_box_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Author Box', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'category_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Category', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) , 
					array(
                        'id' 		=> 'tags_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Tags', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,

                    array(
                        'id' 		=> 'pre_next_post_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Previous & Next Post', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'featured_img_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Featured Image', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    
                    array(
                        'id' 		=> 'related_post_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Related Post', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
					
                    array(
                        'id' 		=> 'show_image_on_post_list',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Show Image On Post List', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Show feature image on post listing in admin panel.', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false
                    ) ,
                    array(
                        'id' 		=> 'post_general_banner_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Post Banner', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false
                    ) ,					
					
                    array(
                        'id' 		=> 'post-general-img-banner-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Banner Setting', 'clinicmaster') ,
                        'indent' 	=> true,
						'required' 	=> array(0 => 'post_general_banner_on', 1 => 'equals', 2 => 1)

                    ) ,
					array(
                        'id' 		=> 'post_general_banner_layout',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Post Banner Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
                        'height' 	=> '80',
                        'options' 	=> $this->page_banner_layout_options,
                        'default' 	=> 'banner_layout_1',
						'required' 	=> array(0 => 'post_general_banner_on', 1 => 'equals', 2 => '1')
                    ) ,
					
                    array(
                        'id' 		=> 'post_general_banner_height',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Post Banner Height', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the height for all tag page banner. Default : Small Banner', 'clinicmaster') ,
                        'height' 	=> '40',
                        'options' 	=> $this->page_banner_options,
                        'default' 	=> 'page_banner_small',
                    ) ,
					array(
                        'id' 			=>  'post_general_banner_custom_height',
                        'type' 			=> 'slider',
                        'title' 		=> esc_html__('Post Banner Custom Height', 'clinicmaster') ,
                        'desc' 			=> esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                        'default' 		=> '',
                        'min' 			=> 100,
                        'max' 			=> 800,
                        'display_value' => 'text',
                        'required' 		=> array(0 => 'post_general_banner_height', 1 => 'equals', 2 => 'page_banner_custom'
                        )
                    ) ,
                    array(
                        'id' 		=> 'post_general_banner_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Post Banner Image', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Enter post banner image. It will work as default banner image for all pages', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                       	'required' 	=> array(0 => 'post_general_banner_on', 1 => 'equals', 2 => '1')
                    ) , 
					array(
                        'id' 			=> 'post_general_title_position',
                        'type' => 'button_set',
						'options' => array(
							'left' => esc_html__('Left', 'clinicmaster') ,
							'center' => esc_html__('Center', 'clinicmaster')
						),
                        'title' 		=> esc_html__('Title Position', 'clinicmaster') ,
						'default' => 'center',
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),

					),
					array(
                        'id' 		=> 'post_general_banner_social',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Post Banner Social', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
                    ) ,		
					array(
                        'id' 		=> 'post_general_banner_small_image',
                        'type' 		=> 'media',
                        'title' 	=> esc_html__('Post Banner Small Image', 'clinicmaster') ,
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
                    ) ,	
					array(
                        'id' 		=> 'post_general_banner_gallery',
                        'type' 		=> 'gallery',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Post Banner Gallery', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Enter post banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                       	'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
                    ) , 
					
					array(
                        'id' 		=> 'post_general_banner_contact_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Post Banner Contact Info', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,		
					array(
                        'id' 		=> 'post_general_banner_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Post Banner Text', 'clinicmaster') ,
                        'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,	
					array(
                        'id' 		=> 'post_general_banner_image_overlay',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'post_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
                    ) ,		

					
                    array(
                        'id' 		=> 'post-general-img-banner-section-end',
                        'type' 		=> 'section',
                        'indent' 	=> false,
						'required' 	=> array(0 => 'post_general_banner_on', 1 => 'equals', 2 => 1)
                    ),
					
                )
            );

            /*--------------------------------------------------------------
            # 6. Page Setting
            --------------------------------------------------------------*/

            $this->sections[] = array(
                'title' => esc_html__('Page Settings', 'clinicmaster') ,
                'icon' 	=> 'fa fa-file'
            );

            $this->sections[] = array(
                'title' 	=> esc_html__('General Settings', 'clinicmaster') ,
                'icon' 		=> 'fa fa-gear',
                'desc' 		=> '',
                'subsection'=> true,
                'fields'	=> array(
                    array(
                        'id' 		=> 'page_general_banner_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Page Banner', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'general-img-banner-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Banner Setting', 'clinicmaster') ,
                        'indent' 	=> true,
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => '1')
                    ) ,
					array(
                        'id' 		=> 'page_general_banner_layout',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Page Banner Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
                        'height' 	=> '80',
                        'options' 	=> $this->page_banner_layout_options,
                        'default' 	=> 'banner_layout_1',
						'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => '1')
                    ) ,
                    array(
                        'id' 		=> 'page_general_banner_height',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Page Banner Height', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the height for all tag page banner. Default : Medium Banner', 'clinicmaster') ,
                        'height' 	=> '40',
                        'options' 	=> $this->page_banner_options,
                        'default' 	=> 'page_banner_small',
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => '1')
                    ) ,
					array(
                        'id' 			=>  'page_general_banner_custom_height',
                        'type' 			=> 'slider',
                        'title' 		=> esc_html__('Page Banner Custom Height', 'clinicmaster') ,
                        'desc' 			=> esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                        'default' 		=> '',
                        'min' 			=> 100,
                        'max' 			=> 800,
                        'display_value' => 'text',
                        'required' 		=> array(0 => 'page_general_banner_height', 1 => 'equals', 2 => 'page_banner_custom'
                        )
                    ),
					
                    array(
                        'id' 		=> 'page_general_banner_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Page Banner Image', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => '1')
						
                    ) , 
					array(
                        'id' 			=> 'page_general_title_position',
                        'type' => 'button_set',
						'options' => array(
							'left' => esc_html__('Left', 'clinicmaster') ,
							'center' => esc_html__('Center', 'clinicmaster')
						),
                        'title' 		=> esc_html__('Title Position', 'clinicmaster') ,
						'default' => 'center',
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),

					) ,
					
					
					array(
                        'id' 		=> 'page_general_banner_social',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Page Banner Social', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
                    ) ,		
					array(
                        'id' 		=> 'page_general_banner_small_image',
                        'type' 		=> 'media',
                        'title' 	=> esc_html__('Page Banner Small Image', 'clinicmaster') ,
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
                    ) ,	
					array(
                        'id' 		=> 'page_general_banner_gallery',
                        'type' 		=> 'gallery',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Page Banner Gallery', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Page banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                       	'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
                    ) , 
					
					array(
                        'id' 		=> 'page_general_banner_contact_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Page Banner Contact Info', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,		
					array(
                        'id' 		=> 'page_general_banner_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Page Banner Text', 'clinicmaster') ,
                        'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,			
					array(
                        'id' 		=> 'page_general_banner_image_overlay',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => 'page_general_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
						
                    ) ,	
					
					
                    array(
                        'id' 		=> 'general-img-banner-section-end',
                        'type' 		=> 'section',
                        'indent' 	=> false,
                    ) ,
                    array(
                        'id' 		=> 'general-post-banner-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Post Banner Setting', 'clinicmaster') ,
                        'indent' 	=> true,
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'page_general_no_of_post',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Number of Posts', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Enter number of post. Default : 3', 'clinicmaster') ,
                        'default' 	=> '3',
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'general_post_banner_layout',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Post Banner Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select banner layout. Default : Full Banner', 'clinicmaster') ,
                        'options' 	=> $this->post_banner_options,
                        'default' 	=> 'post_banner_v1',
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'page_general_banner_cat',
                        'type' 		=> 'select',
                        'multi' 	=> true,
                        'data' 		=> 'terms',
                        'args' 		=> array('taxonomies' => 'category') ,
                        'title' 	=> esc_html__('Post Category', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select post category. It will work as default banner for all pages', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Allow you to select multiple categories.', 'clinicmaster') ,
                        'default' 	=> '',
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'page_general_post_type',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Post Type', 'clinicmaster') ,
                        'options' 	=> array(
                            'all' 	=> esc_html__('All', 'clinicmaster') ,
                            'featured'=> esc_html__('Featured', 'clinicmaster')
                        ) ,
                        'default' 	=> 'all',
                        'force_output'=> true,
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'page_general_items_with',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Items With', 'clinicmaster') ,
                        'options' 	=> array(
                            'with_any_type' 		=> esc_html__('Any Type', 'clinicmaster') ,
                            'with_featured_image' 	=> esc_html__('With Featured Image', 'clinicmaster') ,
                            'without_featured_image'=> esc_html__('Without Featured Iimage', 'clinicmaster')
                        ) ,
                        'default' 	=> 'with_any_type',
                        'required' 	=> array(0 => 'page_general_banner_on', 1 => 'equals', 2 => 'post')
                    ) ,
                    array(
                        'id' 		=> 'general-post-banner-section-end',
                        'type' 		=> 'section',
                        'indent' 	=> false,
                    ) ,
                    array(
                        'id' 		=> 'general-sidebar-section-start',
                        'type' 		=> 'section',
                        'title' 	=> esc_html__('Sidebar Setting', 'clinicmaster') ,
                        'indent' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'page_general_show_sidebar',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Sidebar', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true
                    ) ,
                    array(
                        'id' 		=> 'page_general_sidebar_layout',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Sidebar Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the layout for page. (Default : Right Side).', 'clinicmaster') ,
                        'options' 	=> $this->sidebar_layout_options,
                        'default' 	=> 'right',
                        'required' 	=> array(0 => 'page_general_show_sidebar', 1 => 'equals', 2 => '1')
                    ) ,
                    array(
                        'id' 		=> 'page_general_sidebar',
                        'type' 		=> 'select',
                        'data' 		=> 'sidebars',
                        'title' 	=> esc_html__('Sidebar', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select sidebar for all pages', 'clinicmaster') ,
                        'default' 	=> 'dz_blog_sidebar',
                        'required' 	=> array(0 => 'page_general_sidebar_layout', 1 => 'equals', 2 => array('right', 'left')
                        )
                    ) ,
                    array(
                        'id' 		=> 'general-sidebar-section-end',
                        'type' 		=> 'section',
                        'indent' 	=> false,
                    ) ,
                    array(
                        'id' 		=> 'page_general_paging',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Pagination', 'clinicmaster') ,
                        'options' 	=> array(
                            'default' 	=> esc_html__('Default', 'clinicmaster') ,
                            'load_more' => esc_html__('Load More', 'clinicmaster') ,
                            
                        ) ,
                        'default' 		=> 'default',
                        'force_output' 	=> true
                    ) ,
					
                )
            );

            $default_pages_data = array(
                'page_author' 	=> array(
                    'top_desc' 	=> esc_html__('The author template is shown when a user clicks on the author in the front end of the site.', 'clinicmaster'),
                    'id' 		=> 'author',
                    'title' 	=> esc_html__('Author','clinicmaster'),
                    'icon' 		=> 'fa fa-user'
                ) ,
                'page_category' => array(
                    'top_desc' 	=> esc_html__('The category template is shown when a user clicks on the category in the front end of the site.', 'clinicmaster'),
                    'id' 		=> 'category',
                    'title' 	=> esc_html__('Category','clinicmaster'),
                    'icon' 		=> 'fa fa-list-alt'
                ) ,
                'page_search' 	=> array(
                    'top_desc' 	=> esc_html__('Set the default layout for all the search page.', 'clinicmaster'),
                    'id' 		=> 'search',
                    'title' 	=> esc_html__('Search','clinicmaster'),
                    'icon' 		=> 'fa fa-search'
                ) ,
                'page_archive' 	=> array(
					'top_desc' 	=> esc_html__('This template is used by WordPress to generate the archives. By default WordPress generates daily, monthly and yearly archives.', 'clinicmaster'),
                    'id' 		=> 'archive',
                    'title' 	=> esc_html__('Archive','clinicmaster'),
                    'icon' 		=> 'fa fa-archive'
                ) ,
                'page_tag' 		=> array(
                    'top_desc' 	=> esc_html__('Set the default layout for all the tag page.', 'clinicmaster'),
                    'id' 		=> 'tag',
                    'title' 	=> esc_html__('Tag','clinicmaster'),
                    'icon' 		=> 'fa fa-tags'
                ) ,

            );
			
			if(clinicmaster_is_woocommerce_active())
			{
				$default_pages_data['page_woocommerce'] = array(
												'top_desc' => esc_html__('Set the default layout for all the woo-commerce pages.', 'clinicmaster'),
												'id' => 'woocommerce',
												'title' => esc_html__('Shop','clinicmaster'),
												'icon' => 'fa fa-shopping-cart',
												'sidebar'=>'dz_shop_sidebar'
											);
			}
			
            foreach ($default_pages_data as $key => $page_data)
            {

                $pg_desc = $page_data['top_desc'];
                $pg_id = $page_data['id'];
                $pg_name = $page_data['title'];
                $pg_icon = $page_data['icon'];
                $pg_sidebar = !empty($page_data['sidebar']) ? $page_data['sidebar'] : 'dz_blog_sidebar';

                if ($key == 'page_cmsoon')
                {
                    $page_templates = $this->coming_template_options;
                }
                elseif ($key == 'page_maintenance')
                {
                    $page_templates = $this->maintenance_template_options;
                }
                else
                {
                    $page_templates = $this->page_template_options;
                }

                $page_default_settings = $page_sorting = $page_pagination = array();

                $page_default_settings = array(
                    array(
                        'id' 			=> $pg_id . '_page_title',
                        'type' 			=> 'text',
                        'title' 		=> esc_html__('Page Title', 'clinicmaster') ,
                        'default' 		=> $pg_name .' : ',
                        'force_output'	=> true
                    ),
                    array(
                        'id' 			=> $pg_id . '_page_banner_on',
                        'type' 			=> 'switch',
                        'title' 		=> esc_html__('Page Banner', 'clinicmaster') ,
                        'on' 			=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 			=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 		=> true
                    ) ,
                    array(
                        'id' 			=> $pg_id . '-img-banner-section-start',
                        'type' 			=> 'section',
                        'title' 		=> esc_html__('Image Banner Setting', 'clinicmaster') ,
                        'indent' 		=> true,
                        'required' 		=> array(0 => $pg_id . '_page_banner_on', 1 => 'equals', 2 => 1)
                    ) ,
					array(
                        'id' 		=> $pg_id .'_page_banner_layout',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Page Banner Layout', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Choose the layout for all page banner. Default : Banner Layout 1', 'clinicmaster') ,
                        'height' 	=> '80',
                        'options' 	=> $this->page_banner_layout_options,
                        'default' 	=> 'banner_layout_1',
						'required' 		=> array(0 => $pg_id . '_page_banner_on', 1 => 'equals', 2 => 1)
                    ) ,
                    array(
                        'id' 			=> $pg_id . '_page_banner_height',
                        'type' 			=> 'image_select',
                        'title' 		=> esc_html__('Page Banner Height', 'clinicmaster') ,
                        'subtitle' 		=> esc_html__('Choose the height for page banner. Default : Medium Banner', 'clinicmaster') ,
                        'height' 		=> '40',
                        'options' 		=> $this->page_banner_options,
                        'default' 		=> 'page_banner_small',
                        'required' 		=> array(0 => $pg_id . '_page_banner_on', 1 => 'equals', 2 => 1)
                    ) ,
					
                    array(
                        'id' 			=> $pg_id . '_page_banner_custom_height',
                        'type' 			=> 'slider',
                        'title' 		=> esc_html__('Page Banner Custom Height', 'clinicmaster') ,
                        'desc' 			=> esc_html__('Hight description. Min: 100, max: 800', 'clinicmaster') ,
                        'default' 		=> '',
                        'min' 			=> 100,
                        'max' 			=> 800,
                        'display_value' => 'text',
                        'required' 		=> array(0 => $pg_id . '_page_banner_height', 1 => 'equals', 2 => 'page_banner_custom'
                        )
                    ) ,
                    array(
                        'id' 		=> $pg_id .'_page_banner_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Page Banner Image', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Enter page banner image. It will work as default banner image for all pages', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                        'required' 		=> array(0 => $pg_id . '_page_banner_on', 1 => 'equals', 2 => 1)
                    ) , 
					array(
                        'id' 			=> $pg_id .'_page_title_position',
                        'type' => 'button_set',
						'options' => array(
							'left' => esc_html__('Left', 'clinicmaster') ,
							'center' => esc_html__('Center', 'clinicmaster')
						),
                        'title' 		=> esc_html__('Title Position', 'clinicmaster') ,
						'default' => 'center',
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
					) ,
					array(
                        'id' 		=> $pg_id . '_page_banner_social',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Page Banner Social', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
                    ) ,		
					array(
                        'id' 		=> $pg_id . '_page_banner_small_image',
                        'type' 		=> 'media',
                        'title' 	=> esc_html__('Page Banner Small Image', 'clinicmaster') ,
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => 'banner_layout_2'),
                    ),	
					array(
                        'id' 		=> $pg_id . '_page_banner_gallery',
                        'type' 		=> 'gallery',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Page Banner Gallery', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Page banner Gallery. Only For 3 Image Work', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Upload banner image.', 'clinicmaster') ,
                       	'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => 'banner_layout_3'),
                    ) , 
					
					array(
                        'id' 		=> $pg_id . '_page_banner_contact_on',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Post Banner Contact Info', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> true,
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,		
					array(
                        'id' 		=> $pg_id . '_page_banner_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Page Banner Text', 'clinicmaster') ,
                        'default' 	=> esc_html__('24/7 EMERGENCY SERVICE', 'clinicmaster'),
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => 'banner_layout_1'),
                    ) ,	
					array(
                        'id' 		=> $pg_id .'_page_banner_image_overlay',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Banner Image Overlay', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
						'required' 	=> array(0 => $pg_id . '_page_banner_layout', 1 => 'equals', 2 => array('banner_layout_1','banner_layout_2')),
                        'default' 	=> true
                    ) ,	
					
					
                   
                    array(
                        'id' 			=> $pg_id . '-img-banner-section-end',
                        'type' 			=> 'section',
                        'indent' 		=> false,
                    ) ,
                    
                );
				
					$page_sorting = array(
						array(
							'id' 			=> $pg_id . '-sidebar-section-start',
							'type' 			=> 'section',
							'title' 		=> esc_html__('Sidebar Setting', 'clinicmaster') ,
							'indent' 		=> true
						) ,
						array(
							'id' 			=> $pg_id . '_page_show_sidebar',
							'type' 			=> 'switch',
							'title' 		=> esc_html__('Sidebar', 'clinicmaster') ,
							'on' 			=> esc_html__('Enabled', 'clinicmaster') ,
							'off' 			=> esc_html__('Disabled', 'clinicmaster') ,
							'default' 		=> true
						) ,
						array(
							'id' 			=> $pg_id . '_page_sidebar_layout',
							'type' 			=> 'image_select',
							'title' 		=> esc_html__('Sidebar Layout', 'clinicmaster') ,
							'subtitle' 		=> esc_html__('Choose the layout for the page. (Default : Right Side).', 'clinicmaster') ,
							'options' 		=> $this->sidebar_layout_options,
							'default' 		=> 'right',
							'required' 		=> array(0 => $pg_id . '_page_show_sidebar', 1 => 'equals', 2 => '1')
						) ,
						array(
							'id' 			=> $pg_id . '_page_sidebar',
							'type' 			=> 'select',
							'data' 			=> 'sidebars',
							'title' 		=> esc_html__('Sidebar', 'clinicmaster') ,
							'subtitle' 		=> esc_html__('Select sidebar for the page.', 'clinicmaster') ,
							'default' 		=> $pg_sidebar,
							'required' 		=> array(0 => $pg_id . '_page_sidebar_layout', 1 => 'equals', 2 => array(     'right','left')
							)
						) ,
						
						array(
							'id' 			=> $pg_id . '-sidebar-section-end',
							'type' 			=> 'section',
							'indent' 		=> false,
						) ,
					);
				
				if ($pg_id != 'woocommerce')
                {
                    $page_pagination = array(
                        array(
                            'id' 			=> $pg_id . '_page_paging',
                            'type' 			=> 'button_set',
                            'title' 		=> esc_html__('Pagination', 'clinicmaster') ,
                            'options' 		=> 	array(
													'default' => esc_html__('Default', 'clinicmaster') ,
													'load_more' => esc_html__('Load More', 'clinicmaster') ,
												),
                            'default' 		=> 'default',
                            'force_output'	=> true
                        ) ,
						
                        array(
                            'id' 			=> $pg_id . '_page_sorting_on',
                            'type'	 		=> 'switch',
                            'title' 		=> esc_html__('Sorting', 'clinicmaster') ,
                            'on' 			=> esc_html__('Enabled', 'clinicmaster') ,
                            'off' 			=> esc_html__('Disabled', 'clinicmaster') ,
                            'default' 		=> true
                        ) ,
                        array(
                            'id' 			=> $pg_id . '_page_sorting',
                            'type' 			=> 'select',
                            'title' 		=> esc_html__('Select Sorting', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('Select Sorting', 'clinicmaster') ,
                            'desc' 			=> esc_html__('Select Sorting', 'clinicmaster') ,
                            'options' 		=> $this->sort_by_options,
                            'default' 		=> 'date_asc',
                            'force_output' 	=> true,
                            'required' 		=> 	array(
													0 => $pg_id . '_page_sorting_on',
													1 => 'equals',
													2 => '1'
												)
                        ) ,
                    );
                }
                $final_page_options = array_merge($page_default_settings, $page_sorting, $page_pagination);

                $this->sections[] = array(
                    'title' 	=> $pg_name . esc_html__(' Page', 'clinicmaster') ,
                    'icon' 		=> $pg_icon,
                    'desc' 		=> '',
                    'subsection'=> true,
                    'fields' 	=> $final_page_options,
                );

            }

            $this->sections[] = array(
                'title'		=> esc_html__('404 Page', 'clinicmaster') ,
                'icon' 		=> 'fa fa-warning',
                'desc' 		=> '',
                'subsection'=> true,
                'fields' => array(
                    array(
                        'id' 			=> 'error_page_title',
                        'type' 			=> 'text',
                        'title' 		=> esc_html__('Page Title', 'clinicmaster') ,
                        'default' 		=> esc_html__('404', 'clinicmaster') ,
                        'force_output' 	=> true
                    ) ,

                    array(
                        'id' 			=> 'error_page_template',
                        'type' 			=> 'image_select',
                        'height' 		=> '80',
                        'title' 		=> esc_html__('404 Template', 'clinicmaster') ,
                        'subtitle' 		=> esc_html__('Select a template for the page.', 'clinicmaster') ,
                        'options' 		=> array(
                            'error_style_1' => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error-404.png',
                            'error_style_2' => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error2-404.png',
                            'error_style_3' => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error3-404.png',
                        ) ,
                        'default' 		=> 'error_style_1'
                    ) ,
					array(
                        'id' 			=> 'error_page_subtitle',
                        'type' 			=> 'text',
                        'title' 		=> esc_html__('Page SubTitle', 'clinicmaster') ,
                        'default' 		=> esc_html__('We are sorry. But the page you are looking for cannot be found.', 'clinicmaster') ,
                        'force_output' 	=> true,
                    ) ,
					array(
                        'id' 			=> 'error_page_image',
                        'type' 			=> 'media',
                        'title' 		=> esc_html__('Upload Image', 'clinicmaster') ,
                        'required' 		=> array(0 => 'error_page_template', 1 => 'equals', 2 => array('error_style_2','error_style_3')),
                    ) ,
					array(
                        'id' 			=> 'error_page_pattern_image',
                        'type' 			=> 'media',
                        'title' 		=> esc_html__('Pattern Image', 'clinicmaster') ,
                        'required' 		=> array(0 => 'error_page_template', 1 => 'equals', 2 => array('error_style_2')),
                    ) ,
                    array(
                        'id' 		=> 'error_page_button_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('404 Page Button Text', 'clinicmaster') ,
                        'default' 	=> esc_html__('Back to Homepage', 'clinicmaster'),
                    ) ,
                    

                )
            );
			
			/*--------------------------------------------------------------
			# 9. WooCommerce Setting
			--------------------------------------------------------------*/
			if(clinicmaster_is_woocommerce_active())
			{
				$this->sections[] = array(
					'title'  => esc_html__('WooCommerce Settings', 'clinicmaster'),
					'icon'   => 'el el-shopping-cart'
				);

				$this->sections[] = array(
					'title'  => esc_html__('WooCommerce', 'clinicmaster'),
					'icon'   => 'fa fa-shopping-basket',
					'subsection' => true,
					'fields' => array(
						array(
							'id'       		=> 	'cart_on',
							'type'     		=> 	'switch',
							'title'    		=> 	esc_html__('Cart Enable', 'clinicmaster'),
							'subtitle' 		=> 	esc_html__('Click on the tab to show / hide cart from header.', 'clinicmaster'),
							'on'       		=> 	esc_html__('Enabled', 'clinicmaster'),
							'off'      		=> 	esc_html__('Disabled', 'clinicmaster'),
							'default'  		=> 	true,
							'hint'     		=> 	array(
												'title'   => esc_html__('Cart Visible', 'clinicmaster'),
												'content' => esc_html__('Cart will show in top bar.', 'clinicmaster')
											)
						),
						
						
						array(
							'id'       		=> 'no_of_product_per_page',
							'type'     		=> 'spinner',
							'title'    		=> esc_html__('Number of Product Display Per Page', 'clinicmaster'),
							'subtitle' 		=> esc_html__('Show number of product page', 'clinicmaster'),
							'default'  		=> 9,
							'min'      		=> 1,
							'step'     		=> 1,
							'max'      		=> 100,
						),
						array(
							'id'            => 'no_of_product_column',
							'type'          => 'slider',
							'title'         => esc_html__( 'Product Columns', 'clinicmaster' ),
							'default'       => 3,
							'min'           => 1,
							'step'          => 1,
							'max'           => 4,
							'display_value' => 'label',
						),
						array(
							'id'       		=> 'show_related_product',
							'type'     		=> 'switch',
							'title'    		=> esc_html__('Show Related Product', 'clinicmaster'),
							'subtitle' 		=> esc_html__('Click on the tab to show / hide related products on single product page.', 'clinicmaster'),
							'on'       		=> esc_html__('Enabled', 'clinicmaster'),
							'off'      		=> esc_html__('Disabled', 'clinicmaster'),
							'default'  		=> true
						),
						array(
							'id'            => 'no_of_related_product',
							'type'          => 'slider',
							'title'         => esc_html__( 'Related Product', 'clinicmaster' ),
							'default'       => 3,
							'min'           => 1,
							'step'          => 1,
							'max'           => 4,
							'display_value' => 'label',
						),
					
					)
					

				);
				
			}

            

			
            /*--------------------------------------------------------------
            # 10. Theme Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Theme Settings', 'clinicmaster') ,
                'icon' => 'el el-cogs'
            );

            $this->sections[] = array(
                'title' 	=> esc_html__('Color & Design', 'clinicmaster') ,
                'icon' 		=> 'fa fa-pencil',
                'subsection'=> true,
                'fields' 	=> array(
					array(
						'id'      => 'color_skin_setting',
						'type'    => 'button_set',
						'title'   => esc_html__( 'Theme Color Settings', 'clinicmaster' ),
						'desc'    => esc_html__( 'Choose Color Setting', 'clinicmaster' ),
						'options' => array(
							'predefined_color_skin' => esc_html__( 'Predefined Color', 'clinicmaster' ),
							'custom_color_skin'     => esc_html__( 'Custom Color', 'clinicmaster' ),
						),
						'default' => 'predefined_color_skin',
					),
					array(
						'id'       => 'predefined_color_skin',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Theme Color', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Only color validation can be done on this field type', 'clinicmaster' ),
						'options'  => $this->theme_color_options,
						'default'  => 'skin_1',
						'height'   => '50',
						'required' => array(
							0 => 'color_skin_setting',
							1 => 'equals',
							2 => 'predefined_color_skin',
						),
					),
					array(
						'id'          => 'primary_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Primary Color', 'clinicmaster' ),
						'transparent' => false,
						'default'     => '#00BDE0',
						'required'    => array(
							0 => 'color_skin_setting',
							1 => 'equals',
							2 => 'custom_color_skin',
						),
					),
					array(
						'id'          => 'secondary_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Secondary Color', 'clinicmaster' ),
						'transparent' => false,
						'default'     => '#031B4E',
						'required'    => array(
							0 => 'color_skin_setting',
							1 => 'equals',
							2 => 'custom_color_skin',
						),
					),
				
					array(
						'id'          => 'light',
						'type'        => 'color',
						'title'       => esc_html__( 'Light Color', 'clinicmaster' ),
						'transparent' => false,
						'default'     => '#ECF5FB',
						'required'    => array(
							0 => 'color_skin_setting',
							1 => 'equals',
							2 => 'custom_color_skin',
						),
					),
                    array(
                        'id' 		=> 'page_loader_type',
                        'type' 		=> 'button_set',
                        'title' 	=> esc_html__('Page Loader Type', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select Loader Type.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Choose Loading Image', 'clinicmaster') ,
                        'options' 	=> array(
                            'loading_image' 	=> esc_html__('Loading Image', 'clinicmaster') ,
                            'advanced_loader' 	=> esc_html__('Advanced Page Loader', 'clinicmaster')
                        ) ,
                        'default' 	=> 'loading_image',
                        'hint' 		=> array(
                            'title' 	=> esc_html__('Write title text here', 'clinicmaster') ,
                            'content' 	=> esc_html__('Write content text here.', 'clinicmaster')
                        )
                    ) ,
                    array(
                        'id' 		=> 'page_loader_image',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Loding Image (Gif)', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select Gif Image.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Choose Gif Image.', 'clinicmaster') ,
                        'options' 	=> $this->page_loader_options,
                        'default' 	=> 'loading1',
                        'height' 	=> '35',
                        'hint' 		=> array(
                            'title' => esc_html__('Loding Image (Gif)', 'clinicmaster') ,
                            'content'=> esc_html__('Choose Gif Image.', 'clinicmaster')
                        ) ,
                        'required' 	=> array(0 => 'page_loader_type', 1 => 'equals', 2 => 'loading_image')
                    ) ,
                    array(
                        'id' 		=> 'custom_page_loader_image',
                        'type' 		=> 'media',
                        'url' 		=> true,
                        'title' 	=> esc_html__('Custom Loding Image (Gif)', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select Custom Loding Gif Image.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Choose Gif Image', 'clinicmaster') ,
                        'hint' 		=> array(
                            'title' => esc_html__('Custom Loding Image (Gif)', 'clinicmaster') ,
                            'content'=> esc_html__('Choose Gif Image.', 'clinicmaster')
                        ) ,
                        'required' 	=> array(0 => 'page_loader_type', 1 => 'equals', 2 => 'loading_image')
                    ) ,
                    array(
                        'id' 		=> 'advanced_page_loader_image',
                        'type' 		=> 'image_select',
                        'title' 	=> esc_html__('Advanced Loding Image', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select Advance Loding Image (Gif)', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Choose Advance Loding Image', 'clinicmaster') ,
                        'options' 	=> array(
                            'loading1' 	=> get_template_directory_uri() . '/dz-inc/assets/images/advanced-loading-images/loading1.gif',
                            'loading2' 	=> get_template_directory_uri() . '/dz-inc/assets/images/advanced-loading-images/loading2.gif',
                        ) ,
                        'default' 	=> 'loading1',
                        'height' 	=> '60',
                        'hint' 		=> array(
                            'title' => esc_html__('Advance Loding Image (Gif)', 'clinicmaster') ,
                            'content'=> esc_html__('Choose Advance Loding Image', 'clinicmaster')
                        ) ,
                        'required' => array(0 => 'page_loader_type', 1 => 'equals', 2 => 'advanced_loader')
                    ) ,
					 array(
                        'id' 		=> 'advanced_page_loader_text',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Loader Text', 'clinicmaster') ,
                        'default' 	=> esc_html__('Your Wait Is Going To Finish', 'clinicmaster'),
						'required' => array(
							array(0 => 'page_loader_type', 1 => 'equals', 2 => 'advanced_loader'),
							array(0 => 'advanced_page_loader_image', 1 => 'equals', 2 => 'loading1'),
						),
                    ) ,
					array(
						'id'       => 'theme_layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Theme Layout', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Choose theme layout.', 'clinicmaster' ),
						'desc'     => esc_html__( 'Click in the image icon to select the theme layout (Default : Full Width).', 'clinicmaster' ),
						'options'  => $this->theme_layout_options,
						'height'   => '80',
						'default'  => 'theme_layout_1',
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'clinicmaster' ),
							'content' => esc_html__( '1. Full Width: the web pages will be full width as shown in the image.', 'clinicmaster' ) . '<br><br>' . esc_html__( '2. Boxed: with the box layout the padding will be applied on two sides (Left, Right) of the page.', 'clinicmaster' ) . '<br><br>' . esc_html__( '3. Frame: with the frame layout the padding will be applied on all sides (Top, Right, Bottom, Left) of the page.', 'clinicmaster' ),
						),
					),
					array(
						'id'            => 'boxed_layout_bg_pattern_padding',
						'type'          => 'slider',
						'title'         => esc_html__( 'Padding', 'clinicmaster' ),
						'desc'          => esc_html__( 'Padding description. Min: 10, max: 100, default value: 20', 'clinicmaster' ),
						'default'       => 20,
						'min'           => 10,
						'max'           => 100,
						'display_value' => 'text',
						'required'      => array(
							array(
								0 => 'theme_layout',
								1 => 'equals',
								2 => 'theme_layout_3',
							),
						),
					),
					array(
						'id'       => 'body_boxed_bg_type',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Background Type', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select the background type.', 'clinicmaster' ),
						'desc'     => esc_html__( 'Click on the tab to choose background type', 'clinicmaster' ),
						'options'  => array(
							'bg_type_color'   => esc_html__( 'Type Color', 'clinicmaster' ),
							'bg_type_image'   => esc_html__( 'Type Image', 'clinicmaster' ),
							'bg_type_pattern' => esc_html__( 'Type Pattern', 'clinicmaster' ),
						),
						'default'  => 'bg_type_color',
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'clinicmaster' ),
							'content' => esc_html__( '1. Type Color: page background will be type color.', 'clinicmaster' ) . '<br><br>' . esc_html__( '2. Type Image: page background will be type image.', 'clinicmaster' ) . '<br><br>' . esc_html__( '3. Type Pattern: page background will be type pattern.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'theme_layout',
							1 => 'equals',
							2 => array(
								'theme_layout_2',
								'theme_layout_3',
							),
						),
					),
					array(
						'id'       => 'boxed_layout_bg_color',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Color', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select background color', 'clinicmaster' ),
						'desc'     => esc_html__( 'Click on the image icon to choose background color.', 'clinicmaster' ),
						'options'  => $this->theme_color_background_options,
						'height'   => '35',
						'default'  => 'bg_color_1',
						'hint'     => array(
							'title'   => esc_html__( 'Write title text here', 'clinicmaster' ),
							'content' => esc_html__( 'Write content text here.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_color',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_color',
						'type'     => 'color_rgba',
						'title'    => 'Custom Background Color',
						'subtitle' => esc_html__( '(Optional) Choose background color as gradient color.', 'clinicmaster' ),
						'default'  => array(
							'color' => '',
							'alpha' => 1,
						),
						'options'  => array(
							'show_input'             => true,
							'show_initial'           => true,
							'show_alpha'             => true,
							'show_palette'           => false,
							'show_palette_only'      => false,
							'show_selection_palette' => true,
							'max_palette_size'       => 10,
							'allow_empty'            => true,
							'clickout_fires_change'  => false,
							'choose_text'            => 'Choose',
							'cancel_text'            => 'Cancel',
							'show_buttons'           => true,
							'use_extended_classes'   => true,
							'palette'                => null,
							'input_text'             => 'Select Color',
						),
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'clinicmaster' ),
							'content' => esc_html__( '1. Click on Select Color button content text here.', 'clinicmaster' ) . '<br><br>' . esc_html__( '2. Select the color as you want and click on Choose.', 'clinicmaster' ) . '<br><br>' . esc_html__( '3. On top/bottom of the panel, click on Save Changes button.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_color',
						),
					),
					array(
						'id'       => 'boxed_layout_bg_image',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Image', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select Background Image', 'clinicmaster' ),
						'desc'     => esc_html__( 'Choose Background Image', 'clinicmaster' ),
						'options'  => $this->theme_image_background_options,
						'height'   => '35',
						'default'  => 'bg_img_1',
						'hint'     => array(
							'title'   => esc_html__( 'Background Image', 'clinicmaster' ),
							'content' => esc_html__( 'Choose Background Image.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_image',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_image',
						'type'     => 'media',
						'url'      => true,
						'height'   => '35',
						'title'    => esc_html__( 'Custom Background Image', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select Custom Background Image.', 'clinicmaster' ),
						'desc'     => esc_html__( 'Choose Custom Background Image.', 'clinicmaster' ),
						'default'  => array(
							'url' => '',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Custom Background Image', 'clinicmaster' ),
							'content' => esc_html__( 'Choose Custom Background Image.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_image',
						),
					),
					array(
						'id'       => 'boxed_layout_bg_pattern',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Pattern', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select Background Pattern.', 'clinicmaster' ),
						'desc'     => esc_html__( 'Choose Background Pattern.', 'clinicmaster' ),
						'options'  => $this->theme_pattern_background_options,
						'default'  => 'bg_pattern_1',
						'height'   => '35',
						'hint'     => array(
							'title'   => esc_html__( 'Background Pattern', 'clinicmaster' ),
							'content' => esc_html__( 'Choose Background Pattern.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_pattern',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_pattern',
						'type'     => 'media',
						'url'      => true,
						'width'    => '35',
						'height'   => '35',
						'title'    => esc_html__( 'Custom Background Pattern', 'clinicmaster' ),
						'subtitle' => esc_html__( 'Select Custom Background Pattern.', 'clinicmaster' ),
						'desc'     => esc_html__( 'Choose Custom Background Pattern.', 'clinicmaster' ),
						'default'  => array(
							'url' => '',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Custom Background Pattern', 'clinicmaster' ),
							'content' => esc_html__( 'Choose Custom Background Pattern.', 'clinicmaster' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_pattern',
						),
					),
				),
                
            );


            $theme_fonts = array(
                'Font & Sizes' 	=> array(
                    'id' 		=> 'general',
                    'title' 	=> 'General Fonts',
                    'heading' 	=> 'General Settings',
                    'desc' 		=> 'When a user requests a page or post that doesn`t exists, WordPress will use this template.'
                ) ,
            );

            foreach ($theme_fonts as $key => $font)
            {

                $font_id = $font['id'];
                $font_title = $font['title'];
                $font_heading = $font['heading'];
                $font_desc = $font['desc'];

                $this->sections[] = array(
                    'title' 		=> $key,
                    'heading' 		=> $font_heading,
                    'desc' 			=> $font_desc,
                    'icon' 			=> 'el-icon-text-width',
                    'subsection' 	=> true,
                    'fields' 		=> array(
                        array(
                            'id' 			=> $font_id . '_font',
                            'type' 			=> 'button_set',
                            'title' 		=> $font_title,
                            'options' 		=> array(
                                'Open-Sans' 	=> esc_html__('Default', 'clinicmaster') ,
                                'Google-Font' 	=> esc_html__('Google Fonts', 'clinicmaster') ,
                            ) ,
                            'default' 		=> 'Open-Sans',
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_body',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('Body', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for body tag of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup'	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('body') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true,

                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h1',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H1', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H1 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h1') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h2',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H2', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H2 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h2') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h3',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H3', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H3 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h3') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h4',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H4', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H4 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h4') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h5',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H5', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H5 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h5') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_h6',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('H6', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all H6 tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('h6') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        ) ,
                        array(
                            'id' 			=> $font_id . '_font_p_tag',
                            'type' 			=> 'typography',
                            'title' 		=> esc_html__('P (Paragraph Text)', 'clinicmaster') ,
                            'subtitle' 		=> esc_html__('This will be the default font for all P tags of your website.', 'clinicmaster') ,
                            'google' 		=> true,
                            'font-backup' 	=> true,
                            'all_styles' 	=> true,
                            'text-align' 	=> false,
                            'color' 		=> true,
                            'output' 		=> array('p') ,
                            'units' 		=> 'px',
                            'required' 		=> array(0 => $font_id . '_font', 1 => 'equals', 2 => 'Google-Font') ,
                            'force_output' 	=> true
                        )
                    )
                );
            }

            /*--------------------------------------------------------------
            # 11. Social Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Social Setting', 'clinicmaster') ,
                'icon' 	=> 'el el-twitter',
            );

            $socialLinkFiels[] = array(
                'id' 		=> 'social_link_target',
                'type' 		=> 'select',
                'title' 	=> esc_html__('Choose Social Link Target', 'clinicmaster') ,
                'options' 	=> $this->link_target_options,
                'default' 	=> '_blank'
            );

            foreach ($this->social_link_options as $social_link)
            {

                $sl_id 		= $social_link['id'];
                $sl_title 	= $social_link['title'];

                $socialLinkFiels[] = array(
                    'id' 		=> 'social_' . $sl_id . '_url',
                    'type' 		=> 'text',
                    'title' 	=> $sl_title . esc_html__(' URL', 'clinicmaster') ,
                    'subtitle' 	=> esc_html__('Link to : ', 'clinicmaster') . $sl_title,
                    'default' 	=> '',
                );
            }

            $this->sections[] = array(
                'title' 		=> esc_html__('Social Link', 'clinicmaster') ,
                'icon' 			=> 'el-icon-facebook',
                'subsection' 	=> true,
                'fields' 		=> $socialLinkFiels
            );

            $social_share_list = $social_share_default = array();
            $i = 1;
            foreach ($this->social_share_options as $social_link)
            {

                $social_share_list[$social_link['id']] = $social_link['title'];

                if ($i <= 3)
                {
                    $social_share_default[$social_link['id']] = true;
                }
                else
                {
                    $social_share_default[$social_link['id']] = false;
                }
                $i++;
            }

            $this->sections[] = array(
                'title' 	=> esc_html__('Social Sharing', 'clinicmaster') ,
                'icon' 		=> 'el-icon-facebook',
                'subsection'=> true,
                'fields' => array(
                    array(
                        'id' 		=> 'social_sharing_on_post',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Enable Social Shaing On Post', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false
                    ) ,
                    array(
                        'id' 		=> 'social_sharing_on_page',
                        'type' 		=> 'switch',
                        'title' 	=> esc_html__('Enable Social Shaing On Page', 'clinicmaster') ,
                        'on' 		=> esc_html__('Enabled', 'clinicmaster') ,
                        'off' 		=> esc_html__('Disabled', 'clinicmaster') ,
                        'default' 	=> false
                    ) ,
                    array(
                        'id' 		=> 'share_sort_link',
                        'type' 		=> 'sortable',
                        'title' 	=> esc_html__('Social Sharing', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Select active social share links and sort them with drag and drop.', 'clinicmaster') ,
                        'mode' 		=> 'checkbox',
                        'options' 	=> $social_share_list,
                        /* For checkbox mode */
                        'default' 	=> $social_share_default
                    )
                )
            );

            /*--------------------------------------------------------------
            # 12. Custom Script Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Custom Script', 'clinicmaster') ,
                'icon' 	=> 'el el-list-alt'
            );

            $this->sections[] = array(
                'title' 	=> esc_html__('Custom Script', 'clinicmaster') ,
                'icon' 		=> 'el el-list-alt',
                'subsection'=> true,
                'fields' 	=> array(
                    array(
                        'id' 		=> 'body_class',
                        'type' 		=> 'text',
                        'title' 	=> esc_html__('Body Class(s)', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('You can add one or more classes on theme body element. If you need more then one class, add them with a space between them.', 'clinicmaster') ,
                        'desc' 		=> esc_html__('Ex: body-class-1 body-class-2', 'clinicmaster')
                    ) ,
                    array(
                        'id' 		=> 'css_editor',
                        'type' 		=> 'ace_editor',
                        'title' 	=> esc_html__('CSS Code', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Paste your CSS code here.', 'clinicmaster') ,
                        'mode' 		=> 'css',
                        'theme' 	=> 'monokai'
                    ) ,
                    array(
                        'id' 		=> 'js_editor',
                        'type' 		=> 'ace_editor',
                        'title' 	=> esc_html__('Javascript Code', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Paste your JS code here.', 'clinicmaster') ,
                        'mode' 		=> 'javascript',
                        'theme' 	=> 'chrome',
						
						'desc' => esc_html__("Don't Use Script Tag:  &lt;script&gt;...&lt;/script&gt;", 'clinicmaster'),
                    ) ,
                    array(
                        'id' 		=> 'html_editor',
                        'type' 		=> 'ace_editor',
                        'title' 	=> esc_html__('HTML Code', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('Paste your HTML code here.', 'clinicmaster') ,
                        'mode' 		=> 'html',
                        'theme' 	=> 'chrome'
                    )
                )
            );

            $this->sections[] = array(
                'title' 	=> esc_html__('Analytic Code', 'clinicmaster') ,
                'icon' 		=> 'el-icon-edit',
                'subsection'=> true,
                'fields' 	=> array(

                    array(
                        'id' 		=> 'site_header_code',
                        'type' 		=> 'textarea',
                        'theme' 	=> 'chrome',
                        'title' 	=> esc_html__('Header Custom Codes', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('It will insert the code to wp_head hook.', 'clinicmaster') ,
                    ) ,
                    array(
                        'id' 		=> 'site_footer_code',
                        'type' 		=> 'textarea',
                        'theme' 	=> 'chrome',
                        'title' 	=> esc_html__('Footer Custom Codes', 'clinicmaster') ,
                        'subtitle' 	=> esc_html__('It will insert the code to wp_footer hook.', 'clinicmaster') ,
                    )
                )
            );

			$seo_fields = apply_filters('dzcore_seo_fields',$args = array());
			$active_plugins = get_option('active_plugins');
			$seo_plugins = [
				'wordpress-seo/wp-seo.php',                    // Yoast SEO
				'all-in-one-seo-pack/all_in_one_seo_pack.php', // All in One SEO
				'seo-by-rank-math/rank-math.php',              // Rank Math SEO
				'wp-seopress/seopress.php',                    // SEOPress
				'the-seo-framework/the-seo-framework.php',     // The SEO Framework
				'squirrly-seo/squirrly.php',                   // Squirrly SEO
				'wp-smart-crawl/wp-smart-crawl.php',           // SmartCrawl SEO
			];

			$active_seo_plugins = array_intersect($seo_plugins, $active_plugins);
			if(!class_exists('DZSeo') && !$active_seo_plugins){
				$this->sections[] = array(
					'title' => esc_html__('SEO Meta Tags', 'clinicmaster') ,
					'icon' => 'el el-search-alt',
					'fields' => $seo_fields,
				); 
			}

            /*--------------------------------------------------------------
            # 15. Advance Settings
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title' => esc_html__('Advance Options', 'clinicmaster') ,
                'icon' 	=> 'el el-cogs'
            );

            $advanceSettingSidebarFields[] = array(
                'id' 			=> 'new_sidebar_input',
                'type' 			=> 'multi_text',
                'title' 		=> esc_html__('Sidebar Name', 'clinicmaster') ,
                'subtitle' 		=> esc_html__('Name your sidebar!', 'clinicmaster') ,
                'desc' 			=> esc_html__('Enter the text only. ', 'clinicmaster') . '<a href="' . admin_url('widgets.php') . '" target="_blank">' . esc_html__('Click Here.', 'clinicmaster') . '</a>' . esc_html__(' to check your sidebars', 'clinicmaster') ,
                'hint' 			=> array(
                    'title' 	=> esc_html__('What to Do?', 'clinicmaster') ,
                    'content' 	=> esc_html__('1. Once you named your sidebar click on the Save Changes button @ the top of the panel.', 'clinicmaster') . '<br><br>' . esc_html__('2. After save changes please just refresh the page, you will see the sidebar listed below.', 'clinicmaster')
                ) ,
            );

            $sidebars_widgets = get_option('sidebars_widgets');

            if (!empty($sidebars_widgets))
            {
                $i = 1;
                foreach ($sidebars_widgets as $key => $value)
                {
                    $keyExt 	= substr($key, 3);
                    $keyRep1 	= str_replace('-', ' ', $keyExt);
                    $keyRep2 	= str_replace('-', '_', $keyExt);
                    $dzWidget 	= ucfirst($keyRep1);

                    if (strpos($key, 'dz-') === 0)
                    {
                        $advanceSettingSidebarFields[] = array(
                            'id' 	=> 'avail_sidebar_' . $keyRep2 . '_' . $i,
                            'type' 	=> 'info',
                            'style' => 'info',
                            'desc' 	=> esc_html($dzWidget, 'clinicmaster')
                        );
                    }
                    $i++;
                }
            }

            $this->sections[] = array(
                'title' 	=> esc_html__('Create Sidebar', 'clinicmaster') ,
                'icon' 		=> 'el el-pencil',
                'desc' 		=> esc_html__('Dexignlab gives you the functionality to create your own Sidebars. Default there are three Sidebars as display below.', 'clinicmaster') ,
                'subsection'=> true,
                'fields' 	=> $advanceSettingSidebarFields
            );
        }

        /**
         * Get default theme oiptions
         *
         * @param $key
         * @param $default
         * @return $value
         */
        function clinicmaster_get_default_option($key, $default = '')
        {
            if (empty($key))
            {
                return '';
            }
            $options = get_option(clinicmaster_get_opt_name() , array());
            $value = isset($options[$key]) ? $options[$key] : $default;

            return $value;
        }

    }

    global $clinicmasterthemeoption;

    $clinicmasterthemeoption = new ClinicMaster_Redux_Framework_config();
}

