(function($) {	
	"use strict";

var DZWPScript =  function (){
	
	var screenWidth = jQuery( window ).width();	
	if(typeof clinicmaster_js_data == 'undefined'){
		var siteUrl                      = '/';	
		var login_on_mobile				 = false;
		var cart_on_mobile				 = false;
		var login_on_desktop			 = false;
		var header_social_link_on_mobile = false;
		var skin = 'skin-1';
	}else{
		var siteUrl 					 = clinicmaster_js_data.template_directory_url+'/';	
		var cart_on_mobile				 = clinicmaster_js_data.cart_on_mobile;
		var login_on_mobile				 = clinicmaster_js_data.login_on_mobile;
		var login_on_desktop			 = clinicmaster_js_data.login_on_desktop;
		var header_social_link_on_mobile = clinicmaster_js_data.header_social_link_on_mobile;
		var skin = clinicmaster_js_data.skin;
		
	}
	/* jQuery('html').attr('data-theme-color', skin); */
	var WebsiteLaunchDate = new Date(); /* Default website launch date one month plus in current date */
	var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	WebsiteLaunchDate.setMonth(WebsiteLaunchDate.getMonth() + 1);
	WebsiteLaunchDate =  WebsiteLaunchDate.getDate() + " " + monthNames[WebsiteLaunchDate.getMonth()] + " " + WebsiteLaunchDate.getFullYear();
  
	var themeWorkOnMobile = function() {		
		/* if(screenWidth <= 991){
			if(cart_on_mobile == 'No') { jQuery('.dz-cart-btn').hide(); }
			if(header_social_link_on_mobile == 'No') { jQuery('.dz-social-link').hide(); }
			if(login_on_mobile == 'No') { 
				jQuery('.dz-login-btn').hide(); 
			}else{
				jQuery('.dz-login-btn').show();
			}
		}else{
			jQuery('.dz-cart-btn, .dz-social-link').show(); 
			if(login_on_desktop == 'No') { 
				jQuery('.dz-login-btn').hide();
			}else{
				jQuery('.dz-login-btn').show();
			}
				
		}	 */
	}
  
	var handleMegaMenu = function (){		
		/*--------------- STARTS- AJAX Load Mega menu posts ------------------*/
		function load_mega_menu_posts() {
				var cat_slug = jQuery(this).attr('id').split('st_')[1];	
				var posts_per_page = parseInt(jQuery(this).data('posts-per-page'));
				var cat_id = parseInt(jQuery(this).data('cat-id'));		
				var images_only = jQuery(this).data('images-only');		
				var data = {
						'action': 'load_mega_menu_posts_by_ajax',
						'page': 1,					
						'posts_per_page': posts_per_page,					
						'posts_in_categories': cat_id,
						'mega_menu_images_only': images_only,
						'security': clinicmaster_js_data.ajax_security_nonce
					};			
				
					jQuery.ajax({
						method: 'POST',
						url: clinicmaster_js_data.admin_ajax_url,
						type: 'JSON',
						data: data,
						beforeSend : function ( xhr ) {
							jQuery("#"+ cat_slug).html("<div class='dz-menu-loading' ></div>");
						},
						success:function(response){                
							if( response ) { 
								jQuery("#"+ cat_slug).html(response);					
							}
						},
						complete : function(){		
							header_blog_carousel();
						}	
					}); 
		}
		
		if(jQuery("a.post-tabs").length > 0){	
			jQuery("a.post-tabs").off('mouseover',load_mega_menu_posts);
			jQuery("a.post-tabs").on('mouseover',load_mega_menu_posts);
		}
		/*--------------- END- AJAX Load Mega menu posts ------------------*/
	
	}
	
	function replaceHyphensWithUnderscores(str) {
		return str.replace(/data-/g, '').replace(/-/g, '_');
	}

	/* Function to get all attributes with a specific prefix from an element */
	var getAttributesWithPrefix = function (element, prefix, page_no) {
		var attributesArray = [];
		var data = {
			'action' : 'load_posts_by_ajax',
			'security': clinicmaster_js_data.ajax_security_nonce,
			'page': page_no,
		};
		
		jQuery(element).each(function () {
			/* Iterate through all attributes of the element */
			jQuery.each(this.attributes, function (index, attribute) {
				/* Check if the attribute name starts with the specified prefix */
				if (attribute.name.startsWith(prefix)) {
					// Convert hyphens to underscores in attribute name
					var attributeName = replaceHyphensWithUnderscores(attribute.name);
					
					if(attribute.value.length > 0){
						Object.assign(data, {[attributeName]:attribute.value});
					}
				}
				
			});
			
		});
		return data;
	}
	
	var handleLoadMore = function (){
		/*--STARTS- AJAX Load more posts for Blog Listing King Elements --*/
		function load_more_posts() {
		  
		  
			jQuery("a.dz-load-more").on('click', function()
			{				
			
			
				jQuery(this).addClass('active');
				jQuery(this).addClass('disabled');
				jQuery('.dz-load i').addClass('dz-spinner');
				var ajax_container = jQuery(this).data('ajax-container');
				var max_num_pages = parseInt(jQuery(this).data('max-num-pages'));
				var loadMoreBtnId = jQuery(this).attr('id');
				var loadMoreBtnId = jQuery(this).attr('id');
				var post_type = jQuery(this).data('post-type');
				var blog_view = jQuery(this).data('blog-view');		
				var posts_per_page = parseInt(jQuery(this).data('posts-per-page'));		
				var posts_image_preference = jQuery(this).data('image-preference');		
				var post_by_label = jQuery(this).data('post-by-label');		
				var post_order = jQuery(this).data('post-order');		
				var post_order_by = jQuery(this).data('post-order-by');		
				var posts_in_categories = jQuery(this).data('posts-in-categories');
				var side_bar = jQuery(this).data('side-bar');
				var title_text_limit = jQuery(this).data('title-text-limit');
				var description_text_limit = jQuery(this).data('description-text-limit');				
				var show_date = jQuery(this).data('show-date');
				var show_author = jQuery(this).data('show-author');
				var show_comment = jQuery(this).data('show-comment');
				var element_style = jQuery(this).data('element-style');
				var show_share = jQuery(this).data('show-share');
				var show_column = jQuery(this).data('show-column');
				var hide_category = jQuery(this).data('hide-category');
				var read_more = jQuery(this).data('read-more-permalink');
				var desination_on = jQuery(this).data('desination-on');
				var social_on = jQuery(this).data('social-on');
				var team_detail = jQuery(this).data('team-detail');
				var theme_color = jQuery(this).data('theme-color');
				var appointment_text = jQuery(this).data('appointment-text');
				var appointment_link = jQuery(this).data('appointment-link');
				var listing_bg_img = jQuery(this).data('listing-bg-img');
				

				var data = {
						'action': 'load_posts_by_ajax',
						'page': page_no,
						'post_type': post_type,
						'blog_view': blog_view,
						'posts_per_page': posts_per_page,
						'max_num_pages': max_num_pages,					
						'posts_in_categories': posts_in_categories,
						'posts_image_preference' : posts_image_preference,
						'post_by_label' : post_by_label,
						'post_order' : post_order,
						'post_order_by' : post_order_by,
						'side_bar' : side_bar,
						'title_text_limit' : title_text_limit,
						'description_text_limit' : description_text_limit,						
						'show_date' : show_date,
						'show_author' : show_author,
						'show_comment' : show_comment,
						'show_share' : show_share,
						'show_column' : show_column,
						'element_style' : element_style,
						'hide_category' : hide_category,					
						'read_more' : read_more,					
						'desination_on' : desination_on,					
						'social_on' : social_on,					
						'team_detail' : team_detail,					
						'theme_color' : theme_color,					
						'appointment_text' : appointment_text,					
						'appointment_link' : appointment_link,					
						'listing_bg_img' : listing_bg_img,					
						'security': clinicmaster_js_data.ajax_security_nonce,
				}; 
		  		/* var dataAttributes = getAttributesWithPrefix(jQuery(this), 'data',page_no);			
				var jsonString = JSON.parse(JSON.stringify(dataAttributes)); */
				
				var remove_loadmore_button = false;
				
				jQuery.ajax({
					method: 'POST',
					url: clinicmaster_js_data.admin_ajax_url,
					type: 'JSON',
					data: data,
					beforeSend : function ( xhr ) {
					},
					success:function(response){
						jQuery('.dz-load i').removeClass('dz-spinner');
						jQuery(this).removeClass('disabled');
						if( response ) { 			
							var content = jQuery( response );					
							
							if(jQuery('#'+ajax_container).hasClass("masonry")){
								jQuery('#'+ajax_container).append(content).masonry( 'appended', content );
								
								masonryBoxFilter();
								
							}
							jQuery('#'+ajax_container).append(content);
							jQuery('#'+ajax_container+' div.hide-items').show('slow').removeClass(' hide-items ');
							
							setTimeout(function(){
								
							/* Temporary Code */
							isotopFilter();	
								
							}, 1000);
							
							if(page_no < max_num_pages)	{						
								page_no++;
							}
							else{
								remove_loadmore_button = true; 
							}
						}
						else {
							remove_loadmore_button = true;
						}
					},
					error : function(response){
						alert('Error in your ajax, plz check thirdparty plugins file for correct file path');
					},
					fail : function(response){				
						alert('Error in your ajax, plz check thirdparty plugins file for correct file path');				
					},
					complete : function(){
						jQuery("#"+loadMoreBtnId).removeClass('active');
						if(remove_loadmore_button){
							jQuery("#"+loadMoreBtnId).html('No More Post Available').addClass('disabled');
						}
					}			
				}); 
				return false;
			});
		} 
		
		if(jQuery("a.dz-load-more").length > 0){		
			load_more_posts();
			
			var page_no = 2;		
		}	
	}
	
	var handleCommonPageLoadMore = function (){
		
		/*---------------	STARTS- AJAX Load for 
						Author, Archive, Category, Search, Tag pages posts ---------------*/
		function load_common_page_posts_ajax() {		
			var max_num_pages = parseInt(jQuery('a.common-page-dz-load-more').data('max-num-pages'));
			var posts_per_page = parseInt(jQuery('a.common-page-dz-load-more').data('posts-per-page'));
			var common_page_type = jQuery('a.common-page-dz-load-more').data('common-page-type');
			var post_order = jQuery('a.common-page-dz-load-more').data('order');		
			var post_order_by = jQuery('a.common-page-dz-load-more').data('orderby');
			var data = {
					'action': 'load_common_page_posts_ajax',
					'page': page_no,
					'page_view': jQuery('a.common-page-dz-load-more').data('common-page-view'),
					'posts_per_page': posts_per_page,		
					'orderby': post_order_by,					
					'order': post_order,		
					'security': clinicmaster_js_data.ajax_security_nonce
				};	
			var remove_loadmore_button = false;	
			
			if( (typeof( jQuery('a.common-page-dz-load-more').data('object-data') ) != undefined) ){
				var object_data = jQuery('a.common-page-dz-load-more').data('object-data');
				jQuery.extend( data, {'object_data': object_data} );
			}
			
			jQuery.ajax({
				method: 'POST',
				url: clinicmaster_js_data.admin_ajax_url,
				type: 'JSON',
				data: data,
				beforeSend : function ( xhr ) {
					jQuery("a.common-page-dz-load-more").html('Load More <i class="fa fa-refresh fas fa-spinner fa-spin"></i>');
				},
				success:function(response){                
					if( response ) { 
						var content = jQuery( response );					
						
						if(jQuery('#masonry').length > 0 || jQuery('.masonry').length > 0){
							setTimeout(function() {
								jQuery('div.loadmore-content').append(content).masonry( 'appended', content );
							}, 500);	
						}else{
							jQuery('div.loadmore-content').append(content);
							jQuery('div.loadmore-content div.hide-items').show('slow').removeClass(' hide-items ');
						}
						
						setTimeout(function(){
							 header_blog_swiper();
							 MagnificPopup();
						}, 800);

						if(page_no < max_num_pages)	{						
							page_no++;							
							setTimeout(function() {
								jQuery("a.common-page-dz-load-more").text('Load More');
							}, 550);
						}
						else{
							remove_loadmore_button = true;							
						}
					}else {
						remove_loadmore_button = true;						
					}
				},
				complete : function(){
					jQuery("a.common-page-dz-load-more").removeClass('active');
					if(remove_loadmore_button){
						jQuery("a.common-page-dz-load-more").html('No More Post Available').addClass('disabled');
					}
				}							
			}); 
		} 	
		
		if(jQuery("a.common-page-dz-load-more").length > 0){ 	
			var page_no = 2;		
			jQuery("a.common-page-dz-load-more").off('click',load_common_page_posts_ajax);
			jQuery("a.common-page-dz-load-more").on('click',load_common_page_posts_ajax);
		}		
	}
	
	var handleIndexPageLoadMore = function (){
		
		/*--------------- STARTS- AJAX Load Latest posts on index page------------------*/
		function load_latest_posts_ajax() {		
			var max_num_pages = parseInt(jQuery('a.latest-post-dz-load-more').data('max-num-pages'));
			var posts_per_page = parseInt(jQuery('a.latest-post-dz-load-more').data('posts-per-page'));		
			var data = {
					'action': 'load_latest_posts_ajax',
					'page': page_no,				
					'posts_per_page': posts_per_page,					
					'security': clinicmaster_js_data.ajax_security_nonce
				};	
			var remove_loadmore_button = false;
			
			jQuery.ajax({
				method: 'POST',
				url: clinicmaster_js_data.admin_ajax_url,
				type: 'JSON',
				data: data,
				beforeSend : function ( xhr ) {
					jQuery("a.latest-post-dz-load-more").html('Load More <i class="fa fa-refresh fas fa-spinner fa-spin"></i>');
				},
				success:function(response){                
					if( response ) { 
					
						var content = jQuery( response );					
						
						if(jQuery('#masonry').length > 0){
							setTimeout(function() {
								jQuery('div.loadmore-content').append(content).masonry( 'appended', content );
							}, 500);	
						}
						else{
							jQuery('div.loadmore-content').append(content);
							jQuery('div.loadmore-content div.hide-items').show('slow').removeClass(' hide-items ');
						}
						
						setTimeout(function(){
							MagnificPopup();
						}, 800);
						
						if(page_no < max_num_pages)	{						
							page_no++;
							
							setTimeout(function() {
								jQuery("a.latest-post-dz-load-more").text('Load More');
							}, 550);
						}
						else{
							remove_loadmore_button = true;							
						}
					}
					else {
						remove_loadmore_button = true;						
					}
				},
				
				complete : function(){
					jQuery("a.latest-post-dz-load-more").removeClass('active');
					if(remove_loadmore_button){
						jQuery("a.latest-post-dz-load-more").html('No More Post Available').addClass('disabled');
					}
				}					
			}); 
		} 
		
		if(jQuery("a.latest-post-dz-load-more").length > 0){ 	
			var page_no = 2;		
			jQuery("a.latest-post-dz-load-more").off('click',load_latest_posts_ajax);
			jQuery("a.latest-post-dz-load-more").on('click',load_latest_posts_ajax);
		}		
	}
	
	
	
	/* Magnific Popup ============ */
	var MagnificPopup = function(){
		'use strict';
		if(jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps').length > 0)
		{	
			/* magnificPopup for Play video function end */
			$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
				disableOn: 700,
				type: 'iframe',
				mainClass: 'mfp-fade',
				removalDelay: 160,
				preloader: false,
				fixedContentPos: false
			});		
		}		
	}
	
	var header_blog_carousel = function(){
		
		/* image-carousel function by = owl.carousel.js */
		jQuery('.header-blog-carousel').owlCarousel({
			loop:true,
			margin:20,
			autoplaySpeed: 3000,
			navSpeed: 3000,
			paginationSpeed: 3000,
			slideSpeed: 3000,
			smartSpeed: 3000,
			autoplay: 3000,
			nav:true,
			dots: false,
			rtl: (rtl_on == 'Yes')?true:false,
			navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
			responsive:{
				0:{
					items:1,
					margin:10,
					center: true,
					stagePadding: 30
				},
				480:{
					items:1,
					margin:10,
					center: true,
					stagePadding: 30
				},			
				1024:{
					items:3
				},
				1200:{
					items:4
				},
				1400:{
					items:4
				}
			}
		});
	}
	
	var handleSubscription = function(){
		/* Subscription Element */
		jQuery(".dz-subscription").on('submit',function(e){
			e.preventDefault(); 
			var formSelector = jQuery(this);
			var data = jQuery(this).serializeArray();
			data.push({ name: "action", value: "dz_mailchimp" });
			//formSelector.find('.dz-loading').addClass('disabled');
			jQuery('.dz-subscription').addClass('dz-ajax-overlay');
			jQuery.ajax({
				type : "post",
				url : clinicmaster_js_data.admin_ajax_url,
				data : data,
				success: function(response) {
					formSelector[0].reset();
					jQuery('.dz-subscription-msg').show('slow').html(response);
					//formSelector.find('.dz-loading').removeClass('disabled');
					jQuery('.dz-subscription').removeClass('dz-ajax-overlay');
					setTimeout(function(){
						jQuery('.dz-subscription-msg').hide('slow');
					}, 5000);
				}
			})   
		});
		/* Subscription Element END */
	}
	/* Function ============ */
  
	
	
	/* Countdown ============ */
	var handleCountDown = function(){
		/* Time Countr Down Js */
		if($(".countdown").length){			
			var launchDate = jQuery('.countdown').data('date');			
			if(launchDate != undefined && launchDate != ''){
				WebsiteLaunchDate = launchDate;
			}			
			$('.countdown').countdown({date: WebsiteLaunchDate+' 23:5'}, function() {
				jQuery.ajax({
					type: 'POST',
					url: clinicmaster_js_data.admin_ajax_url,
					data: "action=change_theme_status_ajax&security="+clinicmaster_js_data.ajax_security_nonce,
					success: function(data) {
						location.reload();
					}
				});
			});
		}
		/* Time Countr Down Js End */
	}

	var handleFinalCountDown = function(){
	
		if(jQuery('#countdown-timer').length > 0 ){
			var launchDate = jQuery("#countdown-timer").attr("data-endtime");

			if(launchDate != undefined && launchDate != ''){
				WebsiteLaunchDate = launchDate;
			}
			
			var endTime = new Date(WebsiteLaunchDate);
			endTime = Date.parse(endTime) / 1000;

			  var now = new Date();
			  now = Date.parse(now) / 1000;

			  var timeLeft = endTime - now;

			  var days = Math.floor(timeLeft / 86400);
			  var hours = Math.floor((timeLeft - days * 86400) / 3600);
			  var minutes = Math.floor((timeLeft - days * 86400 - hours * 3600) / 60);
			  var seconds = Math.floor(
			    timeLeft - days * 86400 - hours * 3600 - minutes * 60
			  );

			  

			  if (days < 10) {
			    days = "0" + days;
			  }else if (days < 1) {
			    days = 0;
			  }

			  if (hours < 10) {
			    hours = "0" + hours;
			  }else if (hours < 1) {
			    hours = "0";
			  }

			  if (minutes < 10) {
			    minutes = "0" + minutes;
			  }else if (minutes < 1) {
			    minutes = "0";
			  }

			  if (seconds < 10) {
			    seconds = "0" + seconds;
			  }else if (seconds < 1) {
			    seconds = "0";
			  }

			  $("#countdown-timer").html(
			    "<span id='days'>" +
			    days +
			    "<span>Days</span></span>" +
			    "<span id='hours'>" +
			    hours +
			    "<span>Hrs</span></span>" +
			    "<span id='minutes'>" +
			    minutes +
			    "<span>Mins</span></span>" +
			    "<span id='seconds'>" +
			    seconds +
			    "<span>Secs</span></span>"
			  );

		}
	}
	
	/* Masonry Box ============ */
	var masonryBoxFilter = function(){
	
		if(jQuery("#isot, .masonry").length > 0){	
			var masonryContainer = jQuery("#isot, .masonry");			
			
			var $params = {
				itemSelector: ".card-container",
				filtersGroupSelector:".filters",
				selectorType: "list",
				resize: true
			};
			
				setTimeout(function(){
					/* Do masonry with filtering */ 
					masonryContainer.imagesLoaded(function(){
						masonryContainer.masonry($params);
					})	
				}, 500);
				
			
			setTimeout(function(){
				jQuery(".filters li").removeClass('active');
				jQuery(".filters li:first").addClass('active');
			}, 800);			
		}
	}

		/* Isotop Box ============ */
	var isotopFilter = function(){
		if(jQuery('#Isotope, .Isotope').length > 0){
			var selfI = jQuery('#Isotope, .Isotope');

			var layoutMode = (selfI.attr('data-layoutMode') === undefined)?'fitRows':selfI.attr('data-layoutMode');
			var percentPosition = (selfI.attr('data-percentPosition') === undefined)?false:true;	
			
			jQuery('#Isotope, .Isotope').isotope( 'reloadItems' ).isotope({
				/* options */
				itemSelector: '.card-container',
				layoutMode: layoutMode,
				percentPosition: percentPosition,
			});
		}
	}
	
	var setCookie = function(cname, cvalue, exhours) {
		var d = new Date();
		d.setTime(d.getTime() + (exhours*60*60*1000)); /* exhours=30 means 30 Hours*/
		var expires = "expires="+ d.toString();
		var sameSite = 'SameSite=strict;';
		document.cookie = cname + "=" + cvalue + ";" + expires + ";" + sameSite + "path=/";
		
	}

	var getCookie = function(cname) {
		var name = cname + "=";
		var decodedCookie = decodeURIComponent(document.cookie);
		var ca = decodedCookie.split(';');
		for(var i = 0; i <ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') {
				c = c.substring(1);
			}
			if (c.indexOf(name) == 0) {
				return c.substring(name.length, c.length);
			}
		}
		return "";
	}

	var deleteCookie = function(cname) {
		var d = new Date();
		d.setTime(d.getTime() + (1)); /* 1/1000 second*/
		var expires = "expires="+ d.toString();
		document.cookie = cname + "=1;" + expires + ";path=/";
	}
	
	
	var handleOpenModal = function(){
		var close_interval = jQuery('#NewsletterPopup').data('close_interval');
		var subscription_interval = jQuery('#NewsletterPopup').data('subscription_interval');
		jQuery('.btn-close').on('click',function() {
			setCookie('newsletter_pop_up_hide','Yes',close_interval);
		});
		
		
		jQuery('#basic_checkbox_3').on('click',function() {
			if(jQuery(this).is(":checked")){
				jQuery("#NewsletterBtn").removeClass("disabled");
				jQuery("#basic_checkbox_3").val("on");
			}else{
				jQuery("#NewsletterBtn").addClass("disabled");
				jQuery("#basic_checkbox_3").val("off");
				
			}	
		});
		jQuery(".newsletter-subscribe").on('submit',function(e){
			e.preventDefault();
			var this_val = jQuery('#basic_checkbox_3').val();
			if(this_val == 'on'){
				var formSelector = jQuery(this);
				var data = jQuery(this).serializeArray();
				data.push({ name: "action", value: "dz_mailchimp" });
				formSelector.find('.dz-loading').removeClass('d-none').addClass('active');
				jQuery('.newsletter-subscribe').addClass('dz-ajax-overlay');
				jQuery.ajax({
					type : "post",
					url : clinicmaster_js_data.admin_ajax_url,
					data : data,
					success: function(response) {
						formSelector[0].reset();
						jQuery('.dz-subscription-msg').show('slow').html(response);
						formSelector.find('.dz-loading').addClass('d-none').removeClass('active');
						jQuery('.newsletter-subscribe').removeClass('dz-ajax-overlay');					
						setCookie('newsletter_pop_up_successfully ','Yes',subscription_interval);
						setTimeout(function(){
							jQuery("#NewsletterPopup").modal('hide');
							jQuery('.dz-subscription-msg').hide('slow');
						}, 5000);
					}
				})
			}else{
				jQuery('.dz-subscription-msg').html('<div class="alert alert-warning alert-dismissible fade show" role="alert">I agree to receive marketing materials</div>');
			}
		});
		if(getCookie('newsletter_pop_up_hide') !='Yes' && getCookie('newsletter_pop_up_successfully') !='Yes'){
			setTimeout(function() {
				jQuery("#NewsletterPopup").modal('show');
			}, 5000)
		}else{
			jQuery("#NewsletterPopup").modal('hide');
		}

	}
	
	
	
	/* Function ============ */
	
	return {
		init:function(){
			handleMegaMenu();
			handleLoadMore();
			handleCommonPageLoadMore();
			handleIndexPageLoadMore();
			handleSubscription();
			masonryBoxFilter();
			//handleOpenModal();
			setInterval(function() {
			  handleFinalCountDown();
			}, 1000);
			
		},				
		load:function(){
			themeWorkOnMobile();
			setTimeout(function() {
				handleOpenModal();
			}, 3000);
			
		},		
		resize:function(){
			screenWidth = $(window).width();
			themeWorkOnMobile();
		},		
	}
}();

/* Document.ready Start */	
jQuery(document).ready(function() {
    'use strict';
	
	DZWPScript.init();	
});
/* Document.ready END */


/* Window Resize START */
jQuery(window).on('load',function () {
	'use strict'; 
	DZWPScript.load();
		
	//Select all form elements with the specific class used by Contact Form 7
	document.querySelectorAll('.dzForm p').forEach(function(wrapper) {
		// Find label and input within each wrapper
	
		const span = wrapper.querySelector('span');
		const label = wrapper.querySelector('label');
		const input = wrapper.querySelector('input, textarea, select');
		
		if (label && input) {
			// Move the label after the input field
			span.appendChild(label);
		}
	});
	
});
/*  Window Resize END */

/* Window Resize START */
jQuery(window).on('resize',function () {
	'use strict'; 
	DZWPScript.resize();
});
/*  Window Resize END */

/* messages send by ajax */
})(jQuery);	