var ClinicMaster;
(function($) {	
	"use strict";

/**
/**
Core script to handle the entire theme and core functions
**/
ClinicMaster = function(){
	/* Search Bar ============ */
	var siteUrl = '';
	
	var screenWidth = jQuery( window ).width();


	/* Website Launch Date */ 
	var WebsiteLaunchDate = new Date();
	var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	WebsiteLaunchDate.setMonth(WebsiteLaunchDate.getMonth() + 1);
	WebsiteLaunchDate =  WebsiteLaunchDate.getDate() + " " + monthNames[WebsiteLaunchDate.getMonth()] + " " + WebsiteLaunchDate.getFullYear();
	/* Website Launch Date END */ 
	
	var homeSearch = function() {
		'use strict';
		/* top search in header on click function */
		var quikSearch = jQuery("#quik-search-btn");
		var quikSearchRemove = jQuery("#quik-search-remove");
		
		quikSearch.on('click',function() {
			jQuery('.dz-quik-search').fadeIn(500);
			jQuery('.dz-quik-search').addClass('On');
		});
		
		quikSearchRemove.on('click',function() {
			jQuery('.dz-quik-search').fadeOut(500);
			jQuery('.dz-quik-search').removeClass('On');
		});	
		/* top search in header on click function End*/
	}
	
	/* WOW ANIMATION ============ */
	var wow_animation = function(){
		
		var wowElements = document.querySelectorAll('.wow');
		
		if (wowElements.length > 0) {
			var wow = new WOW({
				boxClass: 'wow',          // animated element css class (default is wow)
				animateClass: 'animated', // animation css class (default is animated)
				offset: 50,               // distance to the element when triggering the animation (default is 0)
				mobile: false             // trigger animations on mobile devices (true is default)
			});

			setTimeout(function () {
				wow.init();
			}, 1500);
		}
		
		
	}
	
	/* One Page Layout ============ */
	var onePageLayout = function() {
		'use strict';
		var headerHeight =   parseInt($('.onepage').css('height'), 10);
		
		jQuery(".scroll").unbind().on('click',function(event) 
		{
			event.preventDefault();
			
			if (this.hash !== "") {
				var hash = this.hash;	
				var seactionPosition = $(hash).offset().top;
				var headerHeight =   parseInt($('.onepage').css('height'), 10);
				
				
				$('body').scrollspy({target: ".navbar", offset: headerHeight+2}); 
				
				var scrollTopPosition = seactionPosition - (headerHeight);
				
				$('html, body').animate({
					scrollTop: scrollTopPosition
				}, 800, function(){
					
				});
			}   
		});
	}
	
	/* Header Height ============ */
	var handleResizeElement = function(){
		var headerTop = 0;
		var headerNav = 0;
		
		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');
		
		if(jQuery('.header .top-bar').length > 0 &&  screenWidth > 991)
		{
			headerTop = parseInt($('.header .top-bar').outerHeight());
		}

		if(jQuery('.header').length > 0 )
		{
			headerNav = parseInt($('.header').height());
			headerNav =	(headerNav == 0)?parseInt($('.header .main-bar').outerHeight()):headerNav;
		}	
		
		var headerHeight = headerNav + headerTop;
		
		jQuery('.header').css('height', headerHeight);
	}
	
	var handleResizeElementOnResize = function(){
		var headerTop = 0;
		var headerNav = 0;
		
		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');
		
		
		setTimeout(function(){
			
			if(jQuery('.header .top-bar').length > 0 &&  screenWidth > 991)
			{
				headerTop = parseInt($('.header .top-bar').outerHeight());
			}

			if(jQuery('.header').length > 0 )
			{
				headerNav = parseInt($('.header').height());
				headerNav =	(headerNav == 0)?parseInt($('.header .main-bar').outerHeight()):headerNav;
			}	
			
			var headerHeight = headerNav + headerTop;
			
			jQuery('.header').css('height', headerHeight);
		
		}, 500);
    }
	
	/* Load File ============ */
	/* var dzTheme = function(){
		'use strict';
		
		if(screenWidth <= 991 ){
			jQuery('.navbar-nav > li > a, .sub-menu > li > a').unbind().on('click', function(e){
				if(jQuery(this).parent('li').has('ul').length > 0){e.preventDefault();}
				if(jQuery(this).parent().hasClass('open'))
				{
					jQuery(this).parent().removeClass('open');
				}
				else{
					jQuery(this).parent().parent().find('li').removeClass('open');
					jQuery(this).parent().addClass('open');
				}
			});
		}
		
		jQuery('.menu-btn, .openbtn').on('click',function(){
			jQuery('.content-sidebar').addClass('active');
		});
		jQuery('.menu-close').on('click',function(){
			jQuery('.content-sidebar').removeClass('active');
			jQuery('.menu-btn').removeClass('open');
		});
		
		jQuery('.dz-carticon').on('click',function(){
			jQuery(this).toggleClass('active');
		});
		jQuery('.dz-wishicon').on('click',function(){
			jQuery(this).toggleClass('active');
		});
	} */
		var dzTheme = function () {
		if (screenWidth <= 991) {
			var menuObj;
			if (jQuery('#W3Menu').length > 0) {
				jQuery('.menu-close').addClass('fade-overlay');
			}
			jQuery('.navbar-nav > li > a, .sub-menu > li > a, .navbar-nav > li > a > i, .sub-menu > li > a > i')
				.unbind()
				.on({
					click: function (e) {
						menuObj = jQuery(this);
						handleMenus(e, menuObj);
					},
					keypress: function (e) {
						if (e.key !== 'Enter') {
							return false;
						}
						menuObj = jQuery(this);
						handleMenus(e, menuObj);
					},
				});
			jQuery('.tabindex').attr("tabindex", "0");

			function handleMenus(e, menuObj) {
				if (menuObj.parent('li').has('ul').length > 0) {
					e.preventDefault();
	
					menuObj.next('.sub-menu, .mega-menu').slideDown();
					menuObj.parent('li').siblings('li').children('.sub-menu, .mega-menu').slideUp();
				}
				if (menuObj.parent().hasClass('open')) {
					menuObj.parent('li').children('.sub-menu, .mega-menu').slideUp('slow', function(){
						menuObj.parent().removeClass('open');
					});
				} else {
					if (menuObj.hasClass('sub-menu')) {
						menuObj.parent().addClass('open');
					} else {
						menuObj.parent().parent().find('li').removeClass('open');
						menuObj.parent().addClass('open');
					}
				}
			}
			
			
		} else {
			if(jQuery('.fade-overlay').length > 0){
				jQuery('.menu-close').removeClass('fade-overlay');
				jQuery('body').removeClass('fixed');
			}
			jQuery('.tabindex').removeAttr("tabindex");
		}
	}
	
	
	
	/* lightGallery */
	var handleLightgallery = function() {
		if(jQuery('.lightgallery').length > 0){
			lightGallery(document.querySelector('.lightgallery'), {
				plugins: [lgThumbnail, lgZoom],
				selector: '.lightimg',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
		if(jQuery('#lightgallery').length > 0){
			lightGallery(document.getElementById('lightgallery'), {
				plugins: [lgThumbnail, lgZoom],
				selector: '.lg-item',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
		if(jQuery('#lightgallery2').length > 0){
			lightGallery(document.getElementById('lightgallery2'), {
				plugins: [lgThumbnail, lgZoom],
				selector: '.lg-item',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
		if(jQuery('#lightgallery3').length > 0){
			lightGallery(document.getElementById('lightgallery3'),{
				plugins: [lgThumbnail, lgZoom],
				selector: '.lg-item',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
		if(jQuery('#lightgallery4').length > 0){
			lightGallery(document.getElementById('lightgallery4'),{
				plugins: [lgThumbnail, lgZoom],
				selector: '.lg-item',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
		if(jQuery('#lightgallery5').length > 0){
			lightGallery(document.getElementById('lightgallery5'),{
				plugins: [lgThumbnail, lgZoom],
				selector: '.lg-item',
				thumbnail:true,
				exThumbImage: 'data-src'
            });
		}
	}
	
	/* Magnific Popup ============ */
	var MagnificPopup = function(){
		'use strict';	
		
		if(jQuery('.mfp-gallery').length > 0)
		{
			/* magnificPopup function */
			jQuery('.mfp-gallery').magnificPopup({
				delegate: '.mfp-link',
				type: 'image',
				tLoading: 'Loading image #%curr%...',
				mainClass: 'mfp-img-mobile',
				gallery: {
					enabled: true,
					navigateByImgClick: true,
					preload: [0,1] /*  Will preload 0 - before current, and 1 after the current image */
				},
				image: {
					tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
					titleSrc: function(item) {
						return item.el.attr('title') + '<small></small>';
					}
				}
			});
			/* magnificPopup function end */
		}
		
		if(jQuery('.mfp-video').length > 0)
		{
			/* magnificPopup for Play video function */		
			jQuery('.mfp-video').magnificPopup({
				type: 'iframe',
				iframe: {
					markup: '<div class="mfp-iframe-scaler">'+
							 '<div class="mfp-close"></div>'+
							 '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
							 '<div class="mfp-title">Some caption</div>'+
							 '</div>'
				},
				callbacks: {
					markupParse: function(template, values, item) {
						values.title = item.el.attr('title');
					}
				}
			});
			
		}

		if(jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps').length > 0)
		{	
			/* magnificPopup for Play video function end */
			$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
				disableOn: 700,
				type: 'iframe',
				mainClass: 'mfp-fade',
				removalDelay: 160,
				preloader: false,

				fixedContentPos: true
			});
		
		}
		
	}
	
	/* Scroll To Top ============ */
	var scrollTop = function (){
		'use strict';
		var scrollTop = jQuery("button.scroltop");
		/* page scroll top on click function */	
		scrollTop.on('click',function() {
			jQuery("html, body").animate({
				scrollTop: 0
			}, 1000);
			return false;
		})

		jQuery(window).bind("scroll", function() {
			var scroll = jQuery(window).scrollTop();
			if (scroll > 900) {
				jQuery("button.scroltop").fadeIn(1000);
			} else {
				jQuery("button.scroltop").fadeOut(1000);
			}
		});
		/* page scroll top on click function end*/
	}
	
	/* Header Fixed ============ */
	var headerFix = function(){
		'use strict';
		/* Main navigation fixed on top  when scroll down function custom */		
		jQuery(window).on('scroll', function () {
			if(jQuery('.sticky-header').length > 0){
				var menu = jQuery('.sticky-header');
				if ($(window).scrollTop() > menu.offset().top) {
					menu.addClass('is-fixed');
				} else {
					menu.removeClass('is-fixed');
				}
			}
		});
		/* Main navigation fixed on top  when scroll down function custom end*/
	}
	
	/* Masonry Box ============ */
	var masonryBox = function () {
		if (jQuery('#masonry, .masonry').length > 0) {
			jQuery('.filters li').removeClass('active');
			jQuery('.filters li:first').addClass('active');
			var self = jQuery("#masonry, .masonry");
			var filterValue = "";

			if (jQuery('.card-container').length > 0) {
				var gutterEnable = self.data('gutter');

				var gutter = (self.data('gutter') === undefined) ? 0 : self.data('gutter');
				gutter = parseInt(gutter);


				var columnWidthValue = (self.attr('data-column-width') === undefined) ? '' : self.attr('data-column-width');
				if (columnWidthValue != '') { columnWidthValue = parseInt(columnWidthValue); }

				self.imagesLoaded(function () {
					filter: filterValue,
						self.masonry({
							gutter: gutter,
							columnWidth: columnWidthValue,
							//columnWidth:3, 
							//gutterWidth: 15,
							isAnimated: true,
							itemSelector: ".card-container",
							//gutterWidth: 15,
							//horizontalOrder: true,
							//fitWidth: true,
							//stagger: 30
							//containerStyle: null
							//percentPosition: true
						});

				});
			}
		}

		if (jQuery('.filters').length > 0) {
			jQuery(".filters li:first").addClass('active');
			jQuery(".filters li").on('click', function () {
				jQuery('.filters li').removeClass('active');
				jQuery(this).addClass('active');

				var filterValue = $(this).attr("data-filter");
				self.isotope({
					filter: filterValue,
				});
			});
		}
	}

	var handleIsotope = function () {
		if (jQuery('#Isotope, .isotope').length > 0) {
			var self = jQuery('#Isotope, .isotope');
			self.isotope({
				itemSelector: '.card-container',
				layoutMode: 'fitRows',
			})
		}

		if (jQuery('.filter-isotope').length > 0) {
			jQuery(".filter-isotope li:first").addClass('active');
			jQuery(".filter-isotope li").on('click', function (){
				jQuery('.filter-isotope li').removeClass('active');
				jQuery(this).addClass('active');

				var filterValue = $(this).attr("data-filter");

				self.isotope({
					filter: filterValue,
				});
			});
		}
	}
	
	
	/* Counter Number ============ */
	var counter = function(){
		if(jQuery('.counter').length)
		{
			jQuery('.counter').counterUp({
				delay: 10,
				time: 3000
			});	
		}
	}
	
	/* Video Popup ============ */
	var handleVideo = function(){
		/* Video responsive function */	
		jQuery('iframe[src*="youtube.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
		jQuery('iframe[src*="vimeo.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');	
		/* Video responsive function end */
	}
	



	/* Gallery Filter ============ */
	var handleFilterMasonary = function(){
		/* gallery filter activation = jquery.mixitup.min.js */ 
		if (jQuery('#image-gallery-mix').length) {
			jQuery('.gallery-filter').find('li').each(function () {
				$(this).addClass('filter');
			});
			jQuery('#image-gallery-mix').mixItUp();
		};
		if(jQuery('.gallery-filter.masonary').length){
			jQuery('.gallery-filter.masonary').on('click','span', function(){
				var selector = $(this).parent().attr('data-filter');
				jQuery('.gallery-filter.masonary span').parent().removeClass('active');
				jQuery(this).parent().addClass('active');
				jQuery('#image-gallery-isotope').isotope({ filter: selector });
				return false;
			});
		}
		/* gallery filter activation = jquery.mixitup.min.js */
	}


	



	
	/* Resizebanner ============ */
	var handleBannerResize = function(){
		$(".full-height").css("height", $(window).height());
	}
	
	/* BGEFFECT ============ */
	var reposition = function (){
		'use strict';
		var modal = jQuery(this),
		dialog = modal.find('.modal-dialog');
		modal.css('display', 'block');
		
		/* Dividing by two centers the modal exactly, but dividing by three 
		 or four works better for larger screens.  */
		dialog.css("margin-top", Math.max(0, (jQuery(window).height() - dialog.height()) / 2));
	}
	
	var handelResize = function (){
		/* Reposition when the window is resized */
		jQuery(window).on('resize', function() {
			jQuery('.modal:visible').each(reposition);
			
		});
	}
	
	
	/* Countdown ============ */
	var handleCountDown = function(CounterSetDate){
		/* Time Countr Down Js */
		if(jQuery(".countdown").length)
		{	
			var launchDate = jQuery('.countdown').data('date');	
			if(launchDate != undefined && launchDate != '')
			{
				var datetime = new Date();
				datetime.setMonth(datetime.getMonth());
				datetime =  datetime.getDate() + " " + monthNames[datetime.getMonth()] + " " + datetime.getFullYear();
				CounterSetDate = datetime;
				
			}
			jQuery('.countdown').countdown({date: CounterSetDate+' 23:5'}, function() {
				jQuery('.countdown').text('we are live');
			});  
		}
		/* Time Countr Down Js End */
	}
	
	/* Countdown Timer ============ */
	var handleFinalCountDown = function(){
		var launchDate = jQuery('.countdown-timer').data('date');
		
		if(launchDate != undefined && launchDate != '')
		{
			WebsiteLaunchDate = launchDate;
		}

		if(jQuery('.countdown-timer').length > 0 )
		{
			var startTime = new Date(); // Put your website start time here
			startTime = startTime.getTime();
			
			var currentTime = new Date();
			currentTime = currentTime.getTime();
			
			var endTime = new Date(WebsiteLaunchDate); // Put your website end time here			
			endTime = endTime.getTime();		
			
			jQuery('.countdown-timer').final_countdown({
				
				'start': (startTime/1000),
				'end': (endTime/1000), 
				'now': (currentTime/1000), 
				selectors: {
					value_seconds:'.clock-seconds .val',
					canvas_seconds:'canvas-seconds',
					value_minutes:'.clock-minutes .val',
					canvas_minutes:'canvas-minutes',
					value_hours:'.clock-hours .val',
					canvas_hours:'canvas-hours',
					value_days:'.clock-days .val',
					canvas_days:'canvas-days'
				},
				seconds: {
					borderColor:$('.type-seconds').attr('data-border-color'),
					borderWidth:'5',
				},
				minutes: {
					borderColor:$('.type-minutes').attr('data-border-color'),
					borderWidth:'5'
				},
				hours: {
					borderColor:$('.type-hours').attr('data-border-color'),
					borderWidth:'5'
				},
				days: {
					borderColor:$('.type-days').attr('data-border-color'),
					borderWidth:'5'
				}
			}, function() {
				jQuery.ajax({
					type: 'POST',
					url: clinicmaster_js_data.admin_ajax_url,
					data: "action=change_theme_status_ajax&security="+clinicmaster_js_data.ajax_security_nonce,
					success: function(data) {
						location.reload();
					}
				});				
			});
		}
	}
		
	
	
	var boxHover = function(){
		jQuery('.box-hover').on('mouseenter',function(){
			var selector = jQuery(this).parent().parent();
			selector.find('.box-hover').removeClass('active');
			jQuery(this).addClass('active');
		});
	}
	
	var handleCurrentActive = function() {
		
	}
	
	/* Mini Cart Function*/
	var handleShopCart = function(){
		$(".remove").on('click',function(){
			$(this).closest(".mini_cart_item").hide('500');
		});
		$('.cart-btn').unbind().on('click',function(){
			$(".cart-list").slideToggle('slow');
		})
		
	} 
	
	/* Range ============ */
	var priceslider = function(){
		if($("#slider-tooltips").length > 0 ) {
			var tooltipSlider = document.getElementById('slider-tooltips');
			
			var formatForSlider = {
				from: function (formattedValue) {
					return Number(formattedValue);
				},
				to: function(numericValue) {
					return Math.round(numericValue);
				}
			};

			noUiSlider.create(tooltipSlider, {
				start: [40, 346],
				connect: true,
				format: formatForSlider,
				tooltips: [wNumb({decimals: 1}), true],
				range: {
					'min': 0,
					'max': 400
				}
			});
			var formatValues = [
				document.getElementById('slider-margin-value-min'),
				document.getElementById('slider-margin-value-max')
			];
			tooltipSlider.noUiSlider.on('update', function (values, handle, unencoded) {
				formatValues[0].innerHTML = "Min Price: " + "$"+ values[0];
				formatValues[1].innerHTML = "Max Price: " + "$"+ values[1];
			});
		}
	}
	
	/* handle Bootstrap Touch Spin ============ */
	var handleBootstrapTouchSpin = function(){
		if($("input[class='demo_vertical2']").length > 0 ) {
			jQuery("input[class='demo_vertical2']").TouchSpin({
			  verticalbuttons: true, 
			  verticalupclass: 'fa-solid fa-plus',
			  verticaldownclass: 'fa-solid fa-minus'
			});
		}
	 	if($(".quantity-input").length > 0 ) {
			jQuery(".quantity-input").TouchSpin({
			  verticalbuttons: true,
			  verticalupclass: 'fa-solid fa-plus',
			  verticaldownclass: 'fa-solid fa-minus'
			});
		}
	}
	
	var handleSmartWizard = function(){
		if(jQuery('#smartwizard').length > 0 ){
			$('#smartwizard').smartWizard(); 
		}
	}
	
	
	var handleSelectpicker = function(){
		if(jQuery('.default-select').length > 0 ){
			jQuery('.default-select').selectpicker();
		}
	}
	
	var dzCategoryToggle = function(){
		jQuery('.category-toggle .toggle-btn').on('click',function(){
			$(".toggle-items").slideToggle("slow");
			jQuery(this).toggleClass('active');
		});
		
		jQuery('.browse-category-menu .category-btn').on('click',function(){
			$(".category-menu-items").slideToggle("slow");
			jQuery(this).toggleClass('active');
		});
		
		/* accordion-button */
		
	}
	
	var heartBlast = function (){
		$(".heart").on("click", function() {
			$(this).toggleClass("heart-blast");
		});
	}
	
	
	var cartButton = function(){
		$(".dz-close").on('click',function(){
			$(this).closest(".sidebar-cart-list li").fadeOut("normal", function() {
				$(this).remove();
			});
		});
		
		$(".tag-close").on('click',function(){
			$(this).closest(".filter-tag li").fadeOut("normal", function() {
				$(this).remove();
			});
		});
	} 
	
	/* Header Menu Item Function*/
	var handleHeaderMenuItem = function(){
		$(".menu-item").on('click',function(){
			$(".dzdrop-menu").toggleClass('show');
		});
		$(".menu-items").on('click',function(){
			$(this).toggleClass('active');
		});
	}
	
	var handleColorFilter = function(){
		var colorsInput = document.querySelectorAll(".color-filter .form-check-input");
		colorsInput.forEach(colorChange)
		function colorChange(item, index, arr) {
			var color = $(item).val();
			var element = $(item).closest('.form-check').find('span');
			element.css({backgroundColor : color});
		}
	}
	
	var handleMultipleImageSize = function(){
		
		jQuery('.smart-product-details .dz-media img').removeAttr('style');
		setTimeout(function(){
			jQuery('.smart-product-details .dz-content').each(function(){
				var ch = Math.ceil(jQuery(this).outerHeight());
				jQuery(this).parent().find('.dz-media img').css('--static-height',ch+'px');	
			});
		}, 500);
		
		
	}





	var menuHover = function(){
		jQuery('.header-menu .nav > li').on('mouseenter',function(){
			jQuery('.header-menu .nav > li').removeClass('active');
			jQuery(this).addClass('active');
		})
		jQuery('.menu-nav-btn').on('click',function(){
			jQuery('.page-wraper').toggleClass('active-menu');
		})
	}
		
	
	
	
	/* Coming Soon Counter ============ */
	var handleComingSoonCounter = function(){
		
		var commingSoonDate = '';
		var countDownDate = '';
		var CounterSetDate = '';
		var x = [];
		var timeInterval = 1000;
		jQuery('.countdown').each(function(index){
			
			var currentCountDownSelector = jQuery(this);
			countDownDate = jQuery(this).data('date');		
			
			if(countDownDate != undefined && countDownDate != ''){
				CounterSetDate = countDownDate;
			}else{
				CounterSetDate = WebsiteLaunchDate;	
			}
			
			commingSoonDate = new Date(CounterSetDate).getTime();
			
			x[index] = setInterval(cc, timeInterval, index, commingSoonDate, currentCountDownSelector);
			
				
			timeInterval = timeInterval ;
			
		});	
		
		function cc(index, commingSoonDate, currentCountDownSelector){
				
				var currentTime = new Date().getTime();
				var clockTime = commingSoonDate - currentTime;
				
				/* var days = Math.floor(clockTime / (1000 * 60 * 60 * 24));
				var hours = Math.floor((clockTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
				var minutes = Math.floor((clockTime % (1000 * 60 * 60)) / (1000 * 60));
				var seconds = Math.floor((clockTime % (1000 * 60)) / 1000);

				var remainDays 		= (days.toString().length 		== 1) ? '0'+days	: days;
				var remainHour 		= (hours.toString().length 		== 1) ? '0'+hours	: hours;
				var remainMin 		= (minutes.toString().length 	== 1) ? '0'+minutes	: minutes;
				var remainSeconds 	= (seconds.toString().length 	== 1) ? '0'+seconds	: seconds;
				
				currentCountDownSelector.find('.w3-day').text(remainDays);
				currentCountDownSelector.find('.w3-hour').text(remainHour);
				currentCountDownSelector.find('.w3-min').text(remainMin);
				currentCountDownSelector.find('.w3-second').text(remainSeconds); */
			var days = Math.floor(clockTime / (1000 * 60 * 60 * 24));
			var hours = Math.floor((clockTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
			var minutes = Math.floor((clockTime % (1000 * 60 * 60)) / (1000 * 60));
			var seconds = Math.floor((clockTime % (1000 * 60)) / 1000);

			var remainDays = (days.toString().length == 1) ? '0' + days : days;
			var remainHour = (hours.toString().length == 1) ? '0' + hours : hours;
			var remainMin = (minutes.toString().length == 1) ? '0' + minutes : minutes;
			var remainSeconds = (seconds.toString().length == 1) ? '0' + seconds : seconds;

			jQuery('#day').text(remainDays);
			jQuery('#hour').text(remainHour);
			jQuery('#min').text(remainMin);
			jQuery('#second').text(remainSeconds);

			var rotateNum = 6 * seconds;

			$('.round').css({ 'transform': 'rotate(' + rotateNum + 'deg)' });
			$('.round').css({ '-webkit-transform': 'rotate(' + rotateNum + 'deg)' });
			$('.round').css({ '-o-transform': 'rotate(' + rotateNum + 'deg)' });
			$('.round').css({ '-moz-transform': 'rotate(' + rotateNum + 'deg)' });
			$('.round').css({ '-ms-transform': 'rotate(' + rotateNum + 'deg)' });
				
				var rotateNum = 6 * seconds;

				/* If count down over */
				if (clockTime < 0) {
					clearInterval(x[index]);
					jQuery("#day, #hour, #min, #second").html("EXPIRED");
					//currentCountDownSelector.find(".w3-day, .w3-hour, .w3-min, .w3-second").html('00');
				}
				
			}
		
		
		
		
	}
	
	
	var navScroller = function(){
		var previousScroll = 0;
		$(window).scroll(function(){
			if(screenWidth <= 768 ){
				if ($(this).scrollTop() + 
					$(this).innerHeight() >=  
					document.querySelector("body").scrollHeight) { 
					 $('.extra-nav').addClass('bottom-end');
				}else{
					 $('.extra-nav').removeClass('bottom-end');
				}
				var currentScroll = $(this).scrollTop();
				if (currentScroll > previousScroll){
					/* scroll down */
					$('.extra-nav').addClass('active');
				} else {
					/* scroll up */
					$('.extra-nav').removeClass('active');
				}
				previousScroll = currentScroll;
			}
			
		});
	}
	
	var handleMagnifyGallery = function(){
		
		const imageSelector = $('.DZoomImage');
		imageSelector.on('mousemove',function(t) {
			let e = $(this).offset();
			var i = (t.pageX - e.left) / $(this).width() * 100 <= 100 ? (t.pageX - e.left) / $(this).width() * 100 : 100;
			var c = (t.pageY - e.top) / $(this).height() * 100 <= 100 ? (t.pageY - e.top) / $(this).height() * 100 : 100;
			
			$(this).find('img').css("transform-origin", i + "% " + c + "%");
		})
		imageSelector.on('mouseenter',function(t) {
			let n = $(this).find('img');
			n.css("cursor", "pointer"), 
			n.css("transition", "0.1s"), 
			n.css("transform", "scale(" + 1.5 + ")"),
			$(this).find('.mfp-link i').css({opacity : 1,zIndex : 1})
		});
		imageSelector.on('mouseleave',function(t) {
			let n = $(this).find('img');
			n.css("transition", "0.1s"), n.css("transform", "scale(1)")
			$(this).find('.mfp-link i').css({opacity : 0,zIndex : 1})
		});
	}
	
	var handleMultiScroll = function(){
		if(jQuery('#myContainer').length > 0){		
			if ($(window).width() > 960) {
				$('#myContainer').multiscroll({
					licenseKey: 'YOUR KEY HERE',
					navigation: true,
					navigationTooltips: true,
					loopBottom: true,
					loopTop: true,
				});
			}
			$(window).on('resize', function(){	
				if ($(window).width() < 960) {
				
					$('#myContainer').multiscroll({
						licenseKey: 'YOUR KEY HERE',
						navigation: true,
						navigationTooltips: true,
						loopBottom: true,
						loopTop: true,
					});
				}
			});
		}
	}

	
	var  handleSearching = function(){		
		jQuery('.dz-search-input').on('input', function(e) {
			jQuery('.faq-head').addClass('active-search')
		});
		
		jQuery('.item-search, .faq-head').on('submit', function(e) {
			e.preventDefault()
		});
		
		jQuery('.dz-search-input').on('keyup', function(e) {
			var value = jQuery(this).val().toLowerCase();
				jQuery(".dz-search-item .accordion-item").filter(function(index, item) {
					jQuery(this).toggle(jQuery(this).text().toLowerCase().indexOf(value) > -1);
					
				});
			
			setTimeout(() => {
				jQuery(".faq-head").removeClass('active-search')
			}, 2000);
		});
		
		
	}

	var wcPriceUpdate = function(){
		jQuery('form.variations_form').on( 'found_variation.wc-variation-form',function(){
			setTimeout(function(){
				jQuery(document).find('.total .price').html(jQuery(document).find('.woocommerce-variation-price .price').html());	
			}, 2000);
		});
	}
	/* Mini Cart Function*/
	var handleShopPannel = function(){
		if (screenWidth >= 1199) {
			$("#shopFilter").addClass('filterTopBtnDe');
			$("#filterTopBtn").on('click', function() {
				$(".filterTopBtnDe").slideToggle("slow");
				
			});
		} else if (screenWidth <= 1197) {
			$("#shopFilter").removeClass('filterTopBtnDe');
			$(".panel-btn, .filter-top-btn").on('click', function() {
				$(".shop-filter, .panel-close-btn").addClass('active');
				setTimeout(function() {
					$("#shopFilter").removeAttr("style");
					
				}, 500);
			});
		}
		$('.panel-close-btn').on('click',function(){
			$(".shop-filter,.panel-close-btn").removeClass('active');
		})
		
		$(".btn-filter-left").on('click',function(){
			$(".shop-filter, .panel-close-btn").addClass('active');
		});
	}
	
	/* var handleProductFilter = function(){
		if(screenWidth < 1200){
			handleShopPannel();
			jQuery('.filter-top-btn').addClass(' ps-0 btn-filter-left');
			jQuery('.normal').removeClass(' d-none');
			jQuery('.vertical').removeClass(' d-none');
		}
		if(screenWidth >= 1200){
			jQuery('.filter-top-btn').removeClass(' ps-0 btn-filter-left');
			jQuery('.normal').addClass('  d-none');
			jQuery('.vertical').addClass('  d-none');
			
		}
	} */
	// For Map Scrolling
	
	var handleMapScroll = function () {
        // Check if the "Maping" section is in the viewport
		var mappingSection = jQuery('#Maping');
		if (mappingSection.length > 0) {
			var mapLine = jQuery('#map-line');
			var rect = mappingSection[0].getBoundingClientRect();

			if (rect.top >= 0 && rect.bottom <= $(window).height()) {
				var scrollPercentage = (rect.bottom - $(window).height()) / (rect.height - $(window).height()) * 100;
				scrollPercentage = Math.min(100, Math.max(0, scrollPercentage));

				var height = scrollPercentage.toFixed() + '%';
				mapLine.css('height', height);
			}
		}
	}

	
	var contactform = function () {
		jQuery('.menu-btn').on('click', function () {
			jQuery('body').append('<div class="menu-backdrop"></div>');
			jQuery('.menu-backdrop').on('click', function () {
				jQuery('.content-sidebar').removeClass('active');
				$(this).remove();
			})
		});
		jQuery('.menu-btn, .openbtn').on('click', function () {
			jQuery('.content-sidebar').addClass('active');
		});
		jQuery('.menu-close').on('click', function () {
			jQuery('.content-sidebar').removeClass('active');
			jQuery('.menu-btn').removeClass('open');
			jQuery('.menu-backdrop').remove();
		});

		jQuery('.dz-carticon').on('click', function () {
			jQuery(this).toggleClass('active');
		});
		jQuery('.dz-wishicon').on('click', function () {
			jQuery(this).toggleClass('active');
		});
	}
	
	var dzLoader = function () {
		$(document).ready(function () {
			setTimeout(function () {
				$(".dz-loader-info *").css({
					"transition": "transform 0.5s ease, opacity 0.5s ease",
					"transform": "translateY(-100px)",
					"opacity": "0"
				});

				const svg = $("#svg");
				svg.css({
					"transition": "d 0.5s ease"
				});
				svg.attr("d", "M0 502S175 272 500 272s500 230 500 230V0H0Z");
				setTimeout(function () {
					svg.attr("d", "M0 2S175 1 500 1s500 1 500 1V0H0Z");
				}, 500);;

				const dzLoaderWrap = $(".dz-loader");
				dzLoaderWrap.css({
					"transition": "transform 5s ease",
					"transform": "translateY(-1500px)"
				});
			}, 1500);
		});
	}

	var kenburnSlider = function(){
		if($("#kenburn").length > 0){
			$("#kenburn").slippry({
				transition: 'kenburns',
				useCSS: true,
				speed: 8000,
				pause: 3000,
				auto: true,
				preload: 'visible',
				autoHover: false
			});
		}
	}
	
	var handleW3Menu = function () {
		const menuToggler = document.querySelector('.w3menu-toggler');
		
		if (menuToggler) {
			const body = document.querySelector('body');
			const menuClose = document.querySelector('.menu-close');
			
			const target = menuToggler.getAttribute('data-target');
			const targetElement = document.querySelector(target);
			
			menuToggler.addEventListener('click', function(){
				menuToggler.classList.add('open');
				body.classList.add('fixed');
				targetElement.classList.add('show');
			});
			
			menuClose.addEventListener('click', function(){
				menuToggler.classList.remove('open');
				body.classList.remove('fixed');
				targetElement.classList.remove('show');
			});
		}
	}
	
	var handleSearching = function(){		
		jQuery('.dz-search-input').on('input', function(e) {
			jQuery('.faq-head').addClass('active-search')
		});
		
		jQuery('.item-search').on('submit',function(e){
			e.preventDefault()
		})
		
		jQuery('.dz-search-input').on('keyup', function(e) {
			var value = jQuery(this).val().toLowerCase();
				jQuery(".dz-search-item .accordion-item").filter(function(index, item) {
					jQuery(this).toggle(jQuery(this).text().toLowerCase().indexOf(value) > -1);
					
				});
			
			setTimeout(() => {
				jQuery(".faq-head").removeClass('active-search')
			}, 2000);
		});
	}
	
	var handleYithWcqvButton = function(){
		jQuery('.yith-wcqv-button').on('click', function () {
			setTimeout(function(){	
				handleBootstrapTouchSpin();
			}, 3000);
		});
		jQuery(document.body).on( 'updated_cart_totals', function(){
			handleBootstrapTouchSpin();
		});
	}
	
	var handleSkrollr = function (){
		//if (window.innerWidth >= 1191) {
		if (typeof skrollr !== 'undefined'){
			if (window.innerWidth >= 1191) {
				skrollr.init({
					forceHeight: false
				});
			}else {
				skrollr.init().destroy();
			}
		}
		/* if(jQuery('.skrollr, .no-skrollr').length > 0)
		{
			if (screenWidth >= 1191) {
				skrollr.init({
					forceHeight: false
				});
			}else {
				skrollr.init().destroy();
			}
		} */
	}
	function resizemenu(){
		if (jQuery(window).width() <= 1200) {
			jQuery('.dz-mega-menu-mobile').removeClass('d-none');
			jQuery('.dz-mega-menu').addClass('d-none');
		}else{
			jQuery('.dz-mega-menu').removeClass('d-none');
			jQuery('.dz-mega-menu-mobile').addClass('d-none');
		}
	};
	
	// Scroll To Top ============
	var handleScrollTop = function () {
		const scrollTop = document.querySelector('.scroltop');
		
		if(scrollTop){
			window.addEventListener('scroll', function() {
				const scrollEl = window.scrollY;
				
				if (scrollEl > 500) {
					scrollTop.classList.add('show');
				} else {
					scrollTop.classList.remove('show');
				}
			});
			
			scrollTop.addEventListener('click', function() {
				window.scrollTo({
					top: 0,
					behavior: 'smooth'
				});
			});
		}
	}
	
	var handleBtnHover3 = function () {
		document.querySelectorAll('.btn-hover3').forEach(button => {
			// Get the button text
			const text = button.innerText;

			// Create the original div
			const originalDiv = document.createElement('div');
			originalDiv.classList.add('main-text');
			originalDiv.innerText = text;

			// Create the letters div
			const lettersDiv = document.createElement('div');
			lettersDiv.classList.add('split-text');

			// Split the text into individual letters and wrap them in span
			text.split('').forEach(letter => {
			const span = document.createElement('span');
			span.innerText = letter;
			lettersDiv.appendChild(span);
			});

			// Clear the button text and append the original and letters divs
			button.innerHTML = '';
			button.appendChild(originalDiv);
			button.appendChild(lettersDiv);
		});
	}
	
	
	/* Function ============ */
	return {
		init: function(){
			boxHover();
			onePageLayout();
			dzTheme();
			homeSearch();
			MagnificPopup();
			scrollTop();
			headerFix();
			handleVideo();
			handleCountDown(WebsiteLaunchDate);
			handleBannerResize();
			handelResize();
			jQuery('.modal').on('show.bs.modal', reposition);
			priceslider();
			handleCurrentActive();
			handleShopCart();
			handleBootstrapTouchSpin();
			handleSelectpicker();
			handleSmartWizard();
			dzCategoryToggle();
			heartBlast();
			handleComingSoonCounter();
			handleShopPannel();
			handleHeaderMenuItem();
			cartButton();
			handleColorFilter();
			handleLightgallery();
			menuHover();
			handleSearching();
			handleSearching();
			navScroller();
			handleMultiScroll();
			handleMagnifyGallery();
			wow_animation();
			handleW3Menu();
			contactform();
			dzLoader();			
			//kenburnSlider();
			handleScrollTop();
			handleBtnHover3();
			handleYithWcqvButton();
			
		},

		load:function(){
			counter();
			masonryBox();
			handleMultipleImageSize();
			jQuery('.modal').on('show.bs.modal', reposition);
			wcPriceUpdate();
			//handleProductFilter();
			
		},
		
		resize:function(){
			screenWidth = jQuery(window).width();
			dzTheme();
			masonryBox();
			handleMultipleImageSize();
			handleMagnifyGallery();
			resizemenu();
			//handleProductFilter();
			//handleFinalCountDown();
		},
		scroll:function(){
			screenWidth = jQuery(window).width();
			handleMapScroll();
			//handleSkrollr();
		},


	}
	
}();


/* Document.ready Start */	
jQuery(document).ready(function() {
   'use strict';
	ClinicMaster.init();
	
	if(jQuery(".wpcf7-form-control").length > 0) {
		jQuery('.wpcf7-select button').addClass('form-control');
		jQuery('.wpcf7-select button').addClass('bs-label');
		jQuery('.wpcf7-select').on('change', function(){
			jQuery('.wpcf7-select button').removeClass('bs-label');
		});
		
	}
	if(jQuery(".wpcf7-form input.wpcf7-submit").length > 0) {
		jQuery(".wpcf7-form input.wpcf7-submit").each(function(){
			jQuery(this).parent().addClass('wpcf7-submit-main');
		});
	}
});
/* Document.ready END */

/* Window Load START */
jQuery(window).on('load',function () {
	'use strict'; 
	/* return false; */
	ClinicMaster.load();
	
	setTimeout(function(){
		jQuery('#loading-area').remove();
	}, 1000);
	
});
/*  Window Load END */




/* Window scroll START */
jQuery(window).on('scroll',function () {
	'use strict'; 
	ClinicMaster.scroll();
});
/*  Window scroll END */


/* Window Resize START */
jQuery(window).on('resize',function () {
	'use strict'; 
	ClinicMaster.resize();
	
});
})(jQuery);	
/*  Window Resize END */






