<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZServiceDetail1 extends Widget_Base 
{
	public function get_name() {
		return 'dz-service-detail-1';
	}
	
	public function get_title() {
		return esc_html__('Service Details 1',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-single-page';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'service_detail_1_element_image',
			[
				'label' => esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' => Controls_Manager::MEDIA,
				
				
			]
		);
		
		$this->add_control(
			'service_detail_1_element_title',
			[
				'label' => esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Angioplasty', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'service_detail_1_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',				
				'default'=> '<p>' . esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.',DZ_TH_DOMAIN) . '</p><p>' .
				esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry`s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including.',DZ_TH_DOMAIN) . '</p>',
				'rows'		=>  5, 
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'service_detail_1_element_list_title',
			[
				'label' => esc_html__( 'List Title', DZ_TH_DOMAIN ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' => esc_html__( 'Steps in Angioplasty', DZ_TH_DOMAIN ),
				
			]
		); 
		
		$this->add_control(
			'service_detail_1_element_list',
			[
				'label' 	  => esc_html__( 'Enter List.', DZ_TH_DOMAIN ),
				'show_label'  => true,
				'label_block' => true,
				'type' 		  => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter List. Here', DZ_TH_DOMAIN ),
				'separator'	  =>  'default',				
				'rows'		  =>  5,
				'description' => esc_html__( 'Enter Comma Saprated List Text', DZ_TH_DOMAIN ),
				'default'	  =>  esc_html__('Comprehensive Specialties, Research and Development, Emergency Services, Advanced Imaging Services, Intensive Care Units (ICUs),Rehabilitation Services, Telemedicine Facilities, Patient-Centric Approach,Multidisciplinary Team,Health Information Technology', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'team',
			[
				'label' => esc_html__( 'Team Section', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'service_detail_1_element_show_team',
			[
				'label' => esc_html__( 'Show Team', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		$this->add_control(
			'service_detail_1_element_team_title',
			[
				'label' 		=> esc_html__( 'Team Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Available Doctors Under Surgery ', DZ_TH_DOMAIN ),
				'condition' => [
					'service_detail_1_element_show_team' => 'yes',
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'faq',
			[
				'label' => esc_html__( 'Faq Section', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'service_detail_1_element_show_faq',
			[
				'label' => esc_html__( 'Show Faq', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
		$this->add_control(
			'service_detail_1_element_faq_title',
			[
				'label' 		=> esc_html__( 'Faq Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Frequently asked questions ', DZ_TH_DOMAIN ),
				'condition' => [
					'service_detail_1_element_show_faq' => 'yes',
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'sidebar',
			[
				'label' => esc_html__( 'Sidebar Section', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'service_detail_1_element_selected_sidebar',
			[
				'label' 	 => esc_html__( 'Choose Sidebar', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebars(),	
			]
		);
		
		$this->add_control(
			'service_detail_1_element_sidebar_layout',
			[
				'label' 	 => esc_html__( 'Sidebar Selection', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => dz_get_sidebar_layout_options_list(),				
				'default'	 =>  'left',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/service_detail_1_element.php',$settings);
		
	}
	
	protected function content_template() 
	{

    }
}