<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZHomeBanner2 extends Widget_Base 
{
	public function get_name() {
		return 'dz-home-banner-2';
	}
	
	public function get_title() {
		return esc_html__('Home Banner 2',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-banner';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_2_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Get Beautiful Straight ', DZ_TH_DOMAIN ).'<span class="smile">'.esc_html__( 'Smile', DZ_TH_DOMAIN ).'<svg width="207" height="44" viewBox="0 0 207 44" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9 12C83 50 121.2 54.4 198 12" stroke="var(--bs-primary)" stroke-width="3"/><path d="M14 1L2 23" stroke="var(--bs-primary)" stroke-width="3"/><path d="M193 1L205 23" stroke="var(--bs-primary)" stroke-width="3"/></svg></span>'.esc_html__( 'Quickly ', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'home_banner_2_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Experienced staff is dedicated to improving our patients’ dental health and enhancing', DZ_TH_DOMAIN ),
			]
		);

		$this->add_control(
			'home_banner_2_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'user',
			[
				'label' => esc_html__( 'User', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_user_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Available Doctors', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_user_subtitle',
			[
				'label' 		=> esc_html__( 'SubTitle', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your subtitle', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Select Doctor', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_2_element_user_img',
			[
				'label' 		=> esc_html__( 'User Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_2_element_user_name',
			[
				'label' 		=> esc_html__( 'User Name', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Olivia Davis', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_user_position',
			[
				'label' 		=> esc_html__( 'User Position', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dentist ', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_user_img2',
			[
				'label' 		=> esc_html__( 'User Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'home_banner_2_element_user_name2',
			[
				'label' 		=> esc_html__( 'User Name 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'William Martinez', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_user_position2',
			[
				'label' 		=> esc_html__( 'User Position 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dentist ', DZ_TH_DOMAIN ),
			]
		);
		

		$this->add_control(
			'home_banner_2_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Taxt', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Book appointment', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your button link', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'gallery',
			[
				'label' => esc_html__( 'Gallery', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_2_element_gallery_img',
			[
				'label' 		=> esc_html__( 'Gallery Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		
		$this->add_control(
			'home_banner_2_element_gallery_img2',
			[
				'label' 		=> esc_html__( 'Gallery Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::GALLERY,
			]
		);
		
		$this->add_control(
			'home_banner_2_element_gallery_text',
			[
				'label' 		=> esc_html__( 'Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Talk to over 215 doctor', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_link',
			[
				'label' 		=> esc_html__( 'Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your url', DZ_TH_DOMAIN ),
			]
		);
		
		$this->end_controls_section(); 
		
		$this->start_controls_section(
			'rating',
			[
				'label' => esc_html__( 'Rating', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'home_banner_2_element_rating',
			[
				'label' 		=> esc_html__( 'Rating', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your rating', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '4.8', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_rating_text',
			[
				'label' 		=> esc_html__( 'Rating Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default'   => esc_html__( '12k+ ratings on google', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'home_banner_2_element_star_rating',
			[
				'label' => esc_html__( 'Star Rating', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 5,
				'default' => 5,
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/home_banner_2_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}