<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZContentBox6 extends Widget_Base 
{
	public function get_name() {
		return 'dz-content-box-6';
	}
	
	public function get_title() {
		return esc_html__('Content Box 6',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-posts-group';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		
		
		$this->add_control(
			'content_box_6_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'What is Dental Implants Restoration?', DZ_TH_DOMAIN ),
			]
		);
		
		
		$this->add_control(
			'content_box_6_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'A dental implant is designed to replace one or more teeth in your mouth. Typically made of titanium, implants are surgically inserted into the jawbone. Over several months, the implant fuses with the bone, becoming a solid and stable part of your smile. After the implant heals, we can place single crowns, bridges, or even full dentures over them.', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_6_element_feature_title',
			[
				'label' 		=> esc_html__( 'Feature Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Why is Dental Implants Restoration needed?', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'content_box_6_element_feature_description',
			[
				'label' 	=> esc_html__( 'Enter Feature Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Feature Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Feature Description Here', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'Dental implant restoration is often necessary if you re missing one or more of your natural teeth. Missing teeth can be more than just a cosmetic issue; it can make eating, chewing, and even speaking difficult. Fortunately, dental implants can replace what you re missing, improving both your smile and your quality of life.', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_6_element_img',
			[
				'label' 		=> esc_html__( 'Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'content_box_6_element_image_align',
			[
				'label' => esc_html__( 'Image Position', DZ_TH_DOMAIN ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-left',
					],
					
					'right' => [
						'title' => esc_html__( 'Right', DZ_TH_DOMAIN ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				
			]
		);
		
		
		$this->end_controls_section();
		
		
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'content_box_6_element_img_class',
			[
				'label' 		=> esc_html__( 'Image Class ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your css class', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->add_control(
			'content_box_6_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner-2',
			]
		);
		
		$this->end_controls_section(); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/content_box_6_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}