<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZBeforeAfterImage extends Widget_Base 
{
	public function get_name() {
		return 'dz-before-after-image';
	}
	
	public function get_title() {
		return esc_html__('Before After Image',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-image-before-after';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'before_after_image_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		
		$this->add_control(
			'before_after_image_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default'   => esc_html__( 'After Treatment', DZ_TH_DOMAIN ),
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		
		$this->add_control(
			'before_after_image_element_before_img',
			[
				'label' 		=> esc_html__( 'Before Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'before_after_image_element_after_img',
			[
				'label' 		=> esc_html__( 'After Image', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		
		$this->add_control(
			'before_after_image_element_before_img2',
			[
				'label' 		=> esc_html__( 'Before Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		$this->add_control(
			'before_after_image_element_after_img2',
			[
				'label' 		=> esc_html__( 'After Image 2', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		
		$this->add_control(
			'before_after_image_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'View All', DZ_TH_DOMAIN ),
				'condition' => [
					'before_after_image_element_style' => 'style_2',
				],
			]
		);
		
		$this->add_control(
			'before_after_image_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				'condition' => [
					'before_after_image_element_style' => 'style_2',
				],
			]
		);
		
		$this->add_control(
			'before_after_image_element_css_class',
			[
				'label' 		=> esc_html__( 'Css Class', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your class', DZ_TH_DOMAIN ),
				'default' 		=> 'bg-bottom-half-white',
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		
		
		
		$this->end_controls_section();
		
		
		$this->start_controls_section(
			'extra',
			[
				'label' => esc_html__( 'Extra', DZ_TH_DOMAIN ),
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		
		
		$this->add_control(
			'before_after_image_element_content',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::SELECT,
				'options'	 => array(
								''=> esc_html__('Choose Content', DZ_TH_DOMAIN),
								'content-inner'   => esc_html__('Content Inner',DZ_TH_DOMAIN),
								'content-inner-1' => esc_html__('Content Inner 1',DZ_TH_DOMAIN),
								'content-inner-2' => esc_html__('Content Inner 2',DZ_TH_DOMAIN),
								'content-inner-3' => esc_html__('Content Inner 3',DZ_TH_DOMAIN),
								'content-inner-4' => esc_html__('Content Inner 4',DZ_TH_DOMAIN),
							),				
				'default'	 =>  'content-inner',
				'condition' => [
					'before_after_image_element_style' => 'style_1',
				],
			]
		);
		
		$this->end_controls_section(['condition' => [
					'before_after_image_element_style' => 'style_1',
				],]); 
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/before_after_image_element.php',$settings);
		echo "<script>
				jQuery(document).ready(function(){
					if(jQuery('.elementor-element-edit-mode').length > 0){
						handleTwentytwenty();
					}					
				});
			 </script>
			";
		
	}
	
	protected function content_template() 
	{

    }
}