<?php

namespace DZElementor\Widgets;

use Elementor\Widget_Base;

use Elementor\Controls_Manager;

class DZAppointment extends Widget_Base 
{
	public function get_name() {
		return 'dz-appointment';
	}
	
	public function get_title() {
		return esc_html__('Appointment',DZ_TH_DOMAIN);
	}
	
	public function get_icon() {
		return 'eicon-post-list';
		}
	
	public function get_categories() {
		return [ 'clinicmaster' ];
	}
	
	protected function register_controls() {
		
		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'appointment_element_style',
			[
				'label' 		=> esc_html__( 'Element Style', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::SELECT,
				'options' 	=> 	array(
					'style_1' => esc_html__( 'Style 1', DZ_TH_DOMAIN ),
					'style_2' => esc_html__( 'Style 2', DZ_TH_DOMAIN ),
					'style_3' => esc_html__( 'Style 3', DZ_TH_DOMAIN ),
					'style_4' => esc_html__( 'Style 4', DZ_TH_DOMAIN ),
				),
				'default'   => 'style_1',
				
			]
		);
		$this->add_control(
			'appointment_element_css_class',
			[
				'label' 	 => esc_html__( 'Section Spacing', DZ_TH_DOMAIN ),
				'show_label' => true,
				'label_block'=> true,
				'type' 		 => Controls_Manager::TEXT,	
				'default'	 =>  'p-t0',
				'condition' => [
					'appointment_element_style' => 'style_2',
				],
			]
		);
		
		
		$this->add_control(
			'appointment_element_title',
			[
				'label' 		=> esc_html__( 'Title', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Schedule Your Consultation Today!', DZ_TH_DOMAIN ),
			]
		);
		$this->add_control(
			'appointment_element_description',
			[
				'label' 	=> esc_html__( 'Enter Description.', DZ_TH_DOMAIN ),
				'show_label'=> true,
				'label_block' => true,
				'type' 		 => Controls_Manager::TEXTAREA,
				'placeholder'=> esc_html__( 'Enter Description. Here', DZ_TH_DOMAIN ),
				'separator'	=>  'default',
				'rows'		=>  5,
				'description'=> esc_html__( 'Enter Description Here', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Dermatologists use botulinum toxin therapy to reduce signs of aging and to treat hyperhidrosis, a medical condition characterized by excessive sweating', DZ_TH_DOMAIN ),
				'condition' => [
					'appointment_element_style' => 'style_4',
				],
			]
		);
		$this->add_control(
			'appointment_element_bg_img',
			[
				'label' 		=> esc_html__( 'Background Image ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'appointment_element_style' => array('style_1','style_3','style_4'),
				],
			]
		);
		$this->add_control(
			'appointment_element_img',
			[
				'label' 		=> esc_html__( 'Image ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'appointment_element_style' => array('style_2','style_3','style_4'),
				],
			]
		);
		$this->add_control(
			'appointment_element_item_img',
			[
				'label' 		=> esc_html__( 'Item Image 1 ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'appointment_element_style' => 'style_3',
				],
			]
		);
		$this->add_control(
			'appointment_element_item_img2',
			[
				'label' 		=> esc_html__( 'Item Image 2 ', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::MEDIA,
				'condition' => [
					'appointment_element_style' => 'style_3',
				],
			]
		);
		
		$this->add_control(
			'appointment_element_contact_us',
			[
				'label' => esc_html__( 'Contact Info', DZ_TH_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', DZ_TH_DOMAIN ),
				'label_off' => esc_html__( 'Hide', DZ_TH_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'appointment_element_style' => 'style_4',
				],
			]
		);
		$this->add_control(
			'appointment_element_button_text',
			[
				'label' 		=> esc_html__( 'Button Text', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your text', DZ_TH_DOMAIN ),
				'default' 		=> esc_html__( 'Appointment', DZ_TH_DOMAIN ),
			]
		);
		
		$this->add_control(
			'appointment_element_button_link',
			[
				'label' 		=> esc_html__( 'Button Link', DZ_TH_DOMAIN ),
				'label_block' 	=> true,
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your link', DZ_TH_DOMAIN ),
				
			]
		);
		
		$this->end_controls_section();
		
		

	}
	
	protected function render() 
	{

        $settings = $this->get_settings_for_display();
		
		DZTemplate::show_dz_template('dz-inc/elementor/elements/appointment_element.php',$settings);
		
		
	}
	
	protected function content_template() 
	{

    }
}