<?php
if( !function_exists('dexignzone_dzbase') ) {
	function dexignzone_dzbase()
	{
		return $GLOBALS['_dz_base'];
	}
}

if( !function_exists( 'dz_theme_color_scheme' ) )
{
	function dz_theme_color_scheme()
	{	
		$options = dexignzone_dzbase()->option();
		$dir = DZ_TH_ROOT;
		include_once($dir.'/includes/thirdparty/lessc.inc.php');
		$styles = dexignzone_dzbase()->option('custom_color_scheme');
		
		if( ! $styles ) return;	
		
		$transient = get_transient( '_dz_color_scheme' );
		
	
		$update = ( $styles != $transient ) ? true : false;
		if(dz_set($options, 'color_scheme') == 'custom') wp_enqueue_style( 'custom_colors', dexignzone_dzbase()->includes( 'assets/css/colors.css', true ) );
			
		set_transient( '_dz_color_scheme', $styles, DAY_IN_SECONDS );
		
		$less = new lessc;
	
		$less->setVariables(array(
		  "dz_color" => $styles,
		));
		
		// create a new cache object, and compile
		$cache = $less->cachedCompile( dexignzone_dzbase()->includes("/assets/css/color.less" ) );
	
		file_put_contents( dexignzone_dzbase()->includes('/assets/css/colors.css'), $cache["compiled"]);
		
	}
}

function dz_get_categories($arg = false, $by_slug = false, $show_all = true)
{
	global $wp_taxonomies;
	
	$dexignzone_dropdown_categories_args = array(
		'orderby'   => 'name', 
		'order'     => 'ASC', 			
		'hide_empty'    => false
    );
	
	
	if( ! empty($arg['taxonomy']) && isset($wp_taxonomies[$arg['taxonomy']]))
	{
		$dexignzone_dropdown_categories_args['taxonomy'] = $arg['taxonomy'];
	}	
	
	$categories = get_categories($dexignzone_dropdown_categories_args);
	  
	$cats = array();
	//if( $show_all ) $cats[] = esc_html__( 'All Categories', 'dexignzone' );
	
	if( !is_wp_error( $categories ) ) 
	{
		foreach($categories as $category)
		{
			if( $by_slug ) 
			{$cats[$category->slug] = $category->name;}
			else 
			{$cats[$category->term_id] = $category->name;}
		}
	}
	
	return $cats;
} 

function dz_get_sidebars($multi = false)
{
	global $wp_registered_sidebars;
	$sidebars = !($wp_registered_sidebars) ? get_option('wp_registered_sidebars') : $wp_registered_sidebars;
	if( $multi ) $data[] = array('value'=>'0', 'label' => 'No Sidebar');
	else $data = array('0' => esc_html__('No Sidebar', 'dexignzone'));
	
	foreach( (array)$sidebars as $sidebar)
	{
		if( $multi ) $data[] = array( 'value'=> dz_set($sidebar, 'id'), 'label' => dz_set( $sidebar, 'name') );
		else $data[dz_set($sidebar, 'id')] = dz_set($sidebar, 'name');
	}
	return $data;
}
if( !function_exists( 'dz_set' ) ) {
	function dz_set( $var, $key, $def = '' )
	{
		if( !$var ) return false;
	
		if( is_object( $var ) && isset( $var->$key ) ) return $var->$key;
		elseif( is_array( $var ) && isset( $var[$key] ) ) return $var[$key];
		elseif( $def ) return $def;
		else return false;
	}
}
function dz_get_posts_array( $post_type = 'post', $flip = false )
{
	global $wpdb;
	$res = $wpdb->get_results( "SELECT `ID`, `post_title` FROM `" .$wpdb->prefix. "posts` WHERE `post_type` = '$post_type' AND `post_status` = 'publish' ", ARRAY_A );
	
	$return = array();
	foreach( $res as $k => $r) {
		if( $flip ) {
			if( isset( $return[dz_set($r, 'post_title')] ) ) $return[dz_set($r, 'post_title').$k] = dz_set($r, 'ID');
			else $return[dz_set($r, 'post_title')] = dz_set( $r, 'ID' );
		}
		else $return[dz_set($r, 'ID')] = dz_set($r, 'post_title');
	}
	return $return;
}
function dz_base_decode($string){
	return urldecode(base64_decode($string));
}
function dz_user_extra( $extras = array() )
{
	dexignzone_dzbase()->extras = $extras;
	add_filter('user_contactmethods', 'dz_newuserfilter' );
}

function dz_newuserfilter($old)
{
	$array = dexignzone_dzbase()->extras;
	$new = array_merge($array, $old);
	return $new;
}

function dz_get_font_settings( $FontSettings = array(), $StyleBefore = '', $StyleAfter = '' )
{
	$i = 1;
	$settings = dexignzone_dzbase()->option();
	$Style = '';
	foreach( $FontSettings as $k => $v )
	{
		if( $i == 1 || $i == 5 )
		{
			$Style .= ( dz_set( $settings, $k )  ) ? $v.':'.dz_set( $settings, $k ).'px;': '';
		}
		else
		{
			$Style .= ( dz_set( $settings, $k  )  ) ? $v.':'.dz_set( $settings, $k ).' !important;': '';
		}
		$i++;
	}
	return ( !empty( $Style ) ) ? $StyleBefore.$Style.$StyleAfter: '';
}

if( !function_exists( 'dz_contact_form7' ) )
{
	function dz_contact_form7(){
		$wp_posts = get_posts(array(
		'post_type' => 'wpcf7_contact_form',
		'orderby'   => 'date',
		'order'     => 'ASC',
		));
		$result = array();
		foreach ($wp_posts as $post)
		{
		$result[ $post->ID ] = $post->post_title;
		}
		return $result;
	}
}

if( !function_exists( 'dz_get_categories' ) )
{
	function dz_get_categories($arg = false)
	{	
		die('Not Running ');
		global $wp_taxonomies;		
		
		$dexignzone_categories_default_args = array(	
				'orderby'            => 'ID',
				'order'              => 'ASC',				
				'hide_empty'         => 1,				
				'hierarchical'       => true,				
		  );
		
		if( ! empty($arg['taxonomy']) && isset($wp_taxonomies[$arg['taxonomy']]) )
		{
			$dexignzone_categories_default_args['taxonomy'] = wp_kses_post($arg['taxonomy']);
		}
		
		$categories = get_categories($dexignzone_categories_default_args);		
		$cats = array();
		
		if( !is_wp_error( $categories ) ) {
			foreach($categories as $category)
			{
				$cats[$category->slug] = wp_kses_post($category->name);				
			}
		}
		return $cats;
	}
}

if( !function_exists( 'dz_generate_rand_number' ) )
{
	function dz_generate_rand_number($digit=6)
	{
	  $no = substr(strtoupper(md5(uniqid(rand()))),0,$digit);
	  return $no;
	}
}

if( !function_exists( 'dz_search_meta_value' ) )
{
	function dz_search_meta_value($post_type,$meta_key,$meta_value,$status = '')
	{
	   $post = array();
	   $query_args = array(	
			'post_type'	=> 'dz_customer_inquiry',
			'meta_key'	=>	$meta_key,
			'meta_value'=>	$meta_value,
			'meta_compare'=>'='
		);
		
		if(!empty($status))
		{
			$query_args['post_status'] = $status;
		}
		
		$query = new WP_Query($query_args);	
		
		if($query->have_posts()) {
			$post =  (array) $query->posts[0];
		}
		
		return $post;
	}
}

if(!function_exists('dz_is_plugin_active'))
{
	function dz_is_plugin_active($plugin_file_path){
		if ( 
		  in_array( 
			$plugin_file_path, 
			apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) 
		  ) 
		) {
			return true;
		}else{
			return false;
		}
	}
}

/* Remove type attribute from included CSS/JS files */

if(!function_exists('dz_remove_type_attr'))
{
	function dz_remove_type_attr($tag, $handle) 
	{
		return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
	}
}

add_filter('style_loader_tag', 'dz_remove_type_attr', 10, 2);
add_filter('script_loader_tag', 'dz_remove_type_attr', 10, 2);

if( !function_exists( 'dexignzone_get_opt' ) )
{
	function dexignzone_get_opt( $opt_id, $default = false ) {
		$opt_name = dexignzone_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}

		global ${$opt_name};
		if ( ! isset( ${$opt_name} ) || ! isset( ${$opt_name}[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || $options[ $opt_id ] === '' ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && $value === '' ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}
}

/**
 * Get theme option based on its id.
 *
 * @param  string $opt_id Required. the option id.
 * @param  mixed $default Optional. Default if the option is not found or not yet saved.
 *                         If not set, false will be used
 *
 * @return mixed
 */
if( !function_exists( 'dexignzone_get_opt' ) )
{
	function dexignzone_get_opt( $opt_id, $default = false ) {
		$opt_name = dexignzone_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}

		global ${$opt_name};
		if ( ! isset( ${$opt_name} ) || ! isset( ${$opt_name}[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || $options[ $opt_id ] === '' ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && $value === '' ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}
}


/**
 * Get opt_name for Redux Framework options instance args and for
 * getting option value.
 *
 * @return string
 */
if( !function_exists( 'dexignzone_get_opt_name' ) )
{ 
	function dexignzone_get_opt_name() {
		return apply_filters( 'dexignzone_opt_name', 'clinicmaster_theme_options' );
	}
}

if( !function_exists( 'dexignzone_latest_sticky' ) )
{ 
	function dexignzone_latest_sticky() 
	{
		/* Get all sticky posts */
		$sticky = get_option( 'sticky_posts' );
		/* Sort the stickies with the newest ones at the top */
		rsort( $sticky );
		/* Get the 5 newest stickies (change 5 for a different number) */
		$sticky = array_slice( $sticky, 0, 5 );
		/* Query sticky posts */
		$the_query = new WP_Query( array( 'post__in' => $sticky, 'ignore_sticky_posts' => 1 ) );
		// The Loop
		if ( $the_query->have_posts() ) 
		{
			$result .= '<ul>';
			while ( $the_query->have_posts() ) 
			{
				$the_query->the_post();
				$result .= '<li><a href="' .get_permalink(). '" title="'  . get_the_title() . '">' . get_the_title() . '</a><br />' . get_the_excerpt(). '</li>';
				 
			}
			$result .= '</ul>';
		} 
		else 
		{
			// no posts found
		}
		/* Restore original Post Data */
		wp_reset_postdata();
		return $result; 
	} 
	add_shortcode('latest_stickies', 'clinicmaster_latest_sticky');
}	

if( !function_exists( 'dz_get_cpt_category' ) )
{ 
	function dz_get_cpt_category($cpt_taxonomy,$key='term_id') 
	{
		$categories_options = get_terms($cpt_taxonomy,array('hide_empty'=>false));
		//$categories_options = wp_list_pluck( $categories_options, 'name', 'term_id');  
		$categories_options = wp_list_pluck( $categories_options, 'name', $key);  
		$categories_options = array(0=>'Choose Category') + $categories_options ;
		$categories_options = array_flip($categories_options) ;
		
		return $categories_options;
	}
}



function clinicmaster_get_ws_data($options)
{
	$dzRes = array();
	$dzRes['comingsoon_bg'] = dz_set($options, 'comingsoon_bg');	
	$dzRes['comingsoon_page_title'] = dz_set($options, 'comingsoon_page_title');
	$dzRes['comingsoon_page_desc'] = dz_set($options, 'comingsoon_page_desc');
	$dzRes['comingsoon_page_placeholder_text'] = dz_set($options, 'comingsoon_page_placeholder_text');
	$dzRes['comingsoon_page_url'] = dz_set($options, 'comingsoon_page_url');
	$dzRes['comingsoon_bg'] = !empty($dzRes['comingsoon_bg']['url'])?$dzRes['comingsoon_bg']['url']:get_template_directory_uri() . '/assets/images/bg8.jpg';
	
	/* Manage Subscription Form */
	$dzRes['comingsoon_subscribe_on'] = clinicmaster_set($options, 'comingsoon_subscribe_on');
	$dzRes['subscribe_popup_title'] = clinicmaster_set($options, 'subscribe_popup_title','SUBSCRIBE TO OUR NEWSLATTER');
	$dzRes['subscribe_popup_image'] = !empty($dzRes['subscribe_popup_image']['url'])?$dzRes['subscribe_popup_image']['url']:get_template_directory_uri() . '/assets/images/img1.jpg';
	
	/* End Manage Subscription Form */
	
	
	/* Maintenence Page Settings */
	$dzRes['maintenance_bg'] = dz_set($options, 'maintenance_bg');
	$dzRes['maintenance_bg'] = !empty($dzRes['maintenance_bg']['url'])?$dzRes['maintenance_bg']['url']:get_template_directory_uri() . '/assets/images/background/under-construct.png';
	$dzRes['maintenance_template'] = clinicmaster_set($options, 'maintenance_template', 'maintenance_template_1');
	$dzRes['maintenance_icon'] = dz_set($options, 'maintenance_icon');
	$dzRes['maintenance_icon'] = !empty($dzRes['maintenance_icon']['url'])?$dzRes['maintenance_icon']['url']:get_template_directory_uri() . '/assets/images/warning.png';
	
	$dzRes['maintenance_title'] = dz_set($options, 'maintenance_title');
	$dzRes['maintenance_desc'] = dz_set($options, 'maintenance_desc');
	
	$dzRes['maintenence_vlc'] = get_template_directory_uri().'/assets/images/vlc.png';
	/* Maintenence Page Settings END */
	
	return $dzRes;
}



function dz_subscription_form()
{
	$comingsoon_subscribe_on = dexignzone_get_opt('comingsoon_subscribe_on');
	$header_subscribe_on     = dexignzone_get_opt('header_subscribe_on');
	$subscribe_popup_image = dexignzone_get_opt('subscribe_popup_image');
	$subscribe_popup_title = dexignzone_get_opt('subscribe_popup_title');
	
	$subscribe_popup_image = !empty($subscribe_popup_image['url'])?$subscribe_popup_image['url']:'';
	
	if($comingsoon_subscribe_on){	
		echo  '<!-- InquiryModal -->
	<div class="modal fade inquiry-modal" id="SubscribeModal" tabindex="-1" role="dialog" aria-labelledby="SubscribeModal" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="inquiry-adv">
				<img src="'.esc_url($subscribe_popup_image).'" alt="'.esc_attr('Image','clinicmaster').'"/>
			</div>
			<div class="modal-content">
				<div class="modal-header">
					<i class="fa-solid fa-envelope"></i>
					<h5 class="modal-title" id="exampleModalLongTitle">'.esc_html($subscribe_popup_title).'</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">&times;</button>
				</div>
				<div class="modal-body">					
					<form action="#" method="post" class="dz-subscription dzForm">
						<div class="input-group mb-3">
							<input name="dzName" required="required" type="text" class="form-control" placeholder="'.esc_attr__('Your Name','clinicmaster').'">
						</div>
						<div class="input-group mb-3">
							<input name="dzEmail" required="required" type="email" class="form-control" placeholder="'.esc_attr__('Your Email Address','clinicmaster').'">
						</div>
						<div class="form-group text-center">
							<button name="submit" type="submit" value="'.esc_attr__('Submit','clinicmaster').'" class="btn btn-dark effect">'.esc_html__('SUBSCRIBE NOW', 'clinicmaster').' </button>
						</div>
						<div class="dzSubscribeMsg dz-subscription-msg"></div>
					</form>
				</div>
			</div>
		</div>
	</div>';
		
		
	}
	
	
	/* header subscribe form END */
	
	
}

add_action('clinicmaster_subscription', 'dz_subscription_form');


/*

Woo-Commerce Functions

*/
function clinicmaster_yith_ajax_frontend_js_update($vars){
	wp_deregister_script('yith-wcan-script');
	wp_enqueue_script( 'yith-wcan-script', get_template_directory_uri(). '/assets/js/yith-wcan-frontend-min.js', array( 'jquery', 'jseldom' ), '1.0', true );
	return $vars;
}
add_action('yith_wcan_frontend_args','clinicmaster_yith_ajax_frontend_js_update',20,1);



if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_get_items_count' ) ) {
  function yith_wcwl_get_items_count() {
	 
    ob_start();
    echo esc_html( yith_wcwl_count_all_products() ); 
    return ob_get_clean();
  }

  add_shortcode( 'yith_wcwl_items_count', 'yith_wcwl_get_items_count' );
}


if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_ajax_update_count' ) ) {
  function yith_wcwl_ajax_update_count() {
    wp_send_json( array(
      'count' => yith_wcwl_count_all_products()
    ) );
  }

  add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
  add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
}

if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_enqueue_custom_script' ) ) {
  function yith_wcwl_enqueue_custom_script() {
    wp_add_inline_script(
      'jquery-yith-wcwl',
      "
        jQuery( function( $ ) {
          $( document ).on( 'added_to_wishlist removed_from_wishlist', function() {
            $.get( yith_wcwl_l10n.ajax_url, {
              action: 'yith_wcwl_update_wishlist_count'
            }, function( data ) {
				
              $('.yith-wcwl-items-count').html( data.count );
			} );
          } );
        } );
      "
    );
  }

  add_action( 'wp_enqueue_scripts', 'yith_wcwl_enqueue_custom_script', 20 );
}

function dz_get_file_contents($path){
	if($_SERVER['HTTP_HOST'] == '192.168.29.88'){
		$icon = str_replace('https','http',$path);
	}else{
		$icon = $path;
	}
	if(class_exists('WP_Filesystem_Direct')){
		$wp_filesystem = new WP_Filesystem_Direct(null);
	   echo  $wp_filesystem->get_contents($icon);
	}
}