<?php
class Dexignzone_DZ_Post_types
{
	
	function __construct()
	{
		// Hook into the 'init' action
		
		$this->dz_slider();
		
	}
	
	function labels( $names = '', $labels = array() )
	{
		$default =  array(
			'name'                => _x( 'Slides', 'Slides', DZ_TH_DOMAIN ),
			'singular_name'       => _x( 'Slide', 'Slide', DZ_TH_DOMAIN ),
			'menu_name'           => __( 'Slidr', DZ_TH_DOMAIN ),
			'parent_item_colon'   => __( 'Parent Slide:', DZ_TH_DOMAIN ),
			'all_items'           => __( 'All Slides', DZ_TH_DOMAIN ),
			'view_item'           => __( 'View Slide', DZ_TH_DOMAIN ),
			'add_new_item'        => __( 'Add New Slide', DZ_TH_DOMAIN ),
			'add_new'             => __( 'New Slide', DZ_TH_DOMAIN ),
			'edit_item'           => __( 'Edit Slide', DZ_TH_DOMAIN ),
			'update_item'         => __( 'Update Slide', DZ_TH_DOMAIN ),
			'search_items'        => __( 'Search Slides', DZ_TH_DOMAIN ),
			'not_found'           => __( 'No Slides found', DZ_TH_DOMAIN ),
			'not_found_in_trash'  => __( 'No Slides found in Trash', DZ_TH_DOMAIN ),
		);
		
		foreach( $default as $k => $v ){
			$default[$k] = str_replace( array('Slide', 'Slides'), $names, $v);
		}
		$labels = wp_parse_args( $labels, $default );
		
		return $labels;
	}
	
	function args( $args = array() )
	{
		$default = array(
			'label'               => __( 'dz_slider', DZ_TH_DOMAIN ),
			'labels'              => array(),
			'supports'            => array( 'title', 'editor', 'thumbnail', 'custom-fields'),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'show_in_rest' 		  => false,
			'menu_position'       => 5,
			'menu_icon'           => '',
			'can_export'          => true,
			'has_archive'         => false,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'rewrite'             => array(),
			'capability_type'     => 'post',
		);
		$args = wp_parse_args( $args, $default );
		return $args;
	}
	
	// Register Custom Post Type
	function dz_slider() {
		
		$settings = include( DZ_TH_ROOT.'includes/resource/post_types.php');
		
		foreach( $options as $k => $v )
		{
			$labels = $this->labels(dz_set( $v, 'labels'), dz_set( $v, 'label_args' ) );	
	
			$rewrite = array(
				'slug'                => dz_set( $v, 'slug' ),
				'with_front'          => true,
				'pages'               => true,
				'feeds'               => false,
			);
		
			$args = $this->args( array(
								'labels'=>$labels, 
								'supports'=>dz_set( $v, 'supports'), 
								'rewrite'=>$rewrite,
								'show_in_rest'=>dz_set( $v, 'show_in_rest')
								) 
							);
			$args = wp_parse_args( dz_set( $v, 'args' ), $args );
			

			//echo '<pre>';
			//print_r($args);
			//echo '</pre>';

			register_post_type( $k, $args );
		}
	}
}