<?php
/*
Plugin Name: DZ Core
Plugin URI: https://clinicmaster.wprdx.com/plugins/dzcore.zip
Description: This plugin is compatible with this WordPress themes. 
Author: KinixThemes 
Author URI: https://themeforest.net/user/kinixthemes
Version: 1.0.0
Text Domain: dzcore
*/

$theme = wp_get_theme();



if( !defined( 'DZ_TH_ROOT' ) ) { define('DZ_TH_ROOT', plugin_dir_path( __FILE__ )); }
if( !defined( 'DZ_TH_URL' ) ) { define( 'DZ_TH_URL', plugins_url( '', __FILE__ ) ); }
if( !defined( 'DZ_TH_DOMAIN' ) ) { define( 'DZ_TH_DOMAIN', 'dzcore' ); }

define('DZ_INCLUDES', DZ_TH_ROOT . "includes/include" . DIRECTORY_SEPARATOR);

define('DZ_CSS', DZ_TH_URL . "/assets/css/");
define('DSX_URL', plugin_dir_url(__FILE__));
define('DSX_DIR', plugin_dir_path(__FILE__));


/**
 * Require functions on plugin
 */
require_once DZ_INCLUDES . "functions.php";


if ( 'ClinicMaster' == $theme->name || 'ClinicMaster-Child' == $theme->name) {
    include_once( 'includes/loader.php' );
}else{
	/* Because plug-in should not give any error by this plug-in */
	return true;
}
$active_plugins = get_option('active_plugins');
$seo_plugins = [
    'wordpress-seo/wp-seo.php',                    // Yoast SEO
    'all-in-one-seo-pack/all_in_one_seo_pack.php', // All in One SEO
    'seo-by-rank-math/rank-math.php',              // Rank Math SEO
    'wp-seopress/seopress.php',                    // SEOPress
    'the-seo-framework/the-seo-framework.php',     // The SEO Framework
    'squirrly-seo/squirrly.php',                   // Squirrly SEO
	'wp-smart-crawl/wp-smart-crawl.php',           // SmartCrawl SEO
];

$active_seo_plugins = array_intersect($seo_plugins, $active_plugins);
if (!$active_seo_plugins) {
	require_once ('includes/library/classes/seo-function.php');
}
if (!class_exists('ReduxFramework')) {
	//return true;
}

/**
 * DzThemeSupport Class
 *
 */
class DzThemeSupport {
    /**
     * Core singleton class
     *
     * @var self - pattern realization
     * @access private
     */
    private static $_instance;

    public $file;

    /**
     * Store plugin paths
     *
     * @since 1.0
     * @access private
     * @var array
     */
    private $paths = array();

    public $post_metabox = null;

    protected $post_format_metabox = null;

    protected $taxonomy_meta = null;

    protected $user_meta = null;

    public function __construct() {

        $dir = untrailingslashit(plugin_dir_path(__FILE__));
        $url = untrailingslashit(plugin_dir_url(__FILE__));
        $this->file = __FILE__;
        $this->set_paths(array(
            'APP_DIR' => $dir,
            'APP_URL' => $url
        ));
        self::includes();

        /**
         * Init function, which is run on site init and plugin loaded
         */
        add_action('init', array($this, 'dsxInit'));
        add_action('plugins_loaded', array($this, 'dsxActionInit'));
        register_activation_hook(__FILE__, array($this, 'activation_hook'));

        if (!class_exists('EFramework_menu_handle')) {
            require_once DZ_INCLUDES . 'class-menu-hanlde.php';
        }
        
        /**
         * Enqueue Scripts on plugin
         */
        //add_action('admin_enqueue_scripts', array($this, 'dsx_admin_script'));

        /**
         * widget text apply shortcode
         */
        add_filter('widget_text', 'do_shortcode');
    }

    function dsxActionInit()
    {
        global $wp_filesystem;
   
        /* Add WP_Filesystem. */
        if (!class_exists('WP_Filesystem')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            WP_Filesystem();
        }
    }

    function dsxInit()
    {
        if (apply_filters('dsx_crop_images', false)) {
	        dsx_crop_images();
        }

        if (!class_exists('ReduxFramework')) {
            add_action('admin_notices', array($this, 'redux_framework_notice'));
        }
        else {
            // Late at 30 to be sure that other extensions available via same hook.
            // Eg: Load extensions at 29 or lower.

           if (!class_exists('DSX_Post_Metabox')) {
                require_once $this->path('APP_DIR', 'includes/include/class-post-metabox.php');

                if (empty($this->post_metabox)) {
                    $this->post_metabox = new DSX_Post_Metabox();
                }
            }
        }

    }

    /**
     * Function register admin on plugin
     */
    /* function dsx_admin_script()
    {
        wp_enqueue_style('admin-style', DZ_CSS . 'admin.css', array(), '1.0.0');
		wp_enqueue_style('custom', DZ_CSS . 'custom.css', array(), '1.0.0');
        wp_enqueue_style('font-awesome', DZ_CSS . 'font-awesome.min.css', array(), 'all');
    } */

    /**
     * Setter for paths
     *
     * @since  1.0
     * @access protected
     *
     * @param array $paths
     */
    protected function set_paths($paths = array())
    {
        $this->paths = $paths;
    }

    /**
     * Gets absolute path for file/directory in filesystem.
     *
     * @since  1.0
     * @access public
     *
     * @param string $name - name of path path
     * @param string $file - file name or directory inside path
     *
     * @return string
     */
    function path($name, $file = '')
    {
        return $this->paths[$name] . (strlen($file) > 0 ? '/' . preg_replace('/^\//', '', $file) : '');
    }

    /**
     * Get url for asset files
     *
     * @since  1.0
     * @access public
     *
     * @param  string $file - filename
     * @return string
     */
    function get_url($file = '')
    {
        return esc_url($this->path('APP_URL', $file));
    }

    /**
     * Get template file full path
     * @param  string $file
     * @param  string $default
     * @return string
     */
    function get_template($file, $default)
    {
        $path = locate_template($file);
        if ($path) {
            return $path;
        }
        return $default;
    }

    function is_min()
    {
        $dev_mode = defined('WP_DEBUG') && WP_DEBUG;
        if ($dev_mode) {
            return '';
        } else {
            return '.min';
        }
    }

    /**
     * Redux Framework notices
     *
     * @since 1.0
     * @access public
     */
    function redux_framework_notice()
    {
        $plugin_name = '<strong>' . esc_html__("DzThemeSupport", DZ_TH_DOMAIN) . '</strong>';
        $redux_name = '<strong>' . esc_html__("Redux Framework", DZ_TH_DOMAIN) . '</strong>';

        echo '<div class="notice notice-warning is-dismissible">';
        echo '<p>';
        printf(
            esc_html__('%1$s require %2$s installed and activated. Please active %3$s plugin', DZ_TH_DOMAIN),
            $plugin_name,
            $redux_name,
            $redux_name
        );
        echo '</p>';
        printf('<button type="button" class="notice-dismiss"><span class="screen-reader-text">%s</span></button>', esc_html__('Dismiss this notice.', DZ_TH_DOMAIN));
        echo '</div>';
    }


    /**
     * Action handle when active plugin
     *
     * Check Redux framework active
     */
    function activation_hook()
    {
        if (is_admin()) {
            if (!is_plugin_active('redux-framework/redux-framework.php')) {
                deactivate_plugins(plugin_basename(__FILE__));

                $plugin_name = '<strong>' . esc_html__("DzThemeSupport", DZ_TH_DOMAIN) . '</strong>';
                $redux_name = '<strong>' . esc_html__("Redux Framework", DZ_TH_DOMAIN) . '</strong>';
                ob_start();

                printf(
                    esc_html__('%1$s requires %2$s installed and activated. Currently it is either not installed or installed but not activated. Please follow these steps to get %1$s up and working:', DZ_TH_DOMAIN),
                    $plugin_name,
                    $redux_name
                );

                printf(
                    "<br/><br/>1. " . esc_html__('Go to %1$s to check if %2$s is installed. If it is, activate it then activate %3$s.', DZ_TH_DOMAIN),
                    sprintf('<strong><a href="%1$s">%2$s</a></strong>', esc_url(admin_url('plugins.php')), esc_html__('Plugins/Installed Plugins', DZ_TH_DOMAIN)),
                    $redux_name,
                    $plugin_name
                );

                printf(
                    "<br/><br/>2. " . esc_html__('If %1$s is not installed, go to %2$s, search for %1$s, install and activate %1$s, then activate %3$s.', DZ_TH_DOMAIN),
                    $redux_name,
                    sprintf('<strong><a href="%1$s">%2$s</a></strong>', esc_url(admin_url('plugin-install.php?s=Redux+Framework&tab=search&type=term')), esc_html__('Plugins/Add New')),
                    $plugin_name
                );

                $message = ob_get_clean();
			}
        }
    }

    private function includes() {}

    /**
     * Get instance of the class
     *
     * @access public
     * @return object this
     */
    public static function get_instance() {
        if (!(self::$_instance instanceof self)) {
            
			self::$_instance = new self();
        }
		
		return self::$_instance;
    }
	
	
}


/**
 * Get instance of DzThemeSupport
 *
 * @since  1.0
 * @return DzThemeSupport instance
 */
function dzthemesupport()
{
    return DzThemeSupport::get_instance();
}

$GLOBALS['dzthemesupport'] = dzthemesupport();

?>